/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplatesScheme;
import com.intellij.ide.fileTemplates.InternalTemplateBean;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.ExportableFileTemplateSettings;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplateSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="FileTemplateManagerImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FileTemplateManagerImpl
extends FileTemplateManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl");
    private final State myState;
    private final FileTypeManagerEx myTypeManager;
    private final FileTemplateSettings myProjectSettings;
    private final ExportableFileTemplateSettings myDefaultSettings;
    private final Project myProject;
    private final FileTemplatesScheme myProjectScheme;
    private FileTemplatesScheme myScheme;
    private boolean myInitialized;
    private Date myTestDate;

    public static FileTemplateManagerImpl getInstanceImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getInstanceImpl"));
        }
        return (FileTemplateManagerImpl)FileTemplateManagerImpl.getInstance(project2);
    }

    public FileTemplateManagerImpl(@NotNull FileTypeManagerEx typeManager, FileTemplateSettings projectSettings, ExportableFileTemplateSettings defaultSettings, ProjectManager pm, final Project project2) {
        if (typeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeManager", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "<init>"));
        }
        this.myState = new State();
        this.myScheme = FileTemplatesScheme.DEFAULT;
        this.myTypeManager = typeManager;
        this.myProjectSettings = projectSettings;
        this.myDefaultSettings = defaultSettings;
        this.myProject = project2;
        this.myProjectScheme = project2.isDefault() ? null : new FileTemplatesScheme("Project"){

            @Override
            @NotNull
            public String getTemplatesDir() {
                String string = new File(project2.getBasePath(), ".idea/fileTemplates").getPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$1", "getTemplatesDir"));
                }
                return string;
            }

            @Override
            @NotNull
            public Project getProject() {
                Project project22 = project2;
                if (project22 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$1", "getProject"));
                }
                return project22;
            }
        };
    }

    private FileTemplateSettings getSettings() {
        return this.myScheme == FileTemplatesScheme.DEFAULT ? this.myDefaultSettings : this.myProjectSettings;
    }

    @Override
    @NotNull
    public FileTemplatesScheme getCurrentScheme() {
        FileTemplatesScheme fileTemplatesScheme = this.myScheme;
        if (fileTemplatesScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getCurrentScheme"));
        }
        return fileTemplatesScheme;
    }

    @Override
    public void setCurrentScheme(@NotNull FileTemplatesScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "setCurrentScheme"));
        }
        for (FTManager child : this.getAllManagers()) {
            child.saveTemplates();
        }
        this.setScheme(scheme);
    }

    private void setScheme(@NotNull FileTemplatesScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "setScheme"));
        }
        this.myScheme = scheme;
        for (FTManager manager : this.getAllManagers()) {
            manager.setScheme(scheme);
        }
        this.myInitialized = true;
    }

    @Override
    protected FileTemplateManager checkInitialized() {
        if (!this.myInitialized) {
            this.setScheme(this.myScheme);
        }
        return this;
    }

    @Override
    @Nullable
    public FileTemplatesScheme getProjectScheme() {
        return this.myProjectScheme;
    }

    @Override
    public FileTemplate[] getTemplates(String category) {
        if ("Default".equals(category)) {
            return (FileTemplate[])ArrayUtil.mergeArrays((Object[])this.getInternalTemplates(), (Object[])this.getAllTemplates());
        }
        if ("Includes".equals(category)) {
            return this.getAllPatterns();
        }
        if ("Code".equals(category)) {
            return this.getAllCodeTemplates();
        }
        if ("J2EE".equals(category)) {
            return this.getAllJ2eeTemplates();
        }
        throw new IllegalArgumentException("Unknown category: " + category);
    }

    @Override
    @NotNull
    public FileTemplate[] getAllTemplates() {
        Collection<FileTemplateBase> templates = this.getSettings().getDefaultTemplatesManager().getAllTemplates(false);
        FileTemplate[] fileTemplateArray = templates.toArray(new FileTemplate[templates.size()]);
        if (fileTemplateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getAllTemplates"));
        }
        return fileTemplateArray;
    }

    @Override
    public FileTemplate getTemplate(@NotNull String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getTemplate"));
        }
        return this.getSettings().getDefaultTemplatesManager().findTemplateByName(templateName);
    }

    @Override
    @NotNull
    public FileTemplate addTemplate(@NotNull String name, @NotNull String extension) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "addTemplate"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "addTemplate"));
        }
        FileTemplateBase fileTemplateBase = this.getSettings().getDefaultTemplatesManager().addTemplate(name, extension);
        if (fileTemplateBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "addTemplate"));
        }
        return fileTemplateBase;
    }

    @Override
    public void removeTemplate(@NotNull FileTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "removeTemplate"));
        }
        String qName = ((FileTemplateBase)template).getQualifiedName();
        for (FTManager manager : this.getAllManagers()) {
            manager.removeTemplate(qName);
        }
    }

    @Override
    @NotNull
    public Properties getDefaultProperties() {
        Properties props = new Properties();
        Calendar calendar = Calendar.getInstance();
        Date date = this.myTestDate == null ? calendar.getTime() : this.myTestDate;
        SimpleDateFormat sdfMonthNameShort = new SimpleDateFormat("MMM");
        SimpleDateFormat sdfMonthNameFull = new SimpleDateFormat("MMMM");
        SimpleDateFormat sdfDayNameShort = new SimpleDateFormat("EEE");
        SimpleDateFormat sdfDayNameFull = new SimpleDateFormat("EEEE");
        SimpleDateFormat sdfYearFull = new SimpleDateFormat("yyyy");
        props.setProperty("DATE", DateFormatUtil.formatDate((Date)date));
        props.setProperty("TIME", DateFormatUtil.formatTime((Date)date));
        props.setProperty("YEAR", sdfYearFull.format(date));
        props.setProperty("MONTH", FileTemplateManagerImpl.getCalendarValue(calendar, 2));
        props.setProperty("MONTH_NAME_SHORT", sdfMonthNameShort.format(date));
        props.setProperty("MONTH_NAME_FULL", sdfMonthNameFull.format(date));
        props.setProperty("DAY", FileTemplateManagerImpl.getCalendarValue(calendar, 5));
        props.setProperty("DAY_NAME_SHORT", sdfDayNameShort.format(date));
        props.setProperty("DAY_NAME_FULL", sdfDayNameFull.format(date));
        props.setProperty("HOUR", FileTemplateManagerImpl.getCalendarValue(calendar, 11));
        props.setProperty("MINUTE", FileTemplateManagerImpl.getCalendarValue(calendar, 12));
        props.setProperty("SECOND", FileTemplateManagerImpl.getCalendarValue(calendar, 13));
        props.setProperty("USER", SystemProperties.getUserName());
        props.setProperty("PRODUCT_NAME", ApplicationNamesInfo.getInstance().getFullProductName());
        props.setProperty("DS", "$");
        props.setProperty("PROJECT_NAME", this.myProject.getName());
        Properties properties = props;
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getDefaultProperties"));
        }
        return properties;
    }

    @NotNull
    private static String getCalendarValue(Calendar calendar, int field) {
        String result2;
        int val = calendar.get(field);
        if (field == 2) {
            ++val;
        }
        if ((result2 = Integer.toString(val)).length() == 1) {
            String string = "0" + result2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getCalendarValue"));
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getCalendarValue"));
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<String> getRecentNames() {
        this.validateRecentNames();
        Collection<String> collection = this.myState.getRecentNames(25);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getRecentNames"));
        }
        return collection;
    }

    @Override
    public void addRecentName(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "addRecentName"));
        }
        this.myState.addName(name);
    }

    private void validateRecentNames() {
        Collection<FileTemplateBase> allTemplates = this.getSettings().getDefaultTemplatesManager().getAllTemplates(false);
        ArrayList<String> allNames = new ArrayList<String>(allTemplates.size());
        for (FileTemplate fileTemplate : allTemplates) {
            allNames.add(fileTemplate.getName());
        }
        this.myState.validateNames(allNames);
    }

    @Override
    @NotNull
    public FileTemplate[] getInternalTemplates() {
        InternalTemplateBean[] internalTemplateBeans = (InternalTemplateBean[])Extensions.getExtensions(InternalTemplateBean.EP_NAME);
        FileTemplate[] result2 = new FileTemplate[internalTemplateBeans.length];
        for (int i = 0; i < internalTemplateBeans.length; ++i) {
            result2[i] = this.getInternalTemplate(internalTemplateBeans[i].name);
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getInternalTemplates"));
        }
        return result2;
    }

    @Override
    public FileTemplate getInternalTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getInternalTemplate"));
        }
        FileTemplateBase template = (FileTemplateBase)this.findInternalTemplate(templateName);
        if (template == null) {
            template = (FileTemplateBase)this.getJ2eeTemplate(templateName);
            if (template != null) {
                template.setReformatCode(true);
            } else {
                String text = FileTemplateManagerImpl.normalizeText(this.getDefaultClassTemplateText(templateName));
                template = this.getSettings().getInternalTemplatesManager().addTemplate(templateName, "java");
                template.setText(text);
            }
        }
        return template;
    }

    @Override
    public FileTemplate findInternalTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "findInternalTemplate"));
        }
        FileTemplateBase template = this.getSettings().getInternalTemplatesManager().findTemplateByName(templateName);
        if (template == null) {
            template = this.getSettings().getDefaultTemplatesManager().findTemplateByName(templateName);
        }
        return template;
    }

    @NotNull
    public static String normalizeText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "normalizeText"));
        }
        text = StringUtil.convertLineSeparators((String)text);
        text = StringUtil.replace((String)text, (String)"$NAME$", (String)"${NAME}");
        text = StringUtil.replace((String)text, (String)"$PACKAGE_NAME$", (String)"${PACKAGE_NAME}");
        text = StringUtil.replace((String)text, (String)"$DATE$", (String)"${DATE}");
        text = StringUtil.replace((String)text, (String)"$TIME$", (String)"${TIME}");
        String string = text = StringUtil.replace((String)text, (String)"$USER$", (String)"${USER}");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "normalizeText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String internalTemplateToSubject(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "internalTemplateToSubject"));
        }
        for (InternalTemplateBean bean : (InternalTemplateBean[])Extensions.getExtensions(InternalTemplateBean.EP_NAME)) {
            if (!bean.name.equals(templateName) || bean.subject == null) continue;
            String string = bean.subject;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "internalTemplateToSubject"));
            }
            return string;
        }
        String string = templateName.toLowerCase();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "internalTemplateToSubject"));
        }
        return string;
    }

    @Override
    @NotNull
    public String localizeInternalTemplateName(@NotNull FileTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "localizeInternalTemplateName"));
        }
        String string = template.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "localizeInternalTemplateName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    private String getDefaultClassTemplateText(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getDefaultClassTemplateText"));
        }
        String string = IdeBundle.message((String)"template.default.class.comment", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}) + "package $PACKAGE_NAME$;\npublic " + this.internalTemplateToSubject(templateName) + " $NAME$ { }";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getDefaultClassTemplateText"));
        }
        return string;
    }

    @Override
    public FileTemplate getCodeTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getCodeTemplate"));
        }
        return FileTemplateManagerImpl.getTemplateFromManager(templateName, this.getSettings().getCodeTemplatesManager());
    }

    @Override
    public FileTemplate getJ2eeTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getJ2eeTemplate"));
        }
        return FileTemplateManagerImpl.getTemplateFromManager(templateName, this.getSettings().getJ2eeTemplatesManager());
    }

    @Nullable
    private static FileTemplate getTemplateFromManager(@NotNull String templateName, @NotNull FTManager ftManager) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getTemplateFromManager"));
        }
        if (ftManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ftManager", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getTemplateFromManager"));
        }
        FileTemplateBase template = ftManager.getTemplate(templateName);
        if (template != null) {
            return template;
        }
        template = ftManager.findTemplateByName(templateName);
        if (template != null) {
            return template;
        }
        if (templateName.endsWith("ForTest") && ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        String message = "Template not found: " + templateName;
        LOG.error(message);
        return null;
    }

    @Override
    @NotNull
    public FileTemplate getDefaultTemplate(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getDefaultTemplate"));
        }
        String templateQName = this.myTypeManager.getExtension(name).isEmpty() ? FileTemplateBase.getQualifiedName(name, "java") : name;
        for (FTManager manager : this.getAllManagers()) {
            FileTemplateBase template = manager.getTemplate(templateQName);
            if (!(template instanceof BundledFileTemplate)) continue;
            BundledFileTemplate copy = ((BundledFileTemplate)template).clone();
            copy.revertToDefaults();
            BundledFileTemplate bundledFileTemplate = copy;
            if (bundledFileTemplate == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getDefaultTemplate"));
            }
            return bundledFileTemplate;
        }
        String message = "Default template not found: " + name;
        LOG.error(message);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getDefaultTemplate"));
        }
        return null;
    }

    @Override
    @NotNull
    public FileTemplate[] getAllPatterns() {
        Collection<FileTemplateBase> allTemplates = this.getSettings().getPatternsManager().getAllTemplates(false);
        FileTemplate[] fileTemplateArray = allTemplates.toArray(new FileTemplate[allTemplates.size()]);
        if (fileTemplateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getAllPatterns"));
        }
        return fileTemplateArray;
    }

    @Override
    public FileTemplate getPattern(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getPattern"));
        }
        return this.getSettings().getPatternsManager().findTemplateByName(name);
    }

    @Override
    @NotNull
    public FileTemplate[] getAllCodeTemplates() {
        Collection<FileTemplateBase> templates = this.getSettings().getCodeTemplatesManager().getAllTemplates(false);
        FileTemplate[] fileTemplateArray = templates.toArray(new FileTemplate[templates.size()]);
        if (fileTemplateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getAllCodeTemplates"));
        }
        return fileTemplateArray;
    }

    @Override
    @NotNull
    public FileTemplate[] getAllJ2eeTemplates() {
        Collection<FileTemplateBase> templates = this.getSettings().getJ2eeTemplatesManager().getAllTemplates(false);
        FileTemplate[] fileTemplateArray = templates.toArray(new FileTemplate[templates.size()]);
        if (fileTemplateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getAllJ2eeTemplates"));
        }
        return fileTemplateArray;
    }

    @Override
    public void setTemplates(@NotNull String templatesCategory, @NotNull Collection<FileTemplate> templates) {
        if (templatesCategory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templatesCategory", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "setTemplates"));
        }
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "setTemplates"));
        }
        for (FTManager manager : this.getAllManagers()) {
            if (!templatesCategory.equals(manager.getName())) continue;
            manager.updateTemplates(templates);
            manager.saveTemplates();
            break;
        }
    }

    @Override
    public void saveAllTemplates() {
        for (FTManager manager : this.getAllManagers()) {
            manager.saveTemplates();
        }
    }

    public URL getDefaultTemplateDescription() {
        return this.myDefaultSettings.getDefaultTemplateDescription();
    }

    public URL getDefaultIncludeDescription() {
        return this.myDefaultSettings.getDefaultIncludeDescription();
    }

    public void setTestDate(Date testDate) {
        this.myTestDate = testDate;
    }

    @Nullable
    public State getState() {
        this.myState.SCHEME = this.myScheme.getName();
        return this.myState;
    }

    public void loadState(State state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
        FileTemplatesScheme scheme = this.myProjectScheme != null && this.myProjectScheme.getName().equals(state.SCHEME) ? this.myProjectScheme : FileTemplatesScheme.DEFAULT;
        this.setScheme(scheme);
    }

    private FTManager[] getAllManagers() {
        return this.getSettings().getAllManagers();
    }

    public static class State {
        public List<String> RECENT_TEMPLATES = new ArrayList<String>();
        public String SCHEME = FileTemplatesScheme.DEFAULT.getName();

        public void addName(@NotNull @NonNls String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$State", "addName"));
            }
            this.RECENT_TEMPLATES.remove(name);
            this.RECENT_TEMPLATES.add(name);
        }

        @NotNull
        public Collection<String> getRecentNames(int max) {
            int size = this.RECENT_TEMPLATES.size();
            int resultSize = Math.min(max, size);
            List<String> list = this.RECENT_TEMPLATES.subList(size - resultSize, size);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$State", "getRecentNames"));
            }
            return list;
        }

        public void validateNames(List<String> validNames) {
            this.RECENT_TEMPLATES.retainAll(validNames);
        }
    }
}

