/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.dataRules;

import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class FileTextRule
implements GetDataRule {
    @Override
    public Object getData(DataProvider dataProvider) {
        VirtualFile virtualFile = (VirtualFile)dataProvider.getData(CommonDataKeys.VIRTUAL_FILE.getName());
        if (virtualFile == null) {
            return null;
        }
        FileType fileType = virtualFile.getFileType();
        if (fileType.isBinary() || fileType.isReadOnly()) {
            return null;
        }
        Project project2 = (Project)dataProvider.getData(CommonDataKeys.PROJECT.getName());
        if (project2 == null) {
            return null;
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document2 == null) {
            return null;
        }
        return document2.getText();
    }
}

