/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.IdeaBlueMetalTheme;
import com.intellij.ide.ui.laf.IdeaLaf;
import com.intellij.ide.ui.laf.IdeaLookAndFeelInfo;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.IntelliJLookAndFeelInfo;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.mac.MacPopupMenuUI;
import com.intellij.ui.popup.OurHeavyWeightPopup;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="LafManager", storages={@Storage(value="laf.xml", roamingType=RoamingType.PER_OS), @Storage(value="options.xml", deprecated=true)})
public final class LafManagerImpl
extends LafManager
implements ApplicationComponent,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ui.LafManager");
    @NonNls
    private static final String ELEMENT_LAF = "laf";
    @NonNls
    private static final String ATTRIBUTE_CLASS_NAME = "class-name";
    @NonNls
    private static final String GNOME_THEME_PROPERTY_NAME = "gnome.Net/ThemeName";
    @NonNls
    private static final String[] ourPatchableFontResources = new String[]{"Button.font", "ToggleButton.font", "RadioButton.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "Label.font", "List.font", "MenuBar.font", "MenuItem.font", "MenuItem.acceleratorFont", "RadioButtonMenuItem.font", "CheckBoxMenuItem.font", "Menu.font", "PopupMenu.font", "OptionPane.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "FormattedTextField.font", "Spinner.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "TitledBorder.font", "ToolBar.font", "ToolTip.font", "Tree.font"};
    @NonNls
    private static final String[] ourFileChooserTextKeys = new String[]{"FileChooser.viewMenuLabelText", "FileChooser.newFolderActionLabelText", "FileChooser.listViewActionLabelText", "FileChooser.detailsViewActionLabelText", "FileChooser.refreshActionLabelText"};
    private static final String[] ourAlloyComponentsToPatchSelection = new String[]{"Tree", "MenuItem", "Menu", "List", "ComboBox", "Table", "TextArea", "EditorPane", "TextPane", "FormattedTextField", "PasswordField", "TextField", "RadioButtonMenuItem", "CheckBoxMenuItem"};
    private final EventListenerList myListenerList;
    private final UIManager.LookAndFeelInfo[] myLaFs;
    private UIManager.LookAndFeelInfo myCurrentLaf;
    private final Map<UIManager.LookAndFeelInfo, HashMap<String, Object>> myStoredDefaults = ContainerUtil.newHashMap();
    private String myLastWarning = null;
    private PropertyChangeListener myThemeChangeListener = null;
    private static final Map<String, String> ourLafClassesAliases = ContainerUtil.newHashMap();

    public static boolean useIntelliJInsteadOfAqua() {
        return Registry.is((String)"ide.mac.yosemite.laf") && LafManagerImpl.isIntelliJLafEnabled() && SystemInfo.isJavaVersionAtLeast((String)"1.8") && SystemInfo.isMacOSYosemite;
    }

    LafManagerImpl() {
        this.myListenerList = new EventListenerList();
        ArrayList lafList = ContainerUtil.newArrayList();
        if (SystemInfo.isMac) {
            if (LafManagerImpl.useIntelliJInsteadOfAqua()) {
                lafList.add(new UIManager.LookAndFeelInfo("Default", IntelliJLaf.class.getName()));
            } else {
                lafList.add(new UIManager.LookAndFeelInfo("Default", UIManager.getSystemLookAndFeelClassName()));
            }
        } else {
            if (LafManagerImpl.isIntelliJLafEnabled()) {
                lafList.add(new IntelliJLookAndFeelInfo());
            } else {
                lafList.add(new IdeaLookAndFeelInfo());
            }
            for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
                String name = laf.getName();
                if ("Metal".equalsIgnoreCase(name) || "CDE/Motif".equalsIgnoreCase(name) || "Nimbus".equalsIgnoreCase(name) || "Windows Classic".equalsIgnoreCase(name) || name.startsWith("JGoodies")) continue;
                lafList.add(laf);
            }
        }
        lafList.add(new DarculaLookAndFeelInfo());
        this.myLaFs = lafList.toArray(new UIManager.LookAndFeelInfo[lafList.size()]);
        if (!SystemInfo.isMac) {
            Arrays.sort(this.myLaFs, (obj1, obj2) -> {
                String name1 = obj1.getName();
                String name2 = obj2.getName();
                return name1.compareToIgnoreCase(name2);
            });
        }
        this.myCurrentLaf = this.getDefaultLaf();
    }

    private static boolean isIntelliJLafEnabled() {
        return !Registry.is((String)"idea.4.5.laf.enabled");
    }

    public void addLafManagerListener(@NotNull LafManagerListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/ide/ui/laf/LafManagerImpl", "addLafManagerListener"));
        }
        this.myListenerList.add(LafManagerListener.class, l);
    }

    public void removeLafManagerListener(@NotNull LafManagerListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/ide/ui/laf/LafManagerImpl", "removeLafManagerListener"));
        }
        this.myListenerList.remove(LafManagerListener.class, l);
    }

    private void fireLookAndFeelChanged() {
        LafManagerListener[] listeners;
        for (LafManagerListener listener2 : listeners = (LafManagerListener[])this.myListenerList.getListeners(LafManagerListener.class)) {
            listener2.lookAndFeelChanged((LafManager)this);
        }
    }

    @NotNull
    public String getComponentName() {
        if ("LafManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/laf/LafManagerImpl", "getComponentName"));
        }
        return "LafManager";
    }

    public void initComponent() {
        UIManager.LookAndFeelInfo laf;
        if (this.myCurrentLaf != null && (laf = this.findLaf(this.myCurrentLaf.getClassName())) != null) {
            boolean needUninstall = UIUtil.isUnderDarcula();
            this.setCurrentLookAndFeel(laf);
            if (WelcomeWizardUtil.getWizardLAF() != null) {
                if (UIUtil.isUnderDarcula()) {
                    DarculaInstaller.install();
                } else if (needUninstall) {
                    DarculaInstaller.uninstall();
                }
            }
        }
        this.updateUI();
        if (SystemInfo.isXWindow) {
            this.myThemeChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SwingUtilities.invokeLater(() -> {
                        LafManagerImpl.fixGtkPopupStyle();
                        LafManagerImpl.patchGtkDefaults(UIManager.getLookAndFeelDefaults());
                    });
                }
            };
            Toolkit.getDefaultToolkit().addPropertyChangeListener(GNOME_THEME_PROPERTY_NAME, this.myThemeChangeListener);
        }
    }

    public void disposeComponent() {
        if (this.myThemeChangeListener != null) {
            Toolkit.getDefaultToolkit().removePropertyChangeListener(GNOME_THEME_PROPERTY_NAME, this.myThemeChangeListener);
            this.myThemeChangeListener = null;
        }
    }

    public void loadState(Element element) {
        UIManager.LookAndFeelInfo laf;
        String className = null;
        Element lafElement = element.getChild(ELEMENT_LAF);
        if (lafElement != null && (className = lafElement.getAttributeValue(ATTRIBUTE_CLASS_NAME)) != null && ourLafClassesAliases.containsKey(className)) {
            className = ourLafClassesAliases.get(className);
        }
        if ((laf = this.findLaf(className)) == null) {
            laf = this.getDefaultLaf();
        }
        if (this.myCurrentLaf != null && !laf.getClassName().equals(this.myCurrentLaf.getClassName())) {
            this.setCurrentLookAndFeel(laf);
            this.updateUI();
        }
        this.myCurrentLaf = laf;
    }

    public Element getState() {
        String className;
        Element element = new Element("state");
        if (this.myCurrentLaf != null && (className = this.myCurrentLaf.getClassName()) != null) {
            Element child = new Element(ELEMENT_LAF);
            child.setAttribute(ATTRIBUTE_CLASS_NAME, className);
            element.addContent(child);
        }
        return element;
    }

    public UIManager.LookAndFeelInfo[] getInstalledLookAndFeels() {
        return (UIManager.LookAndFeelInfo[])this.myLaFs.clone();
    }

    public UIManager.LookAndFeelInfo getCurrentLookAndFeel() {
        return this.myCurrentLaf;
    }

    private UIManager.LookAndFeelInfo getDefaultLaf() {
        String defaultLafName;
        UIManager.LookAndFeelInfo laf;
        String appLafName;
        UIManager.LookAndFeelInfo laf2;
        String wizardLafName = WelcomeWizardUtil.getWizardLAF();
        if (wizardLafName != null) {
            UIManager.LookAndFeelInfo laf3 = this.findLaf(wizardLafName);
            if (laf3 != null) {
                return laf3;
            }
            LOG.error("Could not find wizard L&F: " + wizardLafName);
        }
        if (SystemInfo.isMac) {
            String className = LafManagerImpl.useIntelliJInsteadOfAqua() ? IntelliJLaf.class.getName() : UIManager.getSystemLookAndFeelClassName();
            laf2 = this.findLaf(className);
            if (laf2 != null) {
                return laf2;
            }
            LOG.error("Could not find OS X L&F: " + className);
        }
        if ((appLafName = WelcomeWizardUtil.getDefaultLAF()) != null) {
            laf2 = this.findLaf(appLafName);
            if (laf2 != null) {
                return laf2;
            }
            LOG.error("Could not find app L&F: " + appLafName);
        }
        if ((laf = this.findLaf(defaultLafName = LafManagerImpl.isIntelliJLafEnabled() ? IntelliJLaf.class.getName() : "idea.laf.classname")) != null) {
            return laf;
        }
        throw new IllegalStateException("No default L&F found: " + defaultLafName);
    }

    @Nullable
    private UIManager.LookAndFeelInfo findLaf(@Nullable String className) {
        if (className == null) {
            return null;
        }
        for (UIManager.LookAndFeelInfo laf : this.myLaFs) {
            if (!Comparing.equal((String)laf.getClassName(), (String)className)) continue;
            return laf;
        }
        return null;
    }

    public void setCurrentLookAndFeel(UIManager.LookAndFeelInfo lookAndFeelInfo) {
        if (this.findLaf(lookAndFeelInfo.getClassName()) == null) {
            LOG.error("unknown LookAndFeel : " + lookAndFeelInfo);
            return;
        }
        if ("idea.laf.classname".equals(lookAndFeelInfo.getClassName())) {
            IdeaLaf laf = new IdeaLaf();
            MetalLookAndFeel.setCurrentTheme(new IdeaBlueMetalTheme());
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        if (DarculaLookAndFeelInfo.CLASS_NAME.equals(lookAndFeelInfo.getClassName())) {
            DarculaLaf laf = new DarculaLaf();
            try {
                UIManager.setLookAndFeel(laf);
                JBColor.setDark((boolean)true);
                IconLoader.setUseDarkIcons((boolean)true);
            }
            catch (Exception e) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        try {
            LookAndFeel laf = (LookAndFeel)Class.forName(lookAndFeelInfo.getClassName()).newInstance();
            if (laf instanceof MetalLookAndFeel) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        this.myCurrentLaf = (UIManager.LookAndFeelInfo)ObjectUtils.chooseNotNull((Object)this.findLaf(lookAndFeelInfo.getClassName()), (Object)lookAndFeelInfo);
        this.checkLookAndFeel(lookAndFeelInfo, false);
    }

    public void setLookAndFeelAfterRestart(UIManager.LookAndFeelInfo lookAndFeelInfo) {
        this.myCurrentLaf = lookAndFeelInfo;
    }

    @Nullable
    private static Icon getAquaMenuDisabledIcon() {
        Icon arrowIcon = (Icon)UIManager.get("Menu.arrowIcon");
        if (arrowIcon != null) {
            return IconLoader.getDisabledIcon((Icon)arrowIcon);
        }
        return null;
    }

    @Nullable
    private static Icon getAquaMenuInvertedIcon() {
        if (UIUtil.isUnderAquaLookAndFeel() || SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
            Icon arrow = (Icon)UIManager.get("Menu.arrowIcon");
            if (arrow == null) {
                return null;
            }
            try {
                Method method = ReflectionUtil.getMethod(arrow.getClass(), (String)"getInvertedIcon", (Class[])new Class[0]);
                if (method != null) {
                    return (Icon)method.invoke((Object)arrow, new Object[0]);
                }
                return null;
            }
            catch (InvocationTargetException e1) {
                return null;
            }
            catch (IllegalAccessException e1) {
                return null;
            }
        }
        return null;
    }

    public boolean checkLookAndFeel(UIManager.LookAndFeelInfo lookAndFeelInfo) {
        return this.checkLookAndFeel(lookAndFeelInfo, true);
    }

    private boolean checkLookAndFeel(UIManager.LookAndFeelInfo lafInfo, boolean confirm) {
        String message = null;
        if (lafInfo.getName().contains("GTK") && SystemInfo.isXWindow && !SystemInfo.isJavaVersionAtLeast((String)"1.6.0_12")) {
            message = IdeBundle.message((String)"warning.problem.laf.1", (Object[])new Object[0]);
        }
        if (message != null) {
            if (confirm) {
                String[] options = new String[]{IdeBundle.message((String)"confirm.set.look.and.feel", (Object[])new Object[0]), CommonBundle.getCancelButtonText()};
                int result2 = Messages.showOkCancelDialog((String)message, (String)CommonBundle.getWarningTitle(), (String)options[0], (String)options[1], (Icon)Messages.getWarningIcon());
                if (result2 == 0) {
                    this.myLastWarning = message;
                    return true;
                }
                return false;
            }
            if (!message.equals(this.myLastWarning)) {
                Notifications.Bus.notify((Notification)new Notification("System Messages", "L&F Manager", message, NotificationType.WARNING, NotificationListener.URL_OPENING_LISTENER));
                this.myLastWarning = message;
            }
        }
        return true;
    }

    public void updateUI() {
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        LafManagerImpl.fixPopupWeight();
        LafManagerImpl.fixGtkPopupStyle();
        LafManagerImpl.fixTreeWideSelection(uiDefaults);
        LafManagerImpl.fixMenuIssues(uiDefaults);
        if (UIUtil.isUnderAquaLookAndFeel()) {
            uiDefaults.put("Panel.opaque", Boolean.TRUE);
        } else if (UIUtil.isWinLafOnVista()) {
            uiDefaults.put("ComboBox.border", (Object)null);
        }
        LafManagerImpl.initInputMapDefaults(uiDefaults);
        uiDefaults.put("Button.defaultButtonFollowsFocus", Boolean.FALSE);
        LafManagerImpl.patchFileChooserStrings(uiDefaults);
        this.patchLafFonts(uiDefaults);
        LafManagerImpl.patchHiDPI(uiDefaults);
        LafManagerImpl.patchGtkDefaults(uiDefaults);
        LafManagerImpl.fixSeparatorColor(uiDefaults);
        LafManagerImpl.updateToolWindows();
        for (Frame frame : Frame.getFrames()) {
            if (SystemInfo.isMac) {
                frame.setBackground(new Color(UIUtil.getPanelBackground().getRGB()));
            }
            LafManagerImpl.updateUI(frame);
        }
        this.fireLookAndFeelChanged();
    }

    private static void patchHiDPI(UIDefaults defaults) {
        float prevScale;
        Object prevScaleVal = defaults.get("hidpi.scaleFactor");
        float f = prevScale = prevScaleVal != null ? ((Float)prevScaleVal).floatValue() : JBUI.scale((float)1.0f);
        if (prevScale == JBUI.scale((float)1.0f) && prevScaleVal != null) {
            return;
        }
        List<String> myIntKeys = Arrays.asList("Tree.leftChildIndent", "Tree.rightChildIndent");
        for (Map.Entry entry : defaults.entrySet()) {
            Object value = entry.getValue();
            String key2 = entry.getKey().toString();
            if (value instanceof Dimension && value instanceof UIResource) {
                entry.setValue(JBUI.size((Dimension)((Dimension)value)).asUIResource());
                continue;
            }
            if (value instanceof Insets && value instanceof UIResource) {
                entry.setValue(JBUI.insets((Insets)((Insets)value)).asUIResource());
                continue;
            }
            if (!(value instanceof Integer) || !key2.endsWith(".maxGutterIconWidth") && !myIntKeys.contains(key2)) continue;
            int normValue = (int)((float)((Integer)value).intValue() / prevScale);
            entry.setValue(JBUI.scale((int)normValue));
        }
        defaults.put("hidpi.scaleFactor", Float.valueOf(JBUI.scale((float)1.0f)));
    }

    public static void updateToolWindows() {
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
            for (String id : toolWindowManager.getToolWindowIds()) {
                ToolWindow toolWindow = toolWindowManager.getToolWindow(id);
                for (Content content : toolWindow.getContentManager().getContents()) {
                    JComponent component = content.getComponent();
                    if (component == null) continue;
                    IJSwingUtilities.updateComponentTreeUI(component);
                }
                JComponent c = toolWindow.getComponent();
                if (c == null) continue;
                IJSwingUtilities.updateComponentTreeUI(c);
            }
        }
    }

    private static void fixMenuIssues(UIDefaults uiDefaults) {
        if (UIUtil.isUnderAquaLookAndFeel() || SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
            uiDefaults.put("PopupMenuUI", MacPopupMenuUI.class.getCanonicalName());
            uiDefaults.put("Menu.invertedArrowIcon", LafManagerImpl.getAquaMenuInvertedIcon());
            uiDefaults.put("Menu.disabledArrowIcon", LafManagerImpl.getAquaMenuDisabledIcon());
        } else if (UIUtil.isUnderJGoodiesLookAndFeel()) {
            uiDefaults.put("Menu.opaque", (Object)true);
            uiDefaults.put("MenuItem.opaque", (Object)true);
        }
        uiDefaults.put("MenuItem.background", UIManager.getColor("Menu.background"));
    }

    private static void fixTreeWideSelection(UIDefaults uiDefaults) {
        if (UIUtil.isUnderAlloyIDEALookAndFeel() || UIUtil.isUnderJGoodiesLookAndFeel()) {
            ColorUIResource bg = new ColorUIResource(56, 117, 215);
            ColorUIResource fg = new ColorUIResource(255, 255, 255);
            uiDefaults.put("info", bg);
            uiDefaults.put("textHighlight", bg);
            for (String key2 : ourAlloyComponentsToPatchSelection) {
                uiDefaults.put(key2 + ".selectionBackground", bg);
                uiDefaults.put(key2 + ".selectionForeground", fg);
            }
        }
    }

    private static void fixSeparatorColor(UIDefaults uiDefaults) {
        if (UIUtil.isUnderAquaLookAndFeel()) {
            uiDefaults.put("Separator.background", UIUtil.AQUA_SEPARATOR_BACKGROUND_COLOR);
            uiDefaults.put("Separator.foreground", UIUtil.AQUA_SEPARATOR_FOREGROUND_COLOR);
        }
    }

    private static void fixPopupWeight() {
        int popupWeight = 1;
        String property = System.getProperty("idea.popup.weight");
        if (property != null) {
            property = property.toLowerCase(Locale.ENGLISH).trim();
        }
        if (SystemInfo.isMacOSLeopard) {
            popupWeight = 2;
        } else if (property == null) {
            if (SystemInfo.isWindows) {
                popupWeight = 2;
            }
        } else if ("light".equals(property)) {
            popupWeight = 0;
        } else if ("medium".equals(property)) {
            popupWeight = 1;
        } else if ("heavy".equals(property)) {
            popupWeight = 2;
        } else {
            LOG.error("Illegal value of property \"idea.popup.weight\": " + property);
        }
        PopupFactory factory = PopupFactory.getSharedInstance();
        if (!(factory instanceof OurPopupFactory)) {
            factory = new OurPopupFactory(factory);
            PopupFactory.setSharedInstance(factory);
        }
        PopupUtil.setPopupType((PopupFactory)factory, (int)popupWeight);
    }

    private static void fixGtkPopupStyle() {
        if (!UIUtil.isUnderGTKLookAndFeel()) {
            return;
        }
        final SynthStyleFactory original = SynthLookAndFeel.getStyleFactory();
        SynthLookAndFeel.setStyleFactory(new SynthStyleFactory(){

            @Override
            public SynthStyle getStyle(JComponent c, Region id) {
                Integer x;
                SynthStyle style = original.getStyle(c, id);
                if (id == Region.POPUP_MENU && (x = (Integer)ReflectionUtil.getField(style.getClass(), (Object)style, Integer.TYPE, (String)"xThickness")) != null && x == 0) {
                    ReflectionUtil.setField(style.getClass(), (Object)style, Integer.TYPE, (String)"xThickness", (Object)1);
                    ReflectionUtil.setField(style.getClass(), (Object)style, Integer.TYPE, (String)"yThickness", (Object)3);
                }
                return style;
            }
        });
        new JBPopupMenu();
        SynthLookAndFeel.setStyleFactory(original);
    }

    private static void patchFileChooserStrings(UIDefaults defaults) {
        if (!defaults.containsKey(ourFileChooserTextKeys[0])) {
            for (String key2 : ourFileChooserTextKeys) {
                defaults.put(key2, IdeBundle.message((String)key2, (Object[])new Object[0]));
            }
        }
    }

    private static void patchGtkDefaults(UIDefaults defaults) {
        if (!UIUtil.isUnderGTKLookAndFeel()) {
            return;
        }
        Map map = ContainerUtil.newHashMap(Arrays.asList("OptionPane.errorIcon", "OptionPane.informationIcon", "OptionPane.warningIcon", "OptionPane.questionIcon"), Arrays.asList(AllIcons.General.ErrorDialog, AllIcons.General.InformationDialog, AllIcons.General.WarningDialog, AllIcons.General.QuestionDialog));
        SynthStyle style = SynthLookAndFeel.getStyle(new JOptionPane(""), Region.DESKTOP_ICON);
        for (String key2 : map.keySet()) {
            if (defaults.get(key2) != null) continue;
            Object icon = style == null ? null : style.get(null, key2);
            defaults.put(key2, icon instanceof Icon ? icon : map.get(key2));
        }
        Color fg = defaults.getColor("Label.foreground");
        Color bg = defaults.getColor("Label.background");
        if (fg != null && bg != null) {
            defaults.put("Label.disabledForeground", UIUtil.mix((Color)fg, (Color)bg, (double)0.5));
        }
    }

    private void patchLafFonts(UIDefaults uiDefaults) {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.OVERRIDE_NONIDEA_LAF_FONTS) {
            this.storeOriginalFontDefaults(uiDefaults);
            JBUI.setScaleFactor((float)((float)uiSettings.FONT_SIZE / 12.0f));
            LafManagerImpl.initFontDefaults(uiDefaults, uiSettings.FONT_SIZE, new FontUIResource(uiSettings.FONT_FACE, 0, uiSettings.FONT_SIZE));
        } else {
            this.restoreOriginalFontDefaults(uiDefaults);
        }
    }

    private void restoreOriginalFontDefaults(UIDefaults defaults) {
        UIManager.LookAndFeelInfo lf = this.getCurrentLookAndFeel();
        HashMap<String, Object> lfDefaults = this.myStoredDefaults.get(lf);
        if (lfDefaults != null) {
            for (String resource : ourPatchableFontResources) {
                defaults.put(resource, lfDefaults.get(resource));
            }
        }
        JBUI.setScaleFactor((float)((float)JBUI.Fonts.label().getSize() / 12.0f));
    }

    private void storeOriginalFontDefaults(UIDefaults defaults) {
        UIManager.LookAndFeelInfo lf = this.getCurrentLookAndFeel();
        HashMap<String, Object> lfDefaults = this.myStoredDefaults.get(lf);
        if (lfDefaults == null) {
            lfDefaults = new HashMap();
            for (String resource : ourPatchableFontResources) {
                lfDefaults.put(resource, defaults.get(resource));
            }
            this.myStoredDefaults.put(lf, lfDefaults);
        }
    }

    private static void updateUI(Window window) {
        Window[] children2;
        IJSwingUtilities.updateComponentTreeUI(window);
        for (Window w : children2 = window.getOwnedWindows()) {
            IJSwingUtilities.updateComponentTreeUI(w);
        }
    }

    public void repaintUI() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            LafManagerImpl.repaintUI(frame);
        }
    }

    private static void repaintUI(Window window) {
        Window[] children2;
        if (!window.isDisplayable()) {
            return;
        }
        window.repaint();
        for (Window aChildren : children2 = window.getOwnedWindows()) {
            LafManagerImpl.repaintUI(aChildren);
        }
    }

    private static void installCutCopyPasteShortcuts(InputMap inputMap, boolean useSimpleActionKeys) {
        String copyActionKey = useSimpleActionKeys ? "copy" : "copy-to-clipboard";
        String pasteActionKey = useSimpleActionKeys ? "paste" : "paste-from-clipboard";
        String cutActionKey = useSimpleActionKeys ? "cut" : "cut-to-clipboard";
        inputMap.put(KeyStroke.getKeyStroke(155, 130), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(155, 65), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(127, 65), cutActionKey);
        inputMap.put(KeyStroke.getKeyStroke(67, 130), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(86, 130), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(88, 130), "cut-to-clipboard");
    }

    public static void initInputMapDefaults(UIDefaults defaults) {
        InputMap tableInputMap;
        InputMap passwordFieldInputMap;
        InputMap textFieldInputMap;
        InputMap textAreaInputMap;
        InputMap treeInputMap = (InputMap)defaults.get("Tree.focusInputMap");
        if (treeInputMap != null) {
            treeInputMap.put(KeyStroke.getKeyStroke(10, 0), "toggle");
        }
        if ((textAreaInputMap = (InputMap)defaults.get("TextArea.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(textAreaInputMap, false);
        }
        if ((textFieldInputMap = (InputMap)defaults.get("TextField.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(textFieldInputMap, false);
        }
        if ((passwordFieldInputMap = (InputMap)defaults.get("PasswordField.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(passwordFieldInputMap, false);
        }
        if ((tableInputMap = (InputMap)defaults.get("Table.ancestorInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(tableInputMap, true);
        }
    }

    static void initFontDefaults(UIDefaults defaults, int fontSize, FontUIResource uiFont) {
        defaults.put("Tree.ancestorInputMap", (Object)null);
        FontUIResource textFont = new FontUIResource("Serif", 0, fontSize);
        FontUIResource monoFont = new FontUIResource("Monospaced", 0, fontSize);
        for (String fontResource : ourPatchableFontResources) {
            defaults.put(fontResource, uiFont);
        }
        defaults.put("PasswordField.font", monoFont);
        defaults.put("TextArea.font", monoFont);
        defaults.put("TextPane.font", textFont);
        defaults.put("EditorPane.font", textFont);
    }

    static {
        ourLafClassesAliases.put("idea.dark.laf.classname", DarculaLookAndFeelInfo.CLASS_NAME);
    }

    private static class OurPopupFactory
    extends PopupFactory {
        public static final int WEIGHT_LIGHT = 0;
        public static final int WEIGHT_MEDIUM = 1;
        public static final int WEIGHT_HEAVY = 2;
        private final PopupFactory myDelegate;

        public OurPopupFactory(PopupFactory delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
            int popupType;
            Point point = OurPopupFactory.fixPopupLocation(contents, x, y);
            int n = popupType = UIUtil.isUnderGTKLookAndFeel() ? 2 : PopupUtil.getPopupType((PopupFactory)this);
            if (popupType == 2 && OurHeavyWeightPopup.isEnabled()) {
                return new OurHeavyWeightPopup(owner, contents, point.x, point.y);
            }
            if (popupType >= 0) {
                PopupUtil.setPopupType((PopupFactory)this.myDelegate, (int)popupType);
            }
            Popup popup = this.myDelegate.getPopup(owner, contents, point.x, point.y);
            OurPopupFactory.fixPopupSize(popup, contents);
            return popup;
        }

        private static Point fixPopupLocation(Component contents, int x, int y) {
            PointerInfo info;
            if (!(contents instanceof JToolTip)) {
                return new Point(x, y);
            }
            try {
                info = MouseInfo.getPointerInfo();
            }
            catch (InternalError e) {
                return new Point(x, y);
            }
            int deltaY = 0;
            if (info != null) {
                Point mouse = info.getLocation();
                deltaY = mouse.y - y;
            }
            Dimension size = contents.getPreferredSize();
            Rectangle rec = new Rectangle(new Point(x, y), size);
            ScreenUtil.moveRectangleToFitTheScreen((Rectangle)rec);
            if (rec.y < y) {
                rec.y += deltaY;
            }
            return rec.getLocation();
        }

        private static void fixPopupSize(Popup popup, Component contents) {
            if (!UIUtil.isUnderGTKLookAndFeel() || !(contents instanceof JPopupMenu)) {
                return;
            }
            for (Class<?> aClass = popup.getClass(); aClass != null && Popup.class.isAssignableFrom(aClass); aClass = aClass.getSuperclass()) {
                try {
                    Method getComponent = aClass.getDeclaredMethod("getComponent", new Class[0]);
                    getComponent.setAccessible(true);
                    Object component = getComponent.invoke((Object)popup, new Object[0]);
                    if (!(component instanceof JWindow)) break;
                    ((JWindow)component).setSize(new Dimension(0, 0));
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
    }
}

