/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.BundledQuickListsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.project.Project;
import gnu.trove.THashSet;
import java.io.File;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class QuickListsManager
implements ExportableApplicationComponent {
    private static final String LIST_TAG = "list";
    private final ActionManager myActionManager;
    private final SchemesManager<QuickList, QuickList> mySchemeManager;

    public QuickListsManager(@NotNull ActionManager actionManager, @NotNull SchemesManagerFactory schemesManagerFactory) {
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/openapi/actionSystem/ex/QuickListsManager", "<init>"));
        }
        if (schemesManagerFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemesManagerFactory", "com/intellij/openapi/actionSystem/ex/QuickListsManager", "<init>"));
        }
        this.myActionManager = actionManager;
        this.mySchemeManager = schemesManagerFactory.create("quicklists", (SchemeProcessor)new SchemeProcessor<QuickList>(){

            @NotNull
            public QuickList readScheme(@NotNull Element element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/actionSystem/ex/QuickListsManager$1", "readScheme"));
                }
                QuickList quickList = QuickListsManager.createItem(element);
                if (quickList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/QuickListsManager$1", "readScheme"));
                }
                return quickList;
            }

            public Element writeScheme(@NotNull QuickList scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/actionSystem/ex/QuickListsManager$1", "writeScheme"));
                }
                Element element = new Element(QuickListsManager.LIST_TAG);
                scheme.writeExternal(element);
                return element;
            }
        });
    }

    @NotNull
    public static QuickListsManager getInstance() {
        QuickListsManager quickListsManager = (QuickListsManager)ApplicationManager.getApplication().getComponent(QuickListsManager.class);
        if (quickListsManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/QuickListsManager", "getInstance"));
        }
        return quickListsManager;
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{this.mySchemeManager.getRootDirectory()};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/QuickListsManager", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = IdeBundle.message((String)"quick.lists.presentable.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/QuickListsManager", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    private static QuickList createItem(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/actionSystem/ex/QuickListsManager", "createItem"));
        }
        QuickList item = new QuickList();
        item.readExternal(element);
        QuickList quickList = item;
        if (quickList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/QuickListsManager", "createItem"));
        }
        return quickList;
    }

    @NotNull
    public String getComponentName() {
        if ("QuickListsManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/QuickListsManager", "getComponentName"));
        }
        return "QuickListsManager";
    }

    public void initComponent() {
        for (BundledQuickListsProvider provider : (BundledQuickListsProvider[])BundledQuickListsProvider.EP_NAME.getExtensions()) {
            for (String path : provider.getBundledListsRelativePaths()) {
                this.mySchemeManager.loadBundledScheme(path, (Object)provider, element -> QuickListsManager.createItem(element));
            }
        }
        this.mySchemeManager.loadSchemes();
        this.registerActions();
    }

    public void disposeComponent() {
    }

    @NotNull
    public SchemesManager<QuickList, QuickList> getSchemeManager() {
        SchemesManager<QuickList, QuickList> schemesManager = this.mySchemeManager;
        if (schemesManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/QuickListsManager", "getSchemeManager"));
        }
        return schemesManager;
    }

    @NotNull
    public QuickList[] getAllQuickLists() {
        List lists = this.mySchemeManager.getAllSchemes();
        QuickList[] quickListArray = lists.toArray(new QuickList[lists.size()]);
        if (quickListArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/QuickListsManager", "getAllQuickLists"));
        }
        return quickListArray;
    }

    private void registerActions() {
        THashSet registeredIds = new THashSet();
        for (QuickList list : this.mySchemeManager.getAllSchemes()) {
            String actionId = list.getActionId();
            if (!registeredIds.add(actionId)) continue;
            this.myActionManager.registerAction(actionId, (AnAction)new InvokeQuickListAction(list));
        }
    }

    private void unregisterActions() {
        for (String oldId : this.myActionManager.getActionIds("QuickList.")) {
            this.myActionManager.unregisterAction(oldId);
        }
    }

    public void setQuickLists(@NotNull List<QuickList> quickLists) {
        if (quickLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickLists", "com/intellij/openapi/actionSystem/ex/QuickListsManager", "setQuickLists"));
        }
        this.unregisterActions();
        this.mySchemeManager.setSchemes(quickLists);
        this.registerActions();
    }

    private static class InvokeQuickListAction
    extends QuickSwitchSchemeAction {
        private final QuickList myQuickList;

        public InvokeQuickListAction(@NotNull QuickList quickList) {
            if (quickList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickList", "com/intellij/openapi/actionSystem/ex/QuickListsManager$InvokeQuickListAction", "<init>"));
            }
            this.myQuickList = quickList;
            this.myActionPlace = "ActionPlace.QuickListPopupAction";
            this.getTemplatePresentation().setDescription(this.myQuickList.getDescription());
            this.getTemplatePresentation().setText(this.myQuickList.getName(), false);
        }

        protected void fillActions(Project project2, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/ex/QuickListsManager$InvokeQuickListAction", "fillActions"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/actionSystem/ex/QuickListsManager$InvokeQuickListAction", "fillActions"));
            }
            ActionManager actionManager = ActionManager.getInstance();
            for (String actionId : this.myQuickList.getActionIds()) {
                if ("QuickList.$Separator$".equals(actionId)) {
                    group.addSeparator();
                    continue;
                }
                AnAction action = actionManager.getAction(actionId);
                if (action == null) continue;
                group.add(action);
            }
        }

        protected boolean isEnabled() {
            return true;
        }
    }
}

