/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir.actions.popup;

import com.intellij.ide.diff.DirDiffElement;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffPanel;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.project.DumbAwareAction;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SetOperationToBase
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        DirDiffOperation operation = this.getOperation();
        boolean setToDefault = operation == DirDiffOperation.NONE;
        DirDiffTableModel model = SetOperationToBase.getModel(e);
        JTable table = SetOperationToBase.getTable(e);
        assert (model != null && table != null);
        for (DirDiffElementImpl element : model.getSelectedElements()) {
            if (this.isEnabledFor(element)) {
                element.setOperation(setToDefault ? element.getDefaultOperation() : operation);
                continue;
            }
            element.setOperation(DirDiffOperation.NONE);
        }
        table.repaint();
    }

    @NotNull
    protected abstract DirDiffOperation getOperation();

    public final void update(AnActionEvent e) {
        DirDiffTableModel model = SetOperationToBase.getModel(e);
        JTable table = SetOperationToBase.getTable(e);
        if (table != null && model != null) {
            for (DirDiffElementImpl element : model.getSelectedElements()) {
                if (!this.isEnabledFor(element)) continue;
                e.getPresentation().setEnabled(true);
                return;
            }
        }
        e.getPresentation().setEnabled(false);
    }

    protected abstract boolean isEnabledFor(DirDiffElement var1);

    @Nullable
    static JTable getTable(AnActionEvent e) {
        return (JTable)e.getData(DirDiffPanel.DIR_DIFF_TABLE);
    }

    @Nullable
    public static DirDiffTableModel getModel(AnActionEvent e) {
        return (DirDiffTableModel)e.getData(DirDiffPanel.DIR_DIFF_MODEL);
    }
}

