/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.CacheEntry;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappingUtil {
    private MappingUtil() {
    }

    public static int getCacheEntryIndexForOffset(int offset, Document document2, List<CacheEntry> cache) {
        if (offset >= document2.getTextLength() && (cache.isEmpty() || cache.get((int)(cache.size() - 1)).endOffset < offset)) {
            return -(cache.size() + 1);
        }
        int start = 0;
        int end = cache.size() - 1;
        while (start <= end) {
            int i = end + start >>> 1;
            CacheEntry cacheEntry = cache.get(i);
            if (cacheEntry.endOffset < offset) {
                start = i + 1;
                continue;
            }
            if (cacheEntry.startOffset > offset) {
                end = i - 1;
                continue;
            }
            if (offset == cacheEntry.endOffset && i < cache.size() - 1) {
                CacheEntry nextLineCacheEntry = cache.get(i + 1);
                if (nextLineCacheEntry.startOffset == offset) {
                    return i + 1;
                }
            }
            return i;
        }
        return -(start + 1);
    }

    @Nullable
    public static CacheEntry getCacheEntryForLogicalPosition(@NotNull LogicalPosition position, @NotNull List<CacheEntry> cache) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/MappingUtil", "getCacheEntryForLogicalPosition"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/openapi/editor/impl/softwrap/mapping/MappingUtil", "getCacheEntryForLogicalPosition"));
        }
        int start = 0;
        int end = cache.size() - 1;
        while (start <= end) {
            int i = end + start >>> 1;
            CacheEntry cacheEntry = cache.get(i);
            if (cacheEntry.startLogicalLine < position.line || cacheEntry.startLogicalLine == position.line && cacheEntry.startLogicalColumn < position.column) {
                start = i + 1;
                continue;
            }
            if (cacheEntry.startLogicalLine > position.line || cacheEntry.startLogicalLine == position.line && cacheEntry.startLogicalColumn > position.column) {
                end = i - 1;
                continue;
            }
            return MappingUtil.assertEnd(position, cache.get(i));
        }
        return end < 0 ? null : MappingUtil.assertEnd(position, cache.get(end));
    }

    @Nullable
    private static CacheEntry assertEnd(@NotNull LogicalPosition position, @NotNull CacheEntry entry) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/MappingUtil", "assertEnd"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/editor/impl/softwrap/mapping/MappingUtil", "assertEnd"));
        }
        return position.line <= entry.endLogicalLine ? entry : null;
    }
}

