/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundTaskUtil {
    private static final Logger LOG = Logger.getInstance(BackgroundTaskUtil.class);
    private static final Runnable TOO_SLOW_OPERATION = new EmptyRunnable();

    @NotNull
    public static ProgressIndicator executeAndTryWait(@NotNull Function<ProgressIndicator, Runnable> backgroundTask, @Nullable Runnable onSlowAction, int waitMillis) {
        if (backgroundTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundTask", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeAndTryWait"));
        }
        ProgressIndicator progressIndicator = BackgroundTaskUtil.executeAndTryWait(backgroundTask, onSlowAction, waitMillis, false);
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeAndTryWait"));
        }
        return progressIndicator;
    }

    @NotNull
    public static ProgressIndicator executeAndTryWait(@NotNull Function<ProgressIndicator, Runnable> backgroundTask, @Nullable Runnable onSlowAction, int waitMillis, boolean forceEDT) {
        if (backgroundTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundTask", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeAndTryWait"));
        }
        final ModalityState modality = ModalityState.current();
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(){

            @NotNull
            public ModalityState getModalityState() {
                ModalityState modalityState = modality;
                if (modalityState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/BackgroundTaskUtil$1", "getModalityState"));
                }
                return modalityState;
            }
        };
        Semaphore semaphore = new Semaphore(0);
        AtomicReference<Runnable> resultRef = new AtomicReference<Runnable>();
        if (forceEDT) {
            try {
                Runnable callback = (Runnable)backgroundTask.fun((Object)indicator);
                BackgroundTaskUtil.finish(callback, (ProgressIndicator)indicator);
            }
            catch (ProcessCanceledException callback) {
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> BackgroundTaskUtil.lambda$executeAndTryWait$2(backgroundTask, (ProgressIndicator)indicator, semaphore, resultRef, modality));
            try {
                semaphore.tryAcquire(waitMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!resultRef.compareAndSet(null, TOO_SLOW_OPERATION)) {
                BackgroundTaskUtil.finish((Runnable)resultRef.get(), (ProgressIndicator)indicator);
            } else if (onSlowAction != null) {
                onSlowAction.run();
            }
        }
        EmptyProgressIndicator emptyProgressIndicator = indicator;
        if (emptyProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeAndTryWait"));
        }
        return emptyProgressIndicator;
    }

    private static void finish(@NotNull Runnable result2, @NotNull ProgressIndicator indicator) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "finish"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "finish"));
        }
        if (indicator.isCanceled()) {
            return;
        }
        result2.run();
        indicator.stop();
    }

    @Nullable
    public static <T> T tryComputeFast(@NotNull Function<ProgressIndicator, T> backgroundTask, int waitMillis) {
        if (backgroundTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundTask", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "tryComputeFast"));
        }
        Ref resultRef = new Ref();
        ProgressIndicator indicator = BackgroundTaskUtil.executeAndTryWait((Function<ProgressIndicator, Runnable>)((Function)indicator1 -> {
            if (backgroundTask == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundTask", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$tryComputeFast$4"));
            }
            Object result2 = backgroundTask.fun(indicator1);
            return () -> resultRef.set(result2);
        }), null, waitMillis, false);
        indicator.cancel();
        return (T)resultRef.get();
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(@NotNull Consumer<ProgressIndicator> task, @NotNull Disposable parent) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        ModalityState modalityState = ModalityState.current();
        ProgressIndicator progressIndicator = BackgroundTaskUtil.executeOnPooledThread(task, parent, modalityState);
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        return progressIndicator;
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(@NotNull Runnable runnable2, @NotNull Disposable parent) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        ProgressIndicator progressIndicator = BackgroundTaskUtil.executeOnPooledThread((Consumer<ProgressIndicator>)((Consumer)indicator -> {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$executeOnPooledThread$5"));
            }
            runnable2.run();
        }), parent, ModalityState.NON_MODAL);
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        return progressIndicator;
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(@NotNull Consumer<ProgressIndicator> task, @NotNull Disposable parent, final ModalityState modalityState) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(){

            @NotNull
            public ModalityState getModalityState() {
                ModalityState modalityState2 = modalityState;
                if (modalityState2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/BackgroundTaskUtil$2", "getModalityState"));
                }
                return modalityState2;
            }
        };
        Disposable disposable = new Disposable((ProgressIndicator)indicator){
            final /* synthetic */ ProgressIndicator val$indicator;
            {
                this.val$indicator = progressIndicator;
            }

            public void dispose() {
                if (this.val$indicator.isRunning()) {
                    this.val$indicator.cancel();
                }
            }
        };
        Disposer.register((Disposable)parent, (Disposable)disposable);
        indicator.start();
        ApplicationManager.getApplication().executeOnPooledThread(() -> BackgroundTaskUtil.lambda$executeOnPooledThread$7(task, (ProgressIndicator)indicator, disposable));
        EmptyProgressIndicator emptyProgressIndicator = indicator;
        if (emptyProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "executeOnPooledThread"));
        }
        return emptyProgressIndicator;
    }

    private static /* synthetic */ void lambda$executeOnPooledThread$7(@NotNull Consumer task, ProgressIndicator indicator, Disposable disposable) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$executeOnPooledThread$7"));
        }
        ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$null$6"));
            }
            try {
                task.consume((Object)indicator);
            }
            finally {
                indicator.stop();
                Disposer.dispose((Disposable)disposable);
            }
        }, indicator);
    }

    private static /* synthetic */ void lambda$executeAndTryWait$2(@NotNull Function backgroundTask, ProgressIndicator indicator, Semaphore semaphore, AtomicReference resultRef, ModalityState modality) {
        if (backgroundTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundTask", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$executeAndTryWait$2"));
        }
        ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            if (backgroundTask == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundTask", "com/intellij/openapi/progress/util/BackgroundTaskUtil", "lambda$null$1"));
            }
            Runnable callback = (Runnable)backgroundTask.fun((Object)indicator);
            if (indicator.isCanceled()) {
                semaphore.release();
                return;
            }
            if (!resultRef.compareAndSet(null, callback)) {
                ApplicationManager.getApplication().invokeLater(() -> BackgroundTaskUtil.finish(callback, indicator), modality);
            }
            semaphore.release();
        }, indicator);
    }
}

