/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.actions.CachedVcsContext;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsContextWrapper
implements VcsContext {
    protected final DataContext myContext;
    protected final int myModifiers;
    private final String myPlace;
    private final String myActionName;

    public VcsContextWrapper(DataContext context, int modifiers, String place, String actionName) {
        this.myContext = context;
        this.myModifiers = modifiers;
        this.myPlace = place;
        this.myActionName = actionName;
    }

    public String getPlace() {
        return this.myPlace;
    }

    public String getActionName() {
        return this.myActionName;
    }

    @NotNull
    public static VcsContext createCachedInstanceOn(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "createCachedInstanceOn"));
        }
        CachedVcsContext cachedVcsContext = new CachedVcsContext(VcsContextWrapper.createInstanceOn(event));
        if (cachedVcsContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "createCachedInstanceOn"));
        }
        return cachedVcsContext;
    }

    @NotNull
    public static VcsContextWrapper createInstanceOn(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "createInstanceOn"));
        }
        VcsContextWrapper vcsContextWrapper = new VcsContextWrapper(event.getDataContext(), event.getModifiers(), event.getPlace(), event.getPresentation().getText());
        if (vcsContextWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "createInstanceOn"));
        }
        return vcsContextWrapper;
    }

    public Project getProject() {
        return (Project)CommonDataKeys.PROJECT.getData(this.myContext);
    }

    public VirtualFile getSelectedFile() {
        VirtualFile[] files = this.getSelectedFiles();
        return files.length == 0 ? null : files[0];
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] fileArray = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(this.myContext);
        if (fileArray != null) {
            VirtualFile[] virtualFileArray = VcsContextWrapper.filterLocalFiles(fileArray);
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getSelectedFiles"));
            }
            return virtualFileArray;
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(this.myContext);
        if (virtualFile != null && VcsContextWrapper.isLocal(virtualFile)) {
            VirtualFile[] virtualFileArray = new VirtualFile[]{virtualFile};
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getSelectedFiles"));
            }
            return virtualFileArray;
        }
        if (VirtualFile.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getSelectedFiles"));
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    @NotNull
    public Stream<VirtualFile> getSelectedFilesStream() {
        Stream result2 = (Stream)VcsDataKeys.VIRTUAL_FILE_STREAM.getData(this.myContext);
        Stream<VirtualFile> stream = result2 != null ? result2.filter(VirtualFile::isInLocalFileSystem) : super.getSelectedFilesStream();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getSelectedFilesStream"));
        }
        return stream;
    }

    private static boolean isLocal(VirtualFile virtualFile) {
        return virtualFile.isInLocalFileSystem();
    }

    private static VirtualFile[] filterLocalFiles(VirtualFile[] fileArray) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : fileArray) {
            if (!VcsContextWrapper.isLocal(virtualFile)) continue;
            result2.add(virtualFile);
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    public Editor getEditor() {
        return (Editor)CommonDataKeys.EDITOR.getData(this.myContext);
    }

    public Collection<VirtualFile> getSelectedFilesCollection() {
        return Arrays.asList(this.getSelectedFiles());
    }

    public File getSelectedIOFile() {
        File file2 = (File)VcsDataKeys.IO_FILE.getData(this.myContext);
        if (file2 != null) {
            return file2;
        }
        File[] files = (File[])VcsDataKeys.IO_FILE_ARRAY.getData(this.myContext);
        if (files == null) {
            return null;
        }
        if (files.length == 0) {
            return null;
        }
        return files[0];
    }

    public File[] getSelectedIOFiles() {
        File[] files = (File[])VcsDataKeys.IO_FILE_ARRAY.getData(this.myContext);
        if (files != null && files.length > 0) {
            return files;
        }
        File file2 = this.getSelectedIOFile();
        if (file2 != null) {
            return new File[]{file2};
        }
        return null;
    }

    public int getModifiers() {
        return this.myModifiers;
    }

    public Refreshable getRefreshableDialog() {
        return (Refreshable)Refreshable.PANEL_KEY.getData(this.myContext);
    }

    @NotNull
    public FilePath[] getSelectedFilePaths() {
        VirtualFile[] selectedFiles;
        FilePath[] paths;
        THashSet result2 = new THashSet();
        FilePath path = (FilePath)VcsDataKeys.FILE_PATH.getData(this.myContext);
        if (path != null) {
            result2.add(path);
        }
        if ((paths = (FilePath[])VcsDataKeys.FILE_PATH_ARRAY.getData(this.myContext)) != null) {
            for (FilePath filePath : paths) {
                if (result2.contains(filePath)) continue;
                result2.add(filePath);
            }
        }
        for (VirtualFile selectedFile : selectedFiles = this.getSelectedFiles()) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)selectedFile);
            result2.add(filePath);
        }
        File[] selectedIOFiles = this.getSelectedIOFiles();
        if (selectedIOFiles != null) {
            for (File selectedFile : selectedIOFiles) {
                FilePath filePath = VcsUtil.getFilePath((File)selectedFile);
                if (filePath == null) continue;
                result2.add(filePath);
            }
        }
        FilePath[] filePathArray = result2.toArray(new FilePath[result2.size()]);
        if (filePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsContextWrapper", "getSelectedFilePaths"));
        }
        return filePathArray;
    }

    @Nullable
    public FilePath getSelectedFilePath() {
        FilePath[] selectedFilePaths = this.getSelectedFilePaths();
        if (selectedFilePaths.length == 0) {
            return null;
        }
        return selectedFilePaths[0];
    }

    @Nullable
    public ChangeList[] getSelectedChangeLists() {
        return (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(this.myContext);
    }

    @Nullable
    public Change[] getSelectedChanges() {
        return (Change[])VcsDataKeys.CHANGES.getData(this.myContext);
    }
}

