/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.RecursiveFileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import org.jetbrains.annotations.Nullable;

public class SwitchedFileHolder
extends RecursiveFileHolder<Pair<Boolean, String>> {
    public SwitchedFileHolder(Project project2, FileHolder.HolderType holderType) {
        super(project2, holderType);
    }

    public void takeFrom(SwitchedFileHolder holder) {
        this.myMap.clear();
        this.myMap.putAll(holder.myMap);
    }

    @Override
    public synchronized SwitchedFileHolder copy() {
        SwitchedFileHolder copyHolder = new SwitchedFileHolder(this.myProject, this.myHolderType);
        copyHolder.myMap.putAll(this.myMap);
        return copyHolder;
    }

    @Override
    protected boolean isFileDirty(VcsDirtyScope scope, VirtualFile file2) {
        if (scope == null) {
            return true;
        }
        if (this.fileDropped(file2)) {
            return true;
        }
        return scope.belongsTo(VcsUtil.getFilePath((VirtualFile)file2));
    }

    public Map<VirtualFile, String> getFilesMapCopy() {
        HashMap<VirtualFile, String> result2 = new HashMap<VirtualFile, String>();
        for (VirtualFile vf : this.myMap.keySet()) {
            result2.put(vf, (String)((Pair)this.myMap.get(vf)).getSecond());
        }
        return result2;
    }

    public void addFile(VirtualFile file2, String branch, boolean recursive) {
        this.myMap.put(file2, new Pair((Object)recursive, (Object)branch));
    }

    public synchronized MultiMap<String, VirtualFile> getBranchToFileMap() {
        MultiMap result2 = new MultiMap();
        for (VirtualFile vf : this.myMap.keySet()) {
            result2.putValue(((Pair)this.myMap.get(vf)).getSecond(), (Object)vf);
        }
        return result2;
    }

    @Override
    public synchronized boolean containsFile(VirtualFile file2) {
        VirtualFile floor = this.myMap.floorKey(file2);
        if (floor == null) {
            return false;
        }
        NavigableMap floorMap = this.myMap.headMap(floor, true);
        for (VirtualFile parent : floorMap.keySet()) {
            if (!VfsUtil.isAncestor((VirtualFile)parent, (VirtualFile)file2, (boolean)false)) continue;
            Pair value = (Pair)floorMap.get(parent);
            return parent.equals(file2) || (Boolean)value.getFirst() != false;
        }
        return false;
    }

    @Nullable
    public String getBranchForFile(VirtualFile file2) {
        VirtualFile floor = this.myMap.floorKey(file2);
        if (floor == null) {
            return null;
        }
        SortedMap floorMap = this.myMap.headMap(floor);
        for (VirtualFile parent : floorMap.keySet()) {
            if (!VfsUtil.isAncestor((VirtualFile)parent, (VirtualFile)file2, (boolean)false)) continue;
            return (String)((Pair)floorMap.get(parent)).getSecond();
        }
        return null;
    }

    public void calculateChildren() {
    }

    private static class MyOptimizeProcessor
    implements PairProcessor<Pair<Boolean, String>, Pair<Boolean, String>> {
        private static final MyOptimizeProcessor ourInstance = new MyOptimizeProcessor();

        private MyOptimizeProcessor() {
        }

        public static MyOptimizeProcessor getInstance() {
            return ourInstance;
        }

        public boolean process(Pair<Boolean, String> parentPair, Pair<Boolean, String> childPair) {
            return Boolean.TRUE.equals(parentPair.getFirst()) && ((String)parentPair.getSecond()).equals(childPair.getSecond());
        }
    }
}

