/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.DiffContext;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchMergeRequest;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchViewer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Point;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchMergeTool
implements MergeTool {
    @NotNull
    public MergeTool.MergeViewer createComponent(@NotNull MergeContext context, @NotNull MergeRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeTool", "createComponent"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeTool", "createComponent"));
        }
        MyApplyPatchViewer myApplyPatchViewer = new MyApplyPatchViewer(context, (ApplyPatchMergeRequest)request);
        if (myApplyPatchViewer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeTool", "createComponent"));
        }
        return myApplyPatchViewer;
    }

    public boolean canShow(@NotNull MergeContext context, @NotNull MergeRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeTool", "canShow"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeTool", "canShow"));
        }
        return request instanceof ApplyPatchMergeRequest;
    }

    private static class MyApplyPatchViewer
    extends ApplyPatchViewer
    implements MergeTool.MergeViewer {
        @NotNull
        private final MergeContext myMergeContext;
        @NotNull
        private final ApplyPatchMergeRequest myMergeRequest;

        public MyApplyPatchViewer(@NotNull MergeContext context, @NotNull ApplyPatchMergeRequest request) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeTool$MyApplyPatchViewer", "<init>"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeTool$MyApplyPatchViewer", "<init>"));
            }
            super(MyApplyPatchViewer.createWrapperDiffContext(context), request);
            this.myMergeContext = context;
            this.myMergeRequest = request;
        }

        @NotNull
        private static DiffContext createWrapperDiffContext(@NotNull MergeContext mergeContext) {
            if (mergeContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeTool$MyApplyPatchViewer", "createWrapperDiffContext"));
            }
            MergeUtil.ProxyDiffContext proxyDiffContext = new MergeUtil.ProxyDiffContext(mergeContext);
            if (proxyDiffContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeTool$MyApplyPatchViewer", "createWrapperDiffContext"));
            }
            return proxyDiffContext;
        }

        @NotNull
        public MergeTool.ToolbarComponents init() {
            this.initPatchViewer();
            MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
            components.statusPanel = this.getStatusPanel();
            components.toolbarActions = this.createToolbarActions();
            components.closeHandler = () -> MergeUtil.showExitWithoutApplyingChangesDialog(this, (MergeRequest)this.myMergeRequest, this.myMergeContext);
            MergeTool.ToolbarComponents toolbarComponents = components;
            if (toolbarComponents == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeTool$MyApplyPatchViewer", "init"));
            }
            return toolbarComponents;
        }

        @Nullable
        public Action getResolveAction(@NotNull MergeResult result2) {
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchMergeTool$MyApplyPatchViewer", "getResolveAction"));
            }
            if (result2 == MergeResult.LEFT || result2 == MergeResult.RIGHT) {
                return null;
            }
            return MergeUtil.createSimpleResolveAction(result2, this.myMergeRequest, this.myMergeContext, this);
        }

        @Override
        protected void onChangeResolved() {
            super.onChangeResolved();
            if (!ContainerUtil.exists(this.getModelChanges(), c -> !c.isResolved())) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    JComponent component = this.getComponent();
                    int yOffset = new RelativePoint((Component)this.getResultEditor().getComponent(), (Point)new Point((int)0, (int)JBUI.scale((int)5))).getPoint((Component)component).y;
                    RelativePoint point = new RelativePoint((Component)component, new Point(component.getWidth() / 2, yOffset));
                    String message = DiffBundle.message((String)"apply.patch.all.changes.processed.message.text", (Object[])new Object[0]);
                    DiffUtil.showSuccessPopup(message, point, this, () -> {
                        if (this.isDisposed()) {
                            return;
                        }
                        this.myMergeContext.finishMerge(MergeResult.RESOLVED);
                    });
                });
            }
        }
    }
}

