/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.UnversionedViewDialog;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.changes.actions.RollbackDialogAction;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.EditSourceForDialogAction;
import com.intellij.openapi.vcs.changes.ui.SelectedListChangeListener;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultipleChangeListBrowser
extends ChangesBrowserBase<Object> {
    @NotNull
    private final ChangeListChooser myChangeListChooser;
    @NotNull
    final ChangeListListener myChangeListListener;
    @NotNull
    private final EventDispatcher<SelectedListChangeListener> myDispatcher;
    @Nullable
    private final Runnable myRebuildListListener;
    @NotNull
    private final VcsConfiguration myVcsConfiguration;
    private final boolean myUnversionedFilesEnabled;
    private Collection<Change> myAllChanges;
    private boolean myInRebuildList;
    private AnAction myMoveActionWithCustomShortcut;

    public MultipleChangeListBrowser(Project project2, List<? extends ChangeList> changeLists, @NotNull List<Object> changes, ChangeList initialListSelection, boolean capableOfExcludingChanges, boolean highlightProblems, @Nullable Runnable rebuildListListener, @Nullable Runnable inclusionListener, boolean unversionedFilesEnabled) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "<init>"));
        }
        super(project2, changes, capableOfExcludingChanges, highlightProblems, inclusionListener, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null, Object.class);
        this.myChangeListListener = new MyChangeListListener();
        this.myDispatcher = EventDispatcher.create(SelectedListChangeListener.class);
        this.myRebuildListListener = rebuildListListener;
        this.myVcsConfiguration = (VcsConfiguration)ObjectUtils.assertNotNull((Object)VcsConfiguration.getInstance((Project)this.myProject));
        this.myUnversionedFilesEnabled = unversionedFilesEnabled;
        this.init();
        this.setInitialSelection(changeLists, changes, initialListSelection);
        this.myChangeListChooser = new ChangeListChooser();
        this.myChangeListChooser.updateLists(changeLists);
        this.myHeaderPanel.add((Component)this.myChangeListChooser, "East");
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener(this.myChangeListListener);
        this.setupRebuildListForActions();
        this.rebuildList();
    }

    private void setupRebuildListForActions() {
        ActionManager actionManager = ActionManager.getInstance();
        final AnAction moveAction = actionManager.getAction("ChangesView.Move");
        final AnAction deleteAction = actionManager.getAction("ChangesView.DeleteUnversioned.From.Dialog");
        actionManager.addAnActionListener((AnActionListener)new AnActionListener.Adapter(){

            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                if (moveAction.equals(action) || MultipleChangeListBrowser.this.myMoveActionWithCustomShortcut != null && MultipleChangeListBrowser.this.myMoveActionWithCustomShortcut.equals(action)) {
                    MultipleChangeListBrowser.this.rebuildList();
                } else if (deleteAction.equals(action)) {
                    UnversionedViewDialog.refreshChanges(MultipleChangeListBrowser.this.myProject, MultipleChangeListBrowser.this);
                }
            }
        }, (Disposable)this);
    }

    private boolean isShowUnversioned() {
        return this.myUnversionedFilesEnabled && this.myVcsConfiguration.SHOW_UNVERSIONED_FILES_WHILE_COMMIT;
    }

    @Override
    protected void setInitialSelection(@NotNull List<? extends ChangeList> changeLists, @NotNull List<Object> changes, @Nullable ChangeList initialListSelection) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "setInitialSelection"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "setInitialSelection"));
        }
        this.myAllChanges = ContainerUtil.newArrayList();
        this.mySelectedChangeList = initialListSelection;
        for (ChangeList changeList : changeLists) {
            if (!(changeList instanceof LocalChangeList)) continue;
            this.myAllChanges.addAll(changeList.getChanges());
            if (initialListSelection != null || !ContainerUtil.intersects((Collection)changeList.getChanges(), changes)) continue;
            this.mySelectedChangeList = changeList;
        }
        if (this.mySelectedChangeList == null) {
            this.mySelectedChangeList = (ChangeList)ObjectUtils.chooseNotNull((Object)MultipleChangeListBrowser.findDefaultList(changeLists), (Object)ContainerUtil.getFirstItem(changeLists));
        }
    }

    @Override
    public void dispose() {
        ChangeListManager.getInstance((Project)this.myProject).removeChangeListListener(this.myChangeListListener);
    }

    public void addSelectedListChangeListener(@NotNull SelectedListChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "addSelectedListChangeListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    private void setSelectedList(@Nullable ChangeList list) {
        this.mySelectedChangeList = list;
        this.rebuildList();
        ((SelectedListChangeListener)this.myDispatcher.getMulticaster()).selectedListChanged();
    }

    @Override
    public void rebuildList() {
        if (this.myInRebuildList) {
            return;
        }
        try {
            this.myInRebuildList = true;
            this.myAllChanges = this.getLocalChanges();
            this.updateListsInChooser();
            super.rebuildList();
            if (this.myRebuildListListener != null) {
                this.myRebuildListListener.run();
            }
        }
        finally {
            this.myInRebuildList = false;
        }
    }

    @NotNull
    private Collection<Change> getLocalChanges() {
        ArrayList result2 = ContainerUtil.newArrayList();
        ChangeListManager manager = ChangeListManager.getInstance((Project)this.myProject);
        for (LocalChangeList list : manager.getChangeListsCopy()) {
            for (Change change : list.getChanges()) {
                result2.add(change);
            }
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "getLocalChanges"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Change> getCurrentIncludedChanges() {
        Collection includedObjects = this.myViewer.getIncludedChanges();
        List<Change> list = this.mySelectedChangeList.getChanges().stream().filter(includedObjects::contains).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "getCurrentIncludedChanges"));
        }
        return list;
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel(@NotNull List<Object> objects, @Nullable ChangeNodeDecorator changeNodeDecorator, boolean showFlatten) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "buildTreeModel"));
        }
        ChangeListManagerImpl manager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
        TreeModelBuilder builder = new TreeModelBuilder(this.myProject, showFlatten);
        builder.setChanges(MultipleChangeListBrowser.findChanges(objects), changeNodeDecorator);
        if (this.isShowUnversioned()) {
            builder.setUnversioned(manager.getUnversionedFiles(), manager.getUnversionedFilesSize());
        }
        DefaultTreeModel defaultTreeModel = builder.build();
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "buildTreeModel"));
        }
        return defaultTreeModel;
    }

    @Override
    @NotNull
    protected List<Object> getSelectedObjects(@NotNull ChangesBrowserNode<Object> node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "getSelectedObjects"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.addAll(node.getAllChangesUnder());
        if (this.isShowUnversioned() && MultipleChangeListBrowser.isUnderUnversioned(node)) {
            result2.addAll(node.getAllFilesUnder());
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "getSelectedObjects"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected Object getLeadSelectedObject(@NotNull ChangesBrowserNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "getLeadSelectedObject"));
        }
        Object result2 = null;
        Object userObject = node.getUserObject();
        if (userObject instanceof Change || this.isShowUnversioned() && MultipleChangeListBrowser.isUnderUnversioned(node) && userObject instanceof VirtualFile) {
            result2 = userObject;
        }
        return result2;
    }

    @Override
    @NotNull
    public List<Object> getCurrentDisplayedObjects() {
        List<Change> list = this.getCurrentDisplayedChanges();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "getCurrentDisplayedObjects"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> getIncludedUnversionedFiles() {
        List list = this.isShowUnversioned() ? ContainerUtil.findAll(this.myViewer.getIncludedChanges(), VirtualFile.class) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "getIncludedUnversionedFiles"));
        }
        return list;
    }

    @Override
    public int getUnversionedFilesCount() {
        ChangesBrowserUnversionedFilesNode node;
        int result2 = 0;
        if (this.isShowUnversioned() && (node = this.findUnversionedFilesNode()) != null) {
            result2 = node.getUnversionedSize();
        }
        return result2;
    }

    @Nullable
    private ChangesBrowserUnversionedFilesNode findUnversionedFilesNode() {
        Enumeration<TreeNode> nodes = this.myViewer.getRoot().breadthFirstEnumeration();
        return (ChangesBrowserUnversionedFilesNode)ContainerUtil.findInstance((Iterator)ContainerUtil.iterate(nodes), ChangesBrowserUnversionedFilesNode.class);
    }

    @Override
    @NotNull
    public List<Change> getSelectedChanges() {
        LinkedHashSet changes = ContainerUtil.newLinkedHashSet();
        TreePath[] paths = this.myViewer.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                ChangesBrowserNode node = (ChangesBrowserNode)path.getLastPathComponent();
                changes.addAll(node.getAllChangesUnder());
            }
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)changes);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "getSelectedChanges"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Change> getAllChanges() {
        List<Change> list = this.myViewer.getRoot().getAllChangesUnder();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "getAllChanges"));
        }
        return list;
    }

    @Override
    @NotNull
    public Set<AbstractVcs> getAffectedVcses() {
        Set set = ChangesUtil.getAffectedVcses(this.myAllChanges, (Project)this.myProject);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "getAffectedVcses"));
        }
        return set;
    }

    @Override
    protected void buildToolBar(@NotNull DefaultActionGroup toolBarGroup) {
        if (toolBarGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolBarGroup", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "buildToolBar"));
        }
        super.buildToolBar(toolBarGroup);
        toolBarGroup.add(new AnAction("Refresh Changes", null, AllIcons.Actions.Refresh){

            public void actionPerformed(AnActionEvent e) {
                MultipleChangeListBrowser.this.rebuildList();
            }
        });
        if (this.myUnversionedFilesEnabled) {
            toolBarGroup.add((AnAction)new ShowHideUnversionedFilesAction());
            toolBarGroup.add((AnAction)UnversionedViewDialog.getUnversionedActionGroup());
        } else {
            toolBarGroup.add(ActionManager.getInstance().getAction("ChangesView.Move"));
        }
        UnversionedViewDialog.registerUnversionedActionsShortcuts(DataManager.getInstance().getDataContext((Component)this), (JComponent)((Object)this.myViewer));
        this.myMoveActionWithCustomShortcut = EmptyAction.registerWithShortcutSet((String)"ChangesView.Move", (ShortcutSet)CommonShortcuts.getMove(), (JComponent)((Object)this.myViewer));
        RollbackDialogAction rollback = new RollbackDialogAction();
        rollback.registerCustomShortcutSet(this, null);
        toolBarGroup.add((AnAction)rollback);
        EditSourceForDialogAction editSourceAction = new EditSourceForDialogAction(this);
        editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this);
        toolBarGroup.add((AnAction)editSourceAction);
        toolBarGroup.add(ActionManager.getInstance().getAction("Vcs.CheckinProjectToolbar"));
    }

    @Override
    protected List<AnAction> createDiffActions() {
        List<AnAction> actions = super.createDiffActions();
        actions.add(new MoveAction());
        return actions;
    }

    private void updateListsInChooser() {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                MultipleChangeListBrowser.this.myChangeListChooser.updateLists(ChangeListManager.getInstance((Project)MultipleChangeListBrowser.this.myProject).getChangeListsCopy());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.stateForComponent((Component)this));
        }
    }

    @Nullable
    private static ChangeList findDefaultList(@NotNull List<? extends ChangeList> lists) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "findDefaultList"));
        }
        return (ChangeList)ContainerUtil.find(lists, (Condition)new Condition<ChangeList>(){

            public boolean value(@NotNull ChangeList list) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser$4", "value"));
                }
                return list instanceof LocalChangeList && ((LocalChangeList)list).isDefault();
            }
        });
    }

    private class MoveAction
    extends MoveChangesToAnotherListAction {
        private MoveAction() {
        }

        @Override
        protected boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser$MoveAction", "isEnabled"));
            }
            Change change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE);
            if (change == null) {
                return false;
            }
            return super.isEnabled(e);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser$MoveAction", "actionPerformed"));
            }
            Change change = (Change)e.getRequiredData(VcsDataKeys.CURRENT_CHANGE);
            MoveAction.askAndMove(MultipleChangeListBrowser.this.myProject, Collections.singletonList(change), Collections.emptyList());
        }
    }

    private class ShowHideUnversionedFilesAction
    extends ToggleAction {
        private ShowHideUnversionedFilesAction() {
            super("Show Unversioned Files", null, AllIcons.Debugger.Disable_value_calculation);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser$ShowHideUnversionedFilesAction", "update"));
            }
            super.update(e);
            e.getPresentation().setEnabledAndVisible(ActionPlaces.isToolbarPlace((String)e.getPlace()));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser$ShowHideUnversionedFilesAction", "isSelected"));
            }
            return ((MultipleChangeListBrowser)MultipleChangeListBrowser.this).myVcsConfiguration.SHOW_UNVERSIONED_FILES_WHILE_COMMIT;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser$ShowHideUnversionedFilesAction", "setSelected"));
            }
            ((MultipleChangeListBrowser)MultipleChangeListBrowser.this).myVcsConfiguration.SHOW_UNVERSIONED_FILES_WHILE_COMMIT = state;
            MultipleChangeListBrowser.this.rebuildList();
        }
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        private MyChangeListListener() {
        }

        public void changeListAdded(ChangeList list) {
            MultipleChangeListBrowser.this.updateListsInChooser();
        }
    }

    private class ChangeListChooser
    extends JPanel {
        private static final int MAX_LEN = 35;
        @NotNull
        private final ComboBox myChooser;

        public ChangeListChooser() {
            super(new BorderLayout(4, 2));
            this.myChooser = new ComboBox();
            this.myChooser.setRenderer((ListCellRenderer)new ColoredListCellRendererWrapper<LocalChangeList>(){

                protected void doCustomize(JList list, LocalChangeList value, int index, boolean selected, boolean hasFocus) {
                    if (value != null) {
                        String name = StringUtil.shortenTextWithEllipsis((String)value.getName().trim(), (int)35, (int)0);
                        this.append(name, value.isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            });
            this.myChooser.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LocalChangeList changeList = (LocalChangeList)ChangeListChooser.this.myChooser.getSelectedItem();
                        MultipleChangeListBrowser.this.setSelectedList((ChangeList)changeList);
                        ChangeListChooser.this.myChooser.setToolTipText(changeList == null ? "" : changeList.getName());
                    }
                }
            });
            this.myChooser.setEditable(false);
            this.add((Component)this.myChooser, "Center");
            JLabel label = new JLabel(VcsBundle.message((String)"commit.dialog.changelist.label", (Object[])new Object[0]));
            label.setLabelFor((Component)this.myChooser);
            this.add((Component)label, "West");
        }

        public void updateLists(@NotNull List<? extends ChangeList> lists) {
            if (lists == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser$ChangeListChooser", "updateLists"));
            }
            this.myChooser.setModel(new DefaultComboBoxModel<Object>(lists.toArray()));
            this.myChooser.setEnabled(lists.size() > 1);
            if (lists.contains(MultipleChangeListBrowser.this.mySelectedChangeList)) {
                this.myChooser.setSelectedItem((Object)MultipleChangeListBrowser.this.mySelectedChangeList);
            } else if (this.myChooser.getItemCount() > 0) {
                this.myChooser.setSelectedIndex(0);
            }
            MultipleChangeListBrowser.this.mySelectedChangeList = (ChangeList)this.myChooser.getSelectedItem();
        }
    }
}

