/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopup;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LineStatusMarkerRenderer
implements ActiveGutterRenderer {
    @NotNull
    protected final Range myRange;

    public LineStatusMarkerRenderer(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "<init>"));
        }
        this.myRange = range;
    }

    @NotNull
    public static RangeHighlighter createRangeHighlighter(@NotNull Range range, @NotNull TextRange textRange, @NotNull MarkupModel markupModel) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "createRangeHighlighter"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "createRangeHighlighter"));
        }
        if (markupModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markupModel", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "createRangeHighlighter"));
        }
        TextAttributes attributes = LineStatusMarkerRenderer.getTextAttributes(range);
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 999, attributes, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setThinErrorStripeMark(true);
        highlighter.setGreedyToLeft(true);
        highlighter.setGreedyToRight(true);
        highlighter.setErrorStripeTooltip((Object)LineStatusMarkerRenderer.getTooltipText(range));
        RangeHighlighter rangeHighlighter = highlighter;
        if (rangeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "createRangeHighlighter"));
        }
        return rangeHighlighter;
    }

    @NotNull
    public static LineMarkerRenderer createRenderer(@NotNull Range range, final @Nullable Function<Editor, LineStatusMarkerPopup> popupBuilder) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "createRenderer"));
        }
        LineStatusMarkerRenderer lineStatusMarkerRenderer = new LineStatusMarkerRenderer(range){

            @Override
            public boolean canDoAction(MouseEvent e) {
                return popupBuilder != null && 1.isInsideMarkerArea(e);
            }

            @Override
            public void doAction(Editor editor, MouseEvent e) {
                LineStatusMarkerPopup popup;
                LineStatusMarkerPopup lineStatusMarkerPopup = popup = popupBuilder != null ? (LineStatusMarkerPopup)popupBuilder.fun((Object)editor) : null;
                if (popup != null) {
                    popup.showHint(e);
                }
            }
        };
        if (lineStatusMarkerRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "createRenderer"));
        }
        return lineStatusMarkerRenderer;
    }

    @NotNull
    public static LineMarkerRenderer createRenderer(final int line1, final int line2, final @NotNull Color color, final @Nullable String tooltip, final @Nullable PairConsumer<Editor, MouseEvent> action) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "createRenderer"));
        }
        ActiveGutterRenderer activeGutterRenderer = new ActiveGutterRenderer(){

            public void paint(Editor editor, Graphics g, Rectangle r) {
                Rectangle area = LineStatusMarkerRenderer.getMarkerArea(editor, r, line1, line2);
                Color borderColor = LineStatusMarkerRenderer.getGutterBorderColor(editor);
                if (area.height != 0) {
                    LineStatusMarkerRenderer.paintRect(g, color, borderColor, area.x, area.y, area.x + area.width, area.y + area.height);
                } else {
                    LineStatusMarkerRenderer.paintTriangle(g, color, borderColor, area.x, area.x + area.width, area.y);
                }
            }

            @Nullable
            public String getTooltipText() {
                return tooltip;
            }

            public boolean canDoAction(MouseEvent e) {
                return LineStatusMarkerRenderer.isInsideMarkerArea(e);
            }

            public void doAction(Editor editor, MouseEvent e) {
                if (action != null) {
                    action.consume((Object)editor, (Object)e);
                }
            }
        };
        if (activeGutterRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "createRenderer"));
        }
        return activeGutterRenderer;
    }

    @NotNull
    private static TextAttributes getTextAttributes(final @NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "getTextAttributes"));
        }
        TextAttributes textAttributes = new TextAttributes(){

            public Color getErrorStripeColor() {
                return LineStatusMarkerRenderer.getErrorStripeColor(range, null);
            }
        };
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "getTextAttributes"));
        }
        return textAttributes;
    }

    @NotNull
    private static String getTooltipText(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "getTooltipText"));
        }
        if (range.getLine1() == range.getLine2()) {
            if (range.getVcsLine1() + 1 == range.getVcsLine2()) {
                String string = VcsBundle.message((String)"tooltip.text.line.before.deleted", (Object[])new Object[]{range.getLine1() + 1});
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "getTooltipText"));
                }
                return string;
            }
            String string = VcsBundle.message((String)"tooltip.text.lines.before.deleted", (Object[])new Object[]{range.getLine1() + 1, range.getVcsLine2() - range.getVcsLine1()});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "getTooltipText"));
            }
            return string;
        }
        if (range.getLine1() + 1 == range.getLine2()) {
            String string = VcsBundle.message((String)"tooltip.text.line.changed", (Object[])new Object[]{range.getLine1() + 1});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "getTooltipText"));
            }
            return string;
        }
        String string = VcsBundle.message((String)"tooltip.text.lines.changed", (Object[])new Object[]{range.getLine1() + 1, range.getLine2()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "getTooltipText"));
        }
        return string;
    }

    public void paint(Editor editor, Graphics g, Rectangle r) {
        Color gutterColor = LineStatusMarkerRenderer.getGutterColor(this.myRange, editor);
        Color borderColor = LineStatusMarkerRenderer.getGutterBorderColor(editor);
        Rectangle area = LineStatusMarkerRenderer.getMarkerArea(editor, r, this.myRange.getLine1(), this.myRange.getLine2());
        int x = area.x;
        int endX = area.x + area.width;
        int y = area.y;
        int endY = area.y + area.height;
        if (this.myRange.getInnerRanges() == null) {
            if (y != endY) {
                LineStatusMarkerRenderer.paintRect(g, gutterColor, borderColor, x, y, endX, endY);
            } else {
                LineStatusMarkerRenderer.paintTriangle(g, gutterColor, borderColor, x, endX, y);
            }
        } else if (y == endY) {
            LineStatusMarkerRenderer.paintTriangle(g, gutterColor, borderColor, x, endX, y);
        } else {
            int end;
            int start;
            List<Range.InnerRange> innerRanges = this.myRange.getInnerRanges();
            for (Range.InnerRange innerRange : innerRanges) {
                if (innerRange.getType() == 3) continue;
                start = DiffDrawUtil.lineToY(editor, innerRange.getLine1());
                end = DiffDrawUtil.lineToY(editor, innerRange.getLine2());
                LineStatusMarkerRenderer.paintRect(g, LineStatusMarkerRenderer.getGutterColor(innerRange, editor), null, x, start, endX, end);
            }
            for (int i = 0; i < innerRanges.size(); ++i) {
                Range.InnerRange innerRange;
                innerRange = innerRanges.get(i);
                if (innerRange.getType() != 3) continue;
                if (i == 0) {
                    start = DiffDrawUtil.lineToY(editor, innerRange.getLine1());
                    end = DiffDrawUtil.lineToY(editor, innerRange.getLine2()) + 5;
                } else if (i == innerRanges.size() - 1) {
                    start = DiffDrawUtil.lineToY(editor, innerRange.getLine1()) - 5;
                    end = DiffDrawUtil.lineToY(editor, innerRange.getLine2());
                } else {
                    start = DiffDrawUtil.lineToY(editor, innerRange.getLine1()) - 3;
                    end = DiffDrawUtil.lineToY(editor, innerRange.getLine2()) + 3;
                }
                LineStatusMarkerRenderer.paintRect(g, LineStatusMarkerRenderer.getGutterColor(innerRange, editor), null, x, start, endX, end);
            }
            LineStatusMarkerRenderer.paintRect(g, null, borderColor, x, y, endX, endY);
        }
    }

    private static void paintRect(@NotNull Graphics g, @Nullable Color color, @Nullable Color borderColor, int x1, int y1, int x2, int y2) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "paintRect"));
        }
        if (color != null) {
            g.setColor(color);
            g.fillRect(x1, y1, x2 - x1, y2 - y1);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            UIUtil.drawLine((Graphics)g, (int)x1, (int)y1, (int)(x2 - 1), (int)y1);
            UIUtil.drawLine((Graphics)g, (int)x1, (int)y1, (int)x1, (int)(y2 - 1));
            UIUtil.drawLine((Graphics)g, (int)x1, (int)(y2 - 1), (int)(x2 - 1), (int)(y2 - 1));
        }
    }

    @NotNull
    public static Rectangle getMarkerArea(@NotNull Editor editor, @NotNull Rectangle r, int line1, int line2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "getMarkerArea"));
        }
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "getMarkerArea"));
        }
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        int x = r.x + 1;
        int endX = gutter.getWhitespaceSeparatorOffset();
        int y = DiffDrawUtil.lineToY(editor, line1);
        int endY = DiffDrawUtil.lineToY(editor, line2);
        Rectangle rectangle = new Rectangle(x, y, endX - x, endY - y);
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "getMarkerArea"));
        }
        return rectangle;
    }

    public static boolean isInsideMarkerArea(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "isInsideMarkerArea"));
        }
        EditorGutterComponentEx gutter = (EditorGutterComponentEx)e.getComponent();
        return e.getX() > gutter.getLineMarkerFreePaintersAreaOffset();
    }

    private static void paintTriangle(@NotNull Graphics g, @Nullable Color color, @Nullable Color borderColor, int x1, int x2, int y) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "paintTriangle"));
        }
        int size = 4;
        int[] xPoints = new int[]{x1, x1, x2};
        int[] yPoints = new int[]{y - size, y + size, y};
        if (color != null) {
            g.setColor(color);
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawPolygon(xPoints, yPoints, xPoints.length);
        }
    }

    @Nullable
    private static Color getGutterColor(@NotNull Range.InnerRange range, @Nullable Editor editor) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "getGutterColor"));
        }
        EditorColorsScheme scheme = LineStatusMarkerRenderer.getColorScheme(editor);
        switch (range.getType()) {
            case 2: {
                return scheme.getColor(EditorColors.ADDED_LINES_COLOR);
            }
            case 3: {
                return scheme.getColor(EditorColors.DELETED_LINES_COLOR);
            }
            case 1: {
                return scheme.getColor(EditorColors.MODIFIED_LINES_COLOR);
            }
            case 0: {
                return scheme.getColor(EditorColors.WHITESPACES_MODIFIED_LINES_COLOR);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    private static Color getErrorStripeColor(@NotNull Range range, @Nullable Editor editor) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "getErrorStripeColor"));
        }
        EditorColorsScheme scheme = LineStatusMarkerRenderer.getColorScheme(editor);
        switch (range.getType()) {
            case 2: {
                return scheme.getAttributes(DiffColors.DIFF_INSERTED).getErrorStripeColor();
            }
            case 3: {
                return scheme.getAttributes(DiffColors.DIFF_DELETED).getErrorStripeColor();
            }
            case 1: {
                return scheme.getAttributes(DiffColors.DIFF_MODIFIED).getErrorStripeColor();
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    private static Color getGutterColor(@NotNull Range range, @Nullable Editor editor) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "getGutterColor"));
        }
        EditorColorsScheme scheme = LineStatusMarkerRenderer.getColorScheme(editor);
        switch (range.getType()) {
            case 2: {
                return scheme.getColor(EditorColors.ADDED_LINES_COLOR);
            }
            case 3: {
                return scheme.getColor(EditorColors.DELETED_LINES_COLOR);
            }
            case 1: {
                return scheme.getColor(EditorColors.MODIFIED_LINES_COLOR);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    private static Color getGutterBorderColor(@Nullable Editor editor) {
        return LineStatusMarkerRenderer.getColorScheme(editor).getColor(EditorColors.BORDER_LINES_COLOR);
    }

    @NotNull
    private static EditorColorsScheme getColorScheme(@Nullable Editor editor) {
        EditorColorsScheme editorColorsScheme = editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusMarkerRenderer", "getColorScheme"));
        }
        return editorColorsScheme;
    }

    public boolean canDoAction(MouseEvent e) {
        return false;
    }

    public void doAction(Editor editor, MouseEvent e) {
    }
}

