/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

class CanonicalPathMap {
    private static final Logger LOG = Logger.getInstance(FileWatcher.class);
    private final List<String> myRecursiveWatchRoots;
    private final List<String> myFlatWatchRoots;
    private final List<String> myCanonicalRecursiveWatchRoots;
    private final List<String> myCanonicalFlatWatchRoots;
    private final MultiMap<String, String> myPathMapping;

    public CanonicalPathMap() {
        this.myCanonicalFlatWatchRoots = Collections.emptyList();
        this.myFlatWatchRoots = this.myCanonicalFlatWatchRoots;
        this.myCanonicalRecursiveWatchRoots = this.myCanonicalFlatWatchRoots;
        this.myRecursiveWatchRoots = this.myCanonicalFlatWatchRoots;
        this.myPathMapping = MultiMap.empty();
    }

    public CanonicalPathMap(@NotNull List<String> recursive, @NotNull List<String> flat) {
        if (recursive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recursive", "com/intellij/openapi/vfs/impl/local/CanonicalPathMap", "<init>"));
        }
        if (flat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flat", "com/intellij/openapi/vfs/impl/local/CanonicalPathMap", "<init>"));
        }
        this.myRecursiveWatchRoots = ContainerUtil.newArrayList(recursive);
        this.myFlatWatchRoots = ContainerUtil.newArrayList(flat);
        List mapping = ContainerUtil.newSmartList();
        Map<String, String> resolvedPaths = CanonicalPathMap.resolvePaths(recursive, flat);
        this.myCanonicalRecursiveWatchRoots = CanonicalPathMap.mapPaths(resolvedPaths, recursive, mapping);
        this.myCanonicalFlatWatchRoots = CanonicalPathMap.mapPaths(resolvedPaths, flat, mapping);
        this.myPathMapping = MultiMap.createConcurrentSet();
        this.addMapping(mapping);
    }

    private static Map<String, String> resolvePaths(Collection<String> recursiveRoots, Collection<String> flatRoots) {
        ConcurrentMap result2 = ContainerUtil.newConcurrentMap();
        List roots = ContainerUtil.concat(Arrays.asList(recursiveRoots, flatRoots));
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(roots, null, false, false, root -> {
            ContainerUtil.putIfNotNull((Object)root, (Object)FileSystemUtil.resolveSymLink((String)root), (Map)result2);
            return true;
        });
        return result2;
    }

    private static List<String> mapPaths(Map<String, String> resolvedPaths, List<String> paths, Collection<Pair<String, String>> mapping) {
        ArrayList canonicalPaths = ContainerUtil.newArrayList(paths);
        for (int i = 0; i < paths.size(); ++i) {
            String path = paths.get(i);
            String canonicalPath = resolvedPaths.get(path);
            if (canonicalPath == null || path.equals(canonicalPath)) continue;
            canonicalPaths.set(i, canonicalPath);
            mapping.add((Pair<String, String>)Pair.pair((Object)canonicalPath, (Object)path));
        }
        return canonicalPaths;
    }

    public List<String> getCanonicalRecursiveWatchRoots() {
        return this.myCanonicalRecursiveWatchRoots;
    }

    public List<String> getCanonicalFlatWatchRoots() {
        return this.myCanonicalFlatWatchRoots;
    }

    public void addMapping(@NotNull Collection<Pair<String, String>> mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/openapi/vfs/impl/local/CanonicalPathMap", "addMapping"));
        }
        for (Pair<String, String> pair : mapping) {
            Collection preRemapPathToWatchedPaths = this.myPathMapping.get(pair.second);
            for (String realWatchedPath : preRemapPathToWatchedPaths) {
                Collection remappedPathMappings = this.myPathMapping.getModifiable(pair.first);
                remappedPathMappings.add(realWatchedPath);
            }
            Collection symLinksToCanonicalPath = this.myPathMapping.getModifiable(pair.first);
            symLinksToCanonicalPath.add(pair.second);
        }
    }

    @NotNull
    public Collection<String> getWatchedPaths(@NotNull String reportedPath, boolean isExact) {
        if (reportedPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportedPath", "com/intellij/openapi/vfs/impl/local/CanonicalPathMap", "getWatchedPaths"));
        }
        if (this.myFlatWatchRoots.isEmpty() && this.myRecursiveWatchRoots.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/CanonicalPathMap", "getWatchedPaths"));
            }
            return list;
        }
        Collection<String> affectedPaths = this.applyMapping(reportedPath);
        List changedPaths = ContainerUtil.newSmartList();
        block0: for (String path : affectedPaths) {
            String rootParent;
            for (String root : this.myFlatWatchRoots) {
                if (FileUtil.namesEqual((String)path, (String)root)) {
                    changedPaths.add(path);
                    continue block0;
                }
                if (isExact) {
                    String parentPath = new File(path).getParent();
                    if (parentPath == null || !FileUtil.namesEqual((String)parentPath, (String)root)) continue;
                    changedPaths.add(path);
                    continue block0;
                }
                rootParent = new File(root).getParent();
                if (rootParent == null || !FileUtil.namesEqual((String)path, (String)rootParent)) continue;
                changedPaths.add(root);
                continue block0;
            }
            for (String root : this.myRecursiveWatchRoots) {
                if (FileUtil.startsWith((String)path, (String)root)) {
                    changedPaths.add(path);
                    continue block0;
                }
                if (isExact || (rootParent = new File(root).getParent()) == null || !FileUtil.namesEqual((String)path, (String)rootParent)) continue;
                changedPaths.add(root);
                continue block0;
            }
        }
        if (changedPaths.isEmpty() && LOG.isDebugEnabled()) {
            LOG.debug("Not watchable, filtered: " + reportedPath);
        }
        List list = changedPaths;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/CanonicalPathMap", "getWatchedPaths"));
        }
        return list;
    }

    private Collection<String> applyMapping(String reportedPath) {
        List results = ContainerUtil.newSmartList((Object)reportedPath);
        List pathComponents = FileUtil.splitPath((String)reportedPath);
        File runningPath = null;
        for (int i = 0; i < pathComponents.size(); ++i) {
            String currentPathComponent = (String)pathComponents.get(i);
            runningPath = runningPath == null ? new File(currentPathComponent.isEmpty() ? "/" : currentPathComponent) : new File(runningPath, currentPathComponent);
            Collection mappedPaths = this.myPathMapping.get((Object)runningPath.getPath());
            for (String mappedPath : mappedPaths) {
                String fileSuffix = StringUtil.join(pathComponents.subList(i + 1, pathComponents.size()), (String)File.separator);
                results.add(new File(mappedPath, fileSuffix).getPath());
            }
        }
        return results;
    }
}

