/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodObjectHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExtractMethodObjectHandler.class.getName()));

    public void invoke(final @NotNull Project project2, final Editor editor, final PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invoke"));
        }
        ExtractMethodHandler.selectAndPass(project2, editor, file2, new Pass<PsiElement[]>(){

            public void pass(PsiElement[] selectedValue) {
                ExtractMethodObjectHandler.invokeOnElements(project2, editor, file2, selectedValue);
            }
        });
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "isAvailableForQuickList"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "isAvailableForQuickList"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "isAvailableForQuickList"));
        }
        PsiElement[] elements = ExtractMethodHandler.getElements(file2.getProject(), editor, file2);
        return elements != null && elements.length > 0;
    }

    private static void invokeOnElements(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull PsiElement[] elements) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invokeOnElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invokeOnElements"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invokeOnElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invokeOnElements"));
        }
        if (elements.length == 0) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)"Extract Method Object", (String)"refactoring.extractMethodObject");
            return;
        }
        try {
            ExtractMethodObjectHandler.extractMethodObject(project2, editor, new ExtractMethodObjectProcessor(project2, editor, elements, ""));
        }
        catch (PrepareFailedException e) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)e.getMessage(), (String)"Extract Method Object", (String)"refactoring.extractMethodObject");
            ExtractMethodHandler.highlightPrepareError(e, file2, editor, project2);
        }
    }

    static void extractMethodObject(Project project2, Editor editor, ExtractMethodObjectProcessor processor2) throws PrepareFailedException {
        ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor = processor2.getExtractProcessor();
        if (!extractProcessor.prepare()) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)extractProcessor.getTargetClass().getContainingFile())) {
            return;
        }
        if (extractProcessor.showDialog()) {
            ExtractMethodObjectHandler.run(project2, editor, processor2, extractProcessor);
        }
    }

    public static void run(@NotNull Project project2, Editor editor, @NotNull ExtractMethodObjectProcessor processor2, @NotNull ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor) {
        RangeMarker marker;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "run"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "run"));
        }
        if (extractProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractProcessor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "run"));
        }
        if (editor != null) {
            int offset = editor.getCaretModel().getOffset();
            marker = editor.getDocument().createRangeMarker(new TextRange(offset, offset));
        } else {
            marker = null;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "lambda$run$5"));
            }
            if (extractProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractProcessor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "lambda$run$5"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "lambda$run$5"));
            }
            PostprocessReformattingAspect.getInstance(project2).postponeFormattingInside(() -> {
                if (extractProcessor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractProcessor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "lambda$null$4"));
                }
                if (processor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "lambda$null$4"));
                }
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "lambda$null$4"));
                }
                try {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (extractProcessor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractProcessor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "lambda$null$0"));
                        }
                        extractProcessor.doRefactoring();
                    });
                    processor2.run();
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (processor2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "lambda$null$1"));
                        }
                        processor2.runChangeSignature();
                    });
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                if (processor2.isCreateInnerClass()) {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (processor2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "lambda$null$2"));
                        }
                        processor2.moveUsedMethodsToInner();
                    });
                    PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                    if (editor != null) {
                        DuplicatesImpl.processDuplicates(extractProcessor, project2, editor);
                    }
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    PsiMethod method;
                    if (processor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "lambda$null$3"));
                    }
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "lambda$null$3"));
                    }
                    if (processor2.isCreateInnerClass()) {
                        processor2.changeInstanceAccess(project2);
                    }
                    LOG.assertTrue((method = processor2.getMethod()) != null);
                    method.delete();
                });
            });
        }, "Extract Method Object", (Object)"Extract Method Object");
        if (editor != null) {
            editor.getCaretModel().moveToOffset(marker.getStartOffset());
            marker.dispose();
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invoke"));
        }
        throw new UnsupportedOperationException();
    }
}

