/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.inlineSuperClass.InlineSuperClassRefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Collection;

public class InlineSuperClassRefactoringHandler
extends JavaInlineActionHandler {
    public static final String REFACTORING_NAME = "Inline Super Class";

    public boolean isEnabledOnElement(PsiElement element) {
        return element instanceof PsiClass;
    }

    public boolean canInlineElement(PsiElement element) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        if (element.getLanguage() != StdLanguages.JAVA) {
            return false;
        }
        Collection inheritors = DirectClassInheritorsSearch.search((PsiClass)((PsiClass)element)).findAll();
        return inheritors.size() > 0;
    }

    public void inlineElement(Project project2, Editor editor, PsiElement element) {
        PsiElement gParent;
        PsiElement parent;
        PsiElement referenceElement;
        PsiElement resolve2;
        PsiReference reference;
        PsiClass superClass = (PsiClass)element;
        if (!superClass.getManager().isInProject((PsiElement)superClass)) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"Cannot inline non-project class", (String)REFACTORING_NAME, null);
            return;
        }
        PsiClass chosen = null;
        PsiReference psiReference = reference = editor != null ? TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset()) : null;
        if (reference != null && (resolve2 = reference.resolve()) == superClass && (referenceElement = reference.getElement()) != null && (parent = referenceElement.getParent()) instanceof PsiReferenceList && (gParent = parent.getParent()) instanceof PsiClass) {
            chosen = (PsiClass)gParent;
        }
        new InlineSuperClassRefactoringDialog(project2, superClass, chosen).show();
    }
}

