/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.turnRefsToSuper;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperHandler;
import com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperProcessor;
import com.intellij.refactoring.ui.ClassCellRenderer;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TurnRefsToSuperDialog
extends RefactoringDialog {
    @NotNull
    private final PsiClass mySubClass;
    private final List mySuperClasses;
    private JList mySuperClassesList;
    private final JCheckBox myCbReplaceInstanceOf;

    TurnRefsToSuperDialog(Project project2, @NotNull PsiClass subClass, List superClasses) {
        if (subClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperDialog", "<init>"));
        }
        super(project2, true);
        this.myCbReplaceInstanceOf = new JCheckBox();
        this.mySubClass = subClass;
        this.mySuperClasses = superClasses;
        this.setTitle(TurnRefsToSuperHandler.REFACTORING_NAME);
        this.init();
    }

    @Nullable
    public PsiClass getSuperClass() {
        if (this.mySuperClassesList != null) {
            return (PsiClass)this.mySuperClassesList.getSelectedValue();
        }
        return null;
    }

    public boolean isUseInInstanceOf() {
        return this.myCbReplaceInstanceOf.isSelected();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.useInterface");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySuperClassesList;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(10, 4));
        JLabel classListLabel = new JLabel();
        panel.add((Component)classListLabel, "North");
        this.mySuperClassesList = new JBList(this.mySuperClasses.toArray());
        this.mySuperClassesList.setCellRenderer(new ClassCellRenderer(this.mySuperClassesList.getCellRenderer()));
        this.mySuperClassesList.getSelectionModel().setSelectionMode(0);
        classListLabel.setText(RefactoringBundle.message((String)"turnRefsToSuper.change.usages.to", (Object[])new Object[]{this.mySubClass.getQualifiedName()}));
        PsiClass nearestBase = RefactoringHierarchyUtil.getNearestBaseClass(this.mySubClass, true);
        int indexToSelect = 0;
        if (nearestBase != null) {
            indexToSelect = this.mySuperClasses.indexOf(nearestBase);
        }
        this.mySuperClassesList.setSelectedIndex(indexToSelect);
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.mySuperClassesList), "Center");
        this.myCbReplaceInstanceOf.setText(RefactoringBundle.message((String)"turnRefsToSuper.use.superclass.in.instanceof"));
        this.myCbReplaceInstanceOf.setSelected(false);
        this.myCbReplaceInstanceOf.setFocusable(false);
        panel.add((Component)this.myCbReplaceInstanceOf, "South");
        return panel;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperDialog";
    }

    @Override
    protected void doAction() {
        JavaRefactoringSettings.getInstance().TURN_REFS_TO_SUPER_PREVIEW_USAGES = this.isPreviewUsages();
        PsiClass superClass = this.getSuperClass();
        if (superClass != null) {
            this.invokeRefactoring(new TurnRefsToSuperProcessor(this.getProject(), this.mySubClass, superClass, this.isUseInInstanceOf()));
        }
    }

    protected JComponent createNorthPanel() {
        return null;
    }
}

