/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.slicer.SliceTreeBuilder;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;

class GroupByLeavesAction
extends AnAction {
    private final SliceTreeBuilder myTreeBuilder;
    private static final String TEXT = "Group by leaf expression";

    GroupByLeavesAction(@NotNull SliceTreeBuilder treeBuilder) {
        if (treeBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeBuilder", "com/intellij/slicer/GroupByLeavesAction", "<init>"));
        }
        super(TEXT, "Show original expression values that might appear in this place", PlatformIcons.XML_TAG_ICON);
        this.myTreeBuilder = treeBuilder;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setText(TEXT + (this.myTreeBuilder.analysisInProgress ? " (Analysis in progress)" : ""));
        e.getPresentation().setEnabled(this.isAvailabale());
    }

    private boolean isAvailabale() {
        return !this.myTreeBuilder.analysisInProgress && !this.myTreeBuilder.splitByLeafExpressions;
    }

    public void actionPerformed(AnActionEvent e) {
        this.myTreeBuilder.switchToGroupedByLeavesNodes();
    }
}

