/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.win;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.ui.win.RecentTasks;
import com.intellij.ui.win.Task;
import java.io.File;
import java.util.Locale;

public class WinDockDelegate
implements SystemDock.Delegate {
    private static SystemDock.Delegate instance;

    public static synchronized SystemDock.Delegate getInstance() {
        if (instance == null) {
            instance = new WinDockDelegate();
        }
        return instance;
    }

    private WinDockDelegate() {
    }

    @Override
    public void updateRecentProjectsMenu() {
        AnAction[] recentProjectActions = RecentProjectsManager.getInstance().getRecentProjectsActions(false);
        RecentTasks.clear();
        String name = ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.US);
        String launcher = RecentTasks.getShortenPath(PathManager.getBinPath() + File.separator + name + (SystemInfo.is64Bit ? "64" : "") + ".exe");
        Task[] tasks = new Task[recentProjectActions.length];
        for (int i = 0; i < recentProjectActions.length; ++i) {
            ReopenProjectAction rpa = (ReopenProjectAction)recentProjectActions[i];
            tasks[i] = new Task(launcher, RecentTasks.getShortenPath(rpa.getProjectPath()), rpa.getTemplatePresentation().getText());
        }
        RecentTasks.addTasks(tasks);
    }
}

