/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.textCompletion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultTextCompletionValueDescriptor<T>
implements TextCompletionValueDescriptor<T> {
    @NotNull
    protected abstract String getLookupString(@NotNull T var1);

    @Nullable
    protected Icon getIcon(@NotNull T item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/textCompletion/DefaultTextCompletionValueDescriptor", "getIcon"));
        }
        return null;
    }

    @Nullable
    protected String getTailText(@NotNull T item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/textCompletion/DefaultTextCompletionValueDescriptor", "getTailText"));
        }
        return null;
    }

    @Nullable
    protected String getTypeText(@NotNull T item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/textCompletion/DefaultTextCompletionValueDescriptor", "getTypeText"));
        }
        return null;
    }

    @Nullable
    protected InsertHandler<LookupElement> createInsertHandler(@NotNull T item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/textCompletion/DefaultTextCompletionValueDescriptor", "createInsertHandler"));
        }
        return null;
    }

    @Override
    public int compare(T item1, T item2) {
        return StringUtil.compare((String)this.getLookupString(item1), (String)this.getLookupString(item2), (boolean)false);
    }

    @Override
    @NotNull
    public LookupElementBuilder createLookupBuilder(@NotNull T item) {
        String typeText;
        String tailText;
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/textCompletion/DefaultTextCompletionValueDescriptor", "createLookupBuilder"));
        }
        LookupElementBuilder builder = LookupElementBuilder.create(item, (String)this.getLookupString(item)).withIcon(this.getIcon(item));
        InsertHandler<LookupElement> handler2 = this.createInsertHandler(item);
        if (handler2 != null) {
            builder = builder.withInsertHandler(handler2);
        }
        if ((tailText = this.getTailText(item)) != null) {
            builder = builder.withTailText(tailText, true);
        }
        if ((typeText = this.getTypeText(item)) != null) {
            builder = builder.withTypeText(typeText);
        }
        LookupElementBuilder lookupElementBuilder = builder;
        if (lookupElementBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/textCompletion/DefaultTextCompletionValueDescriptor", "createLookupBuilder"));
        }
        return lookupElementBuilder;
    }

    public static class StringValueDescriptor
    extends DefaultTextCompletionValueDescriptor<String> {
        @Override
        @NotNull
        public String getLookupString(@NotNull String item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/textCompletion/DefaultTextCompletionValueDescriptor$StringValueDescriptor", "getLookupString"));
            }
            String string = item;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/textCompletion/DefaultTextCompletionValueDescriptor$StringValueDescriptor", "getLookupString"));
            }
            return string;
        }
    }
}

