/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.primitives.Ints;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsGoToRefComparator;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogImpl
implements VcsLog {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUiImpl myUi;

    public VcsLogImpl(@NotNull VcsLogData manager, @NotNull VcsLogUiImpl ui) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/log/impl/VcsLogImpl", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/impl/VcsLogImpl", "<init>"));
        }
        this.myLogData = manager;
        this.myUi = ui;
    }

    @NotNull
    public List<CommitId> getSelectedCommits() {
        final int[] rows = this.myUi.getTable().getSelectedRows();
        AbstractList<CommitId> abstractList = new AbstractList<CommitId>(){

            @Override
            @Nullable
            public CommitId get(int index) {
                return VcsLogImpl.this.getTable().getModel().getCommitIdAtRow(rows[index]);
            }

            @Override
            public int size() {
                return rows.length;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getSelectedCommits"));
        }
        return abstractList;
    }

    private VcsLogGraphTable getTable() {
        return this.myUi.getTable();
    }

    @NotNull
    public List<VcsFullCommitDetails> getSelectedDetails() {
        final int[] rows = this.myUi.getTable().getSelectedRows();
        AbstractList<VcsFullCommitDetails> abstractList = new AbstractList<VcsFullCommitDetails>(){

            @Override
            @NotNull
            public VcsFullCommitDetails get(int index) {
                VcsFullCommitDetails vcsFullCommitDetails = VcsLogImpl.this.getTable().getModel().getFullDetails(rows[index]);
                if (vcsFullCommitDetails == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl$2", "get"));
                }
                return vcsFullCommitDetails;
            }

            @Override
            public int size() {
                return rows.length;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getSelectedDetails"));
        }
        return abstractList;
    }

    public void requestSelectedDetails(@NotNull Consumer<List<VcsFullCommitDetails>> consumer, @Nullable ProgressIndicator indicator) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/impl/VcsLogImpl", "requestSelectedDetails"));
        }
        List rowsList = Ints.asList((int[])this.myUi.getTable().getSelectedRows());
        this.myLogData.getCommitDetailsGetter().loadCommitsData((List)this.getTable().getModel().convertToCommitIds(rowsList), (Consumer)consumer, indicator);
    }

    @Nullable
    public Collection<String> getContainingBranches(@NotNull Hash commitHash, @NotNull VirtualFile root) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "com/intellij/vcs/log/impl/VcsLogImpl", "getContainingBranches"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogImpl", "getContainingBranches"));
        }
        return this.myLogData.getContainingBranchesGetter().getContainingBranchesFromCache(root, commitHash);
    }

    @NotNull
    public Collection<VcsRef> getAllReferences() {
        Collection collection = this.myUi.getDataPack().getRefs().getAllRefs();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getAllReferences"));
        }
        return collection;
    }

    @NotNull
    public Future<Boolean> jumpToReference(String reference) {
        Collection<VcsRef> references = this.getAllReferences();
        List matchingRefs = ContainerUtil.findAll(references, ref -> ref.getName().startsWith(reference));
        if (matchingRefs.isEmpty()) {
            Future<Boolean> future2 = this.myUi.jumpToCommitByPartOfHash(reference);
            if (future2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "jumpToReference"));
            }
            return future2;
        }
        VcsRef ref2 = Collections.min(matchingRefs, new VcsGoToRefComparator(this.myUi.getDataPack().getLogProviders()));
        Future<Boolean> future3 = this.myUi.jumpToCommit(ref2.getCommitHash(), ref2.getRoot());
        if (future3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "jumpToReference"));
        }
        return future3;
    }

    @NotNull
    public Collection<VcsLogProvider> getLogProviders() {
        Collection<VcsLogProvider> collection = this.myLogData.getLogProviders();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getLogProviders"));
        }
        return collection;
    }
}

