/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommitSelectionListener
implements ListSelectionListener {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @Nullable
    private ProgressIndicator myLastRequest;

    protected CommitSelectionListener(@NotNull VcsLogData data, @NotNull VcsLogGraphTable table, @NotNull JBLoadingPanel panel) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/vcs/log/ui/frame/CommitSelectionListener", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/vcs/log/ui/frame/CommitSelectionListener", "<init>"));
        }
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/vcs/log/ui/frame/CommitSelectionListener", "<init>"));
        }
        this.myLogData = data;
        this.myGraphTable = table;
        this.myLoadingPanel = panel;
    }

    @Override
    public void valueChanged(@Nullable ListSelectionEvent event) {
        if (event != null && event.getValueIsAdjusting()) {
            return;
        }
        if (this.myLastRequest != null) {
            this.myLastRequest.cancel();
        }
        this.myLastRequest = null;
        int rows = this.myGraphTable.getSelectedRowCount();
        if (rows < 1) {
            this.myLoadingPanel.stopLoading();
            this.onEmptySelection();
        } else {
            this.onSelection(this.myGraphTable.getSelectedRows());
            this.myLoadingPanel.startLoading();
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            this.myLastRequest = indicator;
            this.myLogData.getCommitDetailsGetter().loadCommitsData((List)this.myGraphTable.getModel().convertToCommitIds(this.getSelectionToLoad()), detailsList -> {
                if (this.myLastRequest == indicator && !indicator.isCanceled()) {
                    this.myLastRequest = null;
                    this.onDetailsLoaded((List<VcsFullCommitDetails>)detailsList);
                    this.myLoadingPanel.stopLoading();
                }
            }, (ProgressIndicator)indicator);
        }
    }

    @NotNull
    protected List<Integer> getSelectionToLoad() {
        List list = Ints.asList((int[])this.myGraphTable.getSelectedRows());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitSelectionListener", "getSelectionToLoad"));
        }
        return list;
    }

    protected abstract void onDetailsLoaded(@NotNull List<VcsFullCommitDetails> var1);

    protected abstract void onSelection(@NotNull int[] var1);

    protected abstract void onEmptySelection();
}

