/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerExpressionEditor
extends XDebuggerEditorBase {
    private final JComponent myComponent;
    private final EditorTextField myEditorTextField;
    private XExpression myExpression;

    public XDebuggerExpressionEditor(Project project2, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition, @NotNull XExpression text, final boolean multiline, boolean editorFont, boolean showEditor) {
        if (debuggerEditorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerEditorsProvider", "com/intellij/xdebugger/impl/ui/XDebuggerExpressionEditor", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/impl/ui/XDebuggerExpressionEditor", "<init>"));
        }
        super(project2, debuggerEditorsProvider, multiline ? EvaluationMode.CODE_FRAGMENT : EvaluationMode.EXPRESSION, historyId, sourcePosition);
        this.myExpression = XExpressionImpl.changeMode(text, this.getMode());
        this.myEditorTextField = new EditorTextField(this.createDocument(this.myExpression), project2, debuggerEditorsProvider.getFileType(), false, !multiline){

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.setVerticalScrollbarVisible(multiline);
                editor.getColorsScheme().setEditorFontName(this.getFont().getFontName());
                editor.getColorsScheme().setEditorFontSize(this.getFont().getSize());
                return editor;
            }

            @Override
            public Object getData(String dataId) {
                if (LangDataKeys.CONTEXT_LANGUAGES.is(dataId)) {
                    return new Language[]{XDebuggerExpressionEditor.this.myExpression.getLanguage()};
                }
                if (CommonDataKeys.PSI_FILE.is(dataId)) {
                    return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(this.getDocument());
                }
                return super.getData(dataId);
            }
        };
        if (editorFont) {
            this.myEditorTextField.setFontInheritedFromLAF(false);
            this.myEditorTextField.setFont(EditorUtil.getEditorFont());
        }
        this.myComponent = this.decorate((JComponent)((Object)this.myEditorTextField), multiline, showEditor);
    }

    @Override
    public JComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.myEditorTextField;
    }

    @Override
    protected void doSetText(XExpression text) {
        this.myExpression = text;
        this.myEditorTextField.setNewDocumentAndFileType(this.getFileType(text), this.createDocument(text));
    }

    @Override
    public XExpression getExpression() {
        return this.getEditorsProvider().createExpression(this.getProject(), this.myEditorTextField.getDocument(), this.myExpression.getLanguage(), this.myExpression.getMode());
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        Editor editor = this.myEditorTextField.getEditor();
        return editor != null ? editor.getContentComponent() : null;
    }

    public void setEnabled(boolean enable) {
        if (enable == this.myComponent.isEnabled()) {
            return;
        }
        UIUtil.setEnabled((Component)this.myComponent, (boolean)enable, (boolean)true);
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myEditorTextField.getEditor();
    }

    @Override
    public void selectAll() {
        this.myEditorTextField.selectAll();
    }
}

