/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.icons.AllIcons;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.JsonSchemaFileTypeManager;
import com.jetbrains.jsonSchema.impl.JsonSchemaResourcesRootsProvider;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaFileType
extends LanguageFileType
implements FileTypeIdentifiableByVirtualFile {
    public static JsonSchemaFileType INSTANCE = new JsonSchemaFileType();

    public JsonSchemaFileType() {
        super((Language)JsonLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        if ("JSON Schema" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/JsonSchemaFileType", "getName"));
        }
        return "JSON Schema";
    }

    @NotNull
    public String getDescription() {
        if ("JSON Schema file" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/JsonSchemaFileType", "getDescription"));
        }
        return "JSON Schema file";
    }

    @NotNull
    public String getDefaultExtension() {
        if ("json" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/JsonSchemaFileType", "getDefaultExtension"));
        }
        return "json";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.FileTypes.Json;
    }

    @Override
    public boolean isMyFileType(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/JsonSchemaFileType", "isMyFileType"));
        }
        if (((Set)JsonSchemaResourcesRootsProvider.ourFiles.getValue()).contains(file2)) {
            return true;
        }
        return JsonSchemaFileTypeManager.getInstance().isJsonSchemaFile(file2);
    }
}

