/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaExportedDefinitions {
    private final Object myLock;
    private boolean myInitialized;
    private boolean myDirty;
    private final BidirectionalMap<String, VirtualFile> myId2Key;
    private final MultiMap<VirtualFile, VirtualFile> myCrossDependencies;
    private final Map<String, Map<String, JsonSchemaObject>> myMap;
    @NotNull
    private final Consumer<PairConsumer<VirtualFile, NullableLazyValue<JsonSchemaObject>>> mySchemasIterator;

    public JsonSchemaExportedDefinitions(@NotNull Consumer<PairConsumer<VirtualFile, NullableLazyValue<JsonSchemaObject>>> schemasIterator) {
        if (schemasIterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemasIterator", "com/jetbrains/jsonSchema/impl/JsonSchemaExportedDefinitions", "<init>"));
        }
        this.mySchemasIterator = schemasIterator;
        this.myLock = new Object();
        this.myMap = new HashMap<String, Map<String, JsonSchemaObject>>();
        this.myId2Key = new BidirectionalMap();
        this.myCrossDependencies = new MultiMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NotNull VirtualFile key2, @NotNull String url, @NotNull Map<String, JsonSchemaObject> map) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/jsonSchema/impl/JsonSchemaExportedDefinitions", "register"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/jsonSchema/impl/JsonSchemaExportedDefinitions", "register"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/jetbrains/jsonSchema/impl/JsonSchemaExportedDefinitions", "register"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myMap.put(url, map);
            this.myId2Key.put((Object)url, (Object)key2);
            if (this.myMap.size() > 10000) {
                JsonSchemaReader.LOG.info("Too many schema definitions registered. Something could go wrong.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSchemaObject findDefinition(@NotNull VirtualFile requestingSchemaKey, @NotNull String url, @NotNull String relativePart) {
        if (requestingSchemaKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestingSchemaKey", "com/jetbrains/jsonSchema/impl/JsonSchemaExportedDefinitions", "findDefinition"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/jsonSchema/impl/JsonSchemaExportedDefinitions", "findDefinition"));
        }
        if (relativePart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePart", "com/jetbrains/jsonSchema/impl/JsonSchemaExportedDefinitions", "findDefinition"));
        }
        Object object = this.myLock;
        synchronized (object) {
            JsonSchemaObject found;
            Map<String, JsonSchemaObject> map;
            this.ensureInitialized();
            VirtualFile key2 = (VirtualFile)this.myId2Key.get((Object)url);
            if (key2 != null) {
                this.myCrossDependencies.putValue((Object)key2, (Object)requestingSchemaKey);
            }
            if ((map = this.myMap.get(url)) != null && (found = map.get(relativePart)) != null) {
                return found;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myInitialized && !this.myDirty) {
                return;
            }
            this.mySchemasIterator.consume((key2, value) -> {
                JsonSchemaObject object;
                if (!(this.myInitialized && this.myId2Key.containsValue(key2) || (object = (JsonSchemaObject)value.getValue()) == null)) {
                    JsonSchemaReader.registerObjectsExportedDefinitions(key2, this, object);
                }
            });
            this.myDirty = false;
            this.myInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.myLock;
        synchronized (object) {
            this.myInitialized = false;
            this.myDirty = false;
            this.myMap.clear();
            this.myCrossDependencies.clear();
            this.myId2Key.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<VirtualFile> dropKey(@NotNull VirtualFile key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/jsonSchema/impl/JsonSchemaExportedDefinitions", "dropKey"));
        }
        HashSet<VirtualFile> dirtyKeys = new HashSet<VirtualFile>();
        Object object = this.myLock;
        synchronized (object) {
            this.myDirty = true;
            ArrayDeque<VirtualFile> queue = new ArrayDeque<VirtualFile>();
            queue.add(key2);
            while (!queue.isEmpty()) {
                VirtualFile current = (VirtualFile)queue.remove();
                dirtyKeys.add(current);
                List keys = this.myId2Key.getKeysByValue((Object)current);
                this.myId2Key.removeValue((Object)current);
                if (keys == null || keys.isEmpty()) continue;
                assert (keys.size() == 1);
                this.myMap.remove(keys.get(0));
                Collection dependencies = this.myCrossDependencies.remove((Object)current);
                if (dependencies == null) continue;
                queue.addAll(dependencies);
            }
        }
        return dirtyKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkFileForId(@NotNull String id, @NotNull VirtualFile file2) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/jsonSchema/impl/JsonSchemaExportedDefinitions", "checkFileForId"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaExportedDefinitions", "checkFileForId"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.ensureInitialized();
            return file2.equals(this.myId2Key.get((Object)id));
        }
    }
}

