/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.CodeInsightProviders;
import com.jetbrains.jsonSchema.impl.JsonBySchemaDocumentationProvider;
import com.jetbrains.jsonSchema.impl.JsonBySchemaObjectAnnotator;
import com.jetbrains.jsonSchema.impl.JsonBySchemaObjectCompletionContributor;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import org.jetbrains.annotations.NotNull;

class JsonSchemaObjectCodeInsightWrapper
implements CodeInsightProviders {
    @NotNull
    private final String myName;
    @NotNull
    private final SchemaType mySchemaType;
    @NotNull
    private final JsonSchemaObject mySchemaObject;
    @NotNull
    private final CompletionContributor myContributor;
    @NotNull
    private final Annotator myAnnotator;
    @NotNull
    private final DocumentationProvider myDocumentationProvider;

    public JsonSchemaObjectCodeInsightWrapper(@NotNull Project project2, @NotNull String name, @NotNull SchemaType type, @NotNull VirtualFile schemaFile, @NotNull JsonSchemaObject schemaObject) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/impl/JsonSchemaObjectCodeInsightWrapper", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/impl/JsonSchemaObjectCodeInsightWrapper", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/jsonSchema/impl/JsonSchemaObjectCodeInsightWrapper", "<init>"));
        }
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaObjectCodeInsightWrapper", "<init>"));
        }
        if (schemaObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaObject", "com/jetbrains/jsonSchema/impl/JsonSchemaObjectCodeInsightWrapper", "<init>"));
        }
        this.myName = name;
        this.mySchemaType = type;
        this.mySchemaObject = schemaObject;
        this.myContributor = new JsonBySchemaObjectCompletionContributor(type, schemaObject);
        this.myAnnotator = new JsonBySchemaObjectAnnotator(schemaObject);
        this.myDocumentationProvider = new JsonBySchemaDocumentationProvider(schemaObject);
    }

    @Override
    @NotNull
    public CompletionContributor getContributor() {
        CompletionContributor completionContributor = this.myContributor;
        if (completionContributor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaObjectCodeInsightWrapper", "getContributor"));
        }
        return completionContributor;
    }

    @Override
    @NotNull
    public Annotator getAnnotator() {
        Annotator annotator2 = this.myAnnotator;
        if (annotator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaObjectCodeInsightWrapper", "getAnnotator"));
        }
        return annotator2;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaObjectCodeInsightWrapper", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public DocumentationProvider getDocumentationProvider() {
        DocumentationProvider documentationProvider = this.myDocumentationProvider;
        if (documentationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaObjectCodeInsightWrapper", "getDocumentationProvider"));
        }
        return documentationProvider;
    }

    @Override
    public boolean iterateSchemaObjects(@NotNull Processor<JsonSchemaObject> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaObjectCodeInsightWrapper", "iterateSchemaObjects"));
        }
        return consumer.process((Object)this.mySchemaObject);
    }

    public boolean isUserSchema() {
        return SchemaType.userSchema.equals((Object)this.mySchemaType);
    }
}

