/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import org.jetbrains.annotations.NotNull;

public class AssertEqualsMayBeAssertSameInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assertequals.may.be.assertsame.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/AssertEqualsMayBeAssertSameInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assertequals.may.be.assertsame.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/AssertEqualsMayBeAssertSameInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AssertEqualsMayBeAssertSameFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertEqualsMayBeAssertSameVisitor();
    }

    private static class AssertEqualsMayBeAssertSameVisitor
    extends BaseInspectionVisitor {
        private AssertEqualsMayBeAssertSameVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"assertEquals".equals(name)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 3 && arguments.length != 2) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (!"org.junit.Assert".equals(qualifiedName) && !"junit.framework.Assert".equals(qualifiedName)) {
                return;
            }
            PsiExpression argument1 = arguments[arguments.length - 2];
            if (!AssertEqualsMayBeAssertSameVisitor.couldBeAssertSameArgument(argument1)) {
                return;
            }
            PsiExpression argument2 = arguments[arguments.length - 1];
            if (!AssertEqualsMayBeAssertSameVisitor.couldBeAssertSameArgument(argument2)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean couldBeAssertSameArgument(PsiExpression expression) {
            PsiType type = expression.getType();
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass argumentClass = classType.resolve();
            if (argumentClass == null) {
                return false;
            }
            if (!argumentClass.hasModifierProperty("final")) {
                return false;
            }
            PsiMethod[] methods = argumentClass.findMethodsByName("equals", true);
            PsiManager manager = expression.getManager();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiClass objectClass = psiFacade.findClass("java.lang.Object", argumentClass.getResolveScope());
            if (objectClass == null) {
                return false;
            }
            for (PsiMethod method : methods) {
                PsiClass containingClass = method.getContainingClass();
                if (objectClass.equals(containingClass)) continue;
                return false;
            }
            return true;
        }
    }

    private static class AssertEqualsMayBeAssertSameFix
    extends InspectionGadgetsFix {
        private AssertEqualsMayBeAssertSameFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("assertequals.may.be.assertsame.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/AssertEqualsMayBeAssertSameInspection$AssertEqualsMayBeAssertSameFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/AssertEqualsMayBeAssertSameInspection$AssertEqualsMayBeAssertSameFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)parent;
            PsiElement grandParent = methodExpression.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if (className == null) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null && ImportUtils.addStaticImport(className, "assertSame", (PsiElement)methodExpression)) {
                PsiReplacementUtil.replaceExpression((PsiExpression)methodExpression, "assertSame");
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)methodExpression, className + ".assertSame");
            }
        }
    }
}

