/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Vm;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u0014J\u000e\u0010*\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020+J\u0018\u0010,\u001a\u00020\u000f2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u000200J\f\u00101\u001a\u0006\u0012\u0002\b\u000302H\u0016J\b\u00103\u001a\u00020\u000fH\u0016J\u000e\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u000206J\f\u0010\u0019\u001a\u0006\u0012\u0002\b\u000302H\u0007J(\u00107\u001a\u00020\u000f2\u0006\u0010/\u001a\u0002002\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.2\n\b\u0002\u00108\u001a\u0004\u0018\u000109H\u0004J\b\u0010:\u001a\u00020\u000fH\u0014J\u001a\u0010;\u001a\u00020\u000f2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rj\u0010\u000b\u001a^\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f \u0010*\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r0\r \u0010*-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f \u0010*\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r0\r0\u0012\u00a2\u0006\u0002\b\u00110\f\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R2\u0010\u0017\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00140\u0014 \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000e0\u000e0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\"\u001a\u0004\u0018\u00018\u00002\b\u0010!\u001a\u0004\u0018\u00018\u00008\u0006@DX\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010'\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006<"}, d2={"Lorg/jetbrains/debugger/connection/VmConnection;", "T", "Lorg/jetbrains/debugger/Vm;", "Lcom/intellij/openapi/Disposable;", "()V", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "connectionDispatcher", "", "Lkotlin/Function1;", "Lcom/intellij/util/io/socketConnection/ConnectionState;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "debugEventListener", "Lorg/jetbrains/debugger/DebugEventListener;", "getDebugEventListener", "()Lorg/jetbrains/debugger/DebugEventListener;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "opened", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "state", "getState", "()Lcom/intellij/util/io/socketConnection/ConnectionState;", "stateRef", "Ljava/util/concurrent/atomic/AtomicReference;", "<set-?>", "vm", "getVm", "()Lorg/jetbrains/debugger/Vm;", "setVm", "(Lorg/jetbrains/debugger/Vm;)V", "Lorg/jetbrains/debugger/Vm;", "addDebugListener", "listener", "addListener", "Lcom/intellij/util/io/socketConnection/SocketConnectionListener;", "close", "message", "", "status", "Lcom/intellij/util/io/socketConnection/ConnectionStatus;", "detachAndClose", "Lorg/jetbrains/concurrency/Promise;", "dispose", "executeOnStart", "runnable", "Ljava/lang/Runnable;", "setState", "messageLinkListener", "Ljavax/swing/event/HyperlinkListener;", "startProcessing", "stateChanged", "script-debugger-ui"})
public abstract class VmConnection<T extends Vm>
implements Disposable {
    @Nullable
    private final WebBrowser browser;
    private final AtomicReference<ConnectionState> stateRef = new AtomicReference<ConnectionState>(new ConnectionState(ConnectionStatus.NOT_CONNECTED));
    private final EventDispatcher<DebugEventListener> dispatcher = EventDispatcher.create(DebugEventListener.class);
    private final List<Function1<ConnectionState, Unit>> connectionDispatcher = ContainerUtil.createLockFreeCopyOnWriteList();
    @Nullable
    private volatile T vm;
    private final AsyncPromise<Object> opened = new AsyncPromise();
    private final AtomicBoolean closed = new AtomicBoolean();

    @Nullable
    public WebBrowser getBrowser() {
        return this.browser;
    }

    @Nullable
    public final T getVm() {
        return this.vm;
    }

    protected final void setVm(@Nullable T t) {
        this.vm = t;
    }

    @NotNull
    public final ConnectionState getState() {
        ConnectionState connectionState = this.stateRef.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)connectionState, (String)"stateRef.get()");
        return connectionState;
    }

    public final void addDebugListener(@NotNull DebugEventListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.dispatcher.addListener((EventListener)listener2);
    }

    @NotNull
    public final Promise<?> opened() {
        return (Promise)this.opened;
    }

    public final void executeOnStart(@NotNull Runnable runnable2) {
        Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
        this.opened.done((Consumer)new Consumer<Object>(runnable2){
            final /* synthetic */ Runnable $runnable;

            public final void consume(@Nullable Object it) {
                this.$runnable.run();
            }
            {
                this.$runnable = runnable2;
            }
        });
    }

    protected final void setState(@NotNull ConnectionStatus status2, @Nullable String message, @Nullable HyperlinkListener messageLinkListener) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status2), (String)"status");
        ConnectionState newState = new ConnectionState(status2, message, messageLinkListener);
        ConnectionState oldState = this.stateRef.getAndSet(newState);
        if (oldState == null || Intrinsics.areEqual((Object)((Object)oldState.getStatus()), (Object)((Object)status2)) ^ true) {
            if (Intrinsics.areEqual((Object)((Object)status2), (Object)((Object)ConnectionStatus.CONNECTION_FAILED))) {
                this.opened.setError(newState.getMessage());
            }
            for (Function1<ConnectionState, Unit> listener2 : this.connectionDispatcher) {
                listener2.invoke((Object)newState);
            }
        }
    }

    protected static /* bridge */ /* synthetic */ void setState$default(VmConnection vmConnection, ConnectionStatus connectionStatus, String string, HyperlinkListener hyperlinkListener, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setState");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            hyperlinkListener = null;
        }
        vmConnection.setState(connectionStatus, string, hyperlinkListener);
    }

    public final void stateChanged(@NotNull Function1<? super ConnectionState, Unit> listener2) {
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        this.connectionDispatcher.add(listener2);
    }

    public final void addListener(@NotNull SocketConnectionListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.stateChanged((Function1<ConnectionState, Unit>)((Function1)new Function1<ConnectionState, Unit>(listener2){
            final /* synthetic */ SocketConnectionListener $listener;

            public final void invoke(@NotNull ConnectionState it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$listener.statusChanged(it.getStatus());
            }
            {
                this.$listener = socketConnectionListener;
                super(1);
            }
        }));
    }

    @NotNull
    protected final DebugEventListener getDebugEventListener() {
        DebugEventListener debugEventListener = (DebugEventListener)this.dispatcher.getMulticaster();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugEventListener, (String)"dispatcher.multicaster");
        return debugEventListener;
    }

    protected void startProcessing() {
        this.opened.setResult(null);
    }

    public final void close(@Nullable String message, @NotNull ConnectionStatus status2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status2), (String)"status");
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (PromiseKt.isPending((Promise)this.opened)) {
            this.opened.setError("closed");
        }
        VmConnection.setState$default(this, status2, message, null, 4, null);
        Disposer.dispose((Disposable)this, (boolean)false);
    }

    public void dispose() {
        this.vm = null;
    }

    @NotNull
    public Promise<?> detachAndClose() {
        Promise<?> callback;
        T currentVm;
        if (PromiseKt.isPending((Promise)this.opened)) {
            this.opened.setError((Throwable)PromiseKt.createError("detached and closed", false));
        }
        if ((currentVm = this.vm) == null) {
            callback = PromiseKt.resolvedPromise();
        } else {
            this.vm = null;
            callback = currentVm.getAttachStateManager().detach();
        }
        this.close(null, ConnectionStatus.DISCONNECTED);
        return callback;
    }
}

