/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
public class PrimitiveDoubleArraySubject
extends AbstractArraySubject<PrimitiveDoubleArraySubject, double[]> {
    PrimitiveDoubleArraySubject(FailureStrategy failureStrategy, @Nullable double[] o) {
        super(failureStrategy, o);
    }

    @Override
    protected String underlyingType() {
        return "double";
    }

    @Override
    protected List<Double> listRepresentation() {
        return Doubles.asList((double[])((double[])this.getSubject()));
    }

    @Override
    @Deprecated
    public void isEqualTo(Object expected) {
        throw new UnsupportedOperationException("Comparing raw equality of doubles is unsafe, use isEqualTo(double[] array, double tolerance) instead.");
    }

    @Deprecated
    public void isEqualTo(Object expected, double tolerance) {
        double[] actual = (double[])this.getSubject();
        if (actual == expected) {
            return;
        }
        try {
            double[] expectedArray = (double[])expected;
            if (expectedArray.length != actual.length) {
                this.failWithRawMessage("Arrays are of different lengths. expected: %s, actual %s", Doubles.asList((double[])expectedArray), Doubles.asList((double[])actual));
            }
            ArrayList<Integer> unequalIndices = new ArrayList<Integer>();
            for (int i = 0; i < expectedArray.length; ++i) {
                if (MathUtil.equals(actual[i], expectedArray[i], tolerance)) continue;
                unequalIndices.add(i);
            }
            if (!unequalIndices.isEmpty()) {
                this.fail("is equal to", (Object)Doubles.asList((double[])expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    @Deprecated
    public void isNotEqualTo(Object expected) {
        throw new UnsupportedOperationException("Comparing raw equality of doubles is unsafe, use isNotEqualTo(double[] array, double tolerance) instead.");
    }

    @Deprecated
    public void isNotEqualTo(Object expectedArray, double tolerance) {
        double[] actual = (double[])this.getSubject();
        try {
            double[] expected = (double[])expectedArray;
            if (actual == expected) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.getDisplaySubject(), Doubles.asList((double[])expected));
            }
            if (expected.length != actual.length) {
                return;
            }
            ArrayList<Integer> unequalIndices = new ArrayList<Integer>();
            for (int i = 0; i < expected.length; ++i) {
                if (MathUtil.equals(actual[i], expected[i], tolerance)) continue;
                unequalIndices.add(i);
            }
            if (unequalIndices.isEmpty()) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.getDisplaySubject(), Doubles.asList((double[])expected));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public TolerantPrimitiveDoubleArrayComparison hasValuesWithin(final double tolerance) {
        return new TolerantPrimitiveDoubleArrayComparison(){

            @Override
            public void of(double[] expected) {
                DoubleSubject.checkTolerance(tolerance);
                double[] actual = (double[])Preconditions.checkNotNull(PrimitiveDoubleArraySubject.this.getSubject());
                if (actual.length != expected.length) {
                    PrimitiveDoubleArraySubject.this.failWithRawMessage("Not true that %s has values within %s of <%s>. Expected length <%s> but got <%s>", PrimitiveDoubleArraySubject.this.getDisplaySubject(), tolerance, Doubles.asList((double[])expected), expected.length, actual.length);
                }
                ArrayList<Integer> mismatches = new ArrayList<Integer>();
                for (int i = 0; i < expected.length; ++i) {
                    if (MathUtil.equals(actual[i], expected[i], tolerance)) continue;
                    mismatches.add(i);
                }
                if (!mismatches.isEmpty()) {
                    double d = tolerance;
                    PrimitiveDoubleArraySubject.this.failWithBadResults(new StringBuilder(45).append("has values within ").append(d).append(" of").toString(), Doubles.asList((double[])expected), "differs at indexes", mismatches);
                }
            }
        };
    }

    public TolerantPrimitiveDoubleArrayComparison hasValuesNotWithin(final double tolerance) {
        return new TolerantPrimitiveDoubleArrayComparison(){

            @Override
            public void of(double[] expected) {
                DoubleSubject.checkTolerance(tolerance);
                double[] actual = (double[])Preconditions.checkNotNull(PrimitiveDoubleArraySubject.this.getSubject());
                if (expected.length != actual.length) {
                    return;
                }
                boolean pass = false;
                for (int i = 0; i < expected.length; ++i) {
                    if (!MathUtil.notEquals(actual[i], expected[i], tolerance)) continue;
                    pass = true;
                    break;
                }
                if (!pass) {
                    double d = tolerance;
                    PrimitiveDoubleArraySubject.this.fail(new StringBuilder(49).append("has values not within ").append(d).append(" of").toString(), (Object)Doubles.asList((double[])expected));
                }
            }
        };
    }

    private IterableSubject<?, Double, List<Double>> asList() {
        return IterableSubject.create(this.failureStrategy, this.listRepresentation());
    }

    public abstract class TolerantPrimitiveDoubleArrayComparison {
        private TolerantPrimitiveDoubleArrayComparison() {
        }

        public abstract void of(double[] var1);

        @Deprecated
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException("If you meant to compare doubles, use .of(double[]) instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

