/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GotoResourceBundleLocalizationsProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/properties/editor/GotoResourceBundleLocalizationsProvider", "getItems"));
        }
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context);
        if (editor instanceof ResourceBundleEditor) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/GotoResourceBundleLocalizationsProvider", "getItems"));
            }
            return list;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (psiFile == null || !(psiFile instanceof PropertiesFile)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/GotoResourceBundleLocalizationsProvider", "getItems"));
            }
            return list;
        }
        ResourceBundle resourceBundle = ((PropertiesFile)psiFile).getResourceBundle();
        List<PropertiesFile> bundlePropertiesFiles = resourceBundle.getPropertiesFiles();
        assert (bundlePropertiesFiles.size() != 0);
        if (bundlePropertiesFiles.size() != 1) {
            ArrayList propertiesFilesWithoutCurrent = ContainerUtil.newArrayList(bundlePropertiesFiles);
            propertiesFilesWithoutCurrent.remove(psiFile);
            List list = ContainerUtil.map((Collection)propertiesFilesWithoutCurrent, propertiesFile -> new GotoRelatedItem((PsiElement)propertiesFile, "Other Localizations"));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/GotoResourceBundleLocalizationsProvider", "getItems"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/GotoResourceBundleLocalizationsProvider", "getItems"));
        }
        return list;
    }
}

