/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.testDiscovery;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testDiscovery.TestDiscoveryConfiguration;
import com.intellij.execution.testDiscovery.TestDiscoverySearchHelper;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.FunctionUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitTestDiscoveryConfiguration
extends TestDiscoveryConfiguration {
    public JUnitTestDiscoveryConfiguration(String name, Project project, ConfigurationFactory factory) {
        super(name, new JavaRunConfigurationModule(project, false), factory, (JavaTestConfigurationBase)new JUnitConfiguration("", project, JUnitConfigurationType.getInstance().getConfigurationFactories()[0]));
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/junit/testDiscovery/JUnitTestDiscoveryConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/junit/testDiscovery/JUnitTestDiscoveryConfiguration", "getState"));
        }
        return new JUnitTestDiscoveryRunnableState(environment);
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return null;
    }

    @NotNull
    public String getFrameworkPrefix() {
        if ("j" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/testDiscovery/JUnitTestDiscoveryConfiguration", "getFrameworkPrefix"));
        }
        return "j";
    }

    private class JUnitTestDiscoveryRunnableState
    extends TestObject {
        public JUnitTestDiscoveryRunnableState(ExecutionEnvironment environment) {
            super((JUnitConfiguration)JUnitTestDiscoveryConfiguration.this.myDelegate, environment);
        }

        @Override
        protected TestSearchScope getScope() {
            return ((JavaRunConfigurationModule)JUnitTestDiscoveryConfiguration.this.getConfigurationModule()).getModule() != null ? TestSearchScope.MODULE_WITH_DEPENDENCIES : TestSearchScope.WHOLE_PROJECT;
        }

        protected boolean forkPerModule() {
            return this.spansMultipleModules("");
        }

        @Override
        protected PsiElement retrievePsiElement(Object pattern) {
            String className;
            if (pattern instanceof String && !pattern.equals(className = StringUtil.getPackageName((String)((String)pattern), (char)','))) {
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)JUnitTestDiscoveryConfiguration.this.getProject());
                SourceScope sourceScope = this.getSourceScope();
                GlobalSearchScope globalSearchScope = sourceScope != null ? sourceScope.getGlobalSearchScope() : GlobalSearchScope.projectScope((Project)JUnitTestDiscoveryConfiguration.this.getProject());
                return facade.findClass(className, globalSearchScope);
            }
            return null;
        }

        public SearchForTestsTask createSearchingForTestsTask() {
            return new SearchForTestsTask(JUnitTestDiscoveryConfiguration.this.getProject(), this.myServerSocket){
                private Set<String> myPatterns;

                protected void search() throws ExecutionException {
                    this.myPatterns = TestDiscoverySearchHelper.search((Project)this.getProject(), (Pair)JUnitTestDiscoveryConfiguration.this.getPosition(), (String)JUnitTestDiscoveryConfiguration.this.getChangeList(), (String)JUnitTestDiscoveryConfiguration.this.getFrameworkPrefix());
                }

                protected void onFound() {
                    if (this.myPatterns != null) {
                        try {
                            JUnitTestDiscoveryRunnableState.this.addClassesListToJavaParameters(this.myPatterns, FunctionUtil.id(), "", false, JUnitTestDiscoveryRunnableState.this.getJavaParameters());
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                    }
                }
            };
        }

        @Override
        protected JavaParameters createJavaParameters() throws ExecutionException {
            JavaParameters javaParameters = super.createJavaParameters();
            this.createTempFiles(javaParameters);
            this.createServerSocket(javaParameters);
            return javaParameters;
        }

        @Override
        public String suggestActionName() {
            return "";
        }

        @Override
        public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
            return null;
        }

        @Override
        public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
            return false;
        }
    }
}

