/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.actions;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.junit2.ui.model.CompletionEvent;
import com.intellij.execution.junit2.ui.model.JUnitAdapter;
import com.intellij.execution.junit2.ui.model.StateEvent;
import com.intellij.execution.testframework.LvcsHelper;
import com.intellij.execution.testframework.TestFrameworkRunningModel;

public class LvcsLabeler
extends JUnitAdapter {
    private final TestFrameworkRunningModel myModel;

    public LvcsLabeler(TestFrameworkRunningModel model) {
        this.myModel = model;
    }

    @Override
    public void onRunnerStateChanged(StateEvent event) {
        if (!(event instanceof CompletionEvent)) {
            return;
        }
        boolean areTestsFailed = this.myModel.getRoot().isDefect();
        CompletionEvent completion = (CompletionEvent)event;
        RunProfile configuration = this.myModel.getProperties().getConfiguration();
        if (configuration == null) {
            return;
        }
        if (LvcsLabeler.testsTerminatedAndNotFailed(completion, areTestsFailed)) {
            return;
        }
        if (completion.isNormalExit()) {
            LvcsHelper.addLabel((TestFrameworkRunningModel)this.myModel);
        }
    }

    private static boolean testsTerminatedAndNotFailed(CompletionEvent completion, boolean areTestsPassed) {
        return !completion.isNormalExit() && areTestsPassed;
    }
}

