/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.project.MavenEnvironmentForm;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.ComboBoxUtil;

public class MavenGeneralPanel
implements PanelWithAnchor {
    private JCheckBox checkboxWorkOffline;
    private JPanel panel;
    private JComboBox outputLevelCombo;
    private JCheckBox checkboxProduceExceptionErrorMessages;
    private JComboBox checksumPolicyCombo;
    private JComboBox failPolicyCombo;
    private JComboBox pluginUpdatePolicyCombo;
    private JCheckBox checkboxUsePluginRegistry;
    private JCheckBox checkboxRecursive;
    private MavenEnvironmentForm mavenPathsForm;
    private JBLabel myMultiprojectBuildFailPolicyLabel;
    private JCheckBox alwaysUpdateSnapshotsCheckBox;
    private JTextField threadsEditor;
    private final DefaultComboBoxModel outputLevelComboModel;
    private final DefaultComboBoxModel checksumPolicyComboModel;
    private final DefaultComboBoxModel failPolicyComboModel;
    private final DefaultComboBoxModel pluginUpdatePolicyComboModel;
    private JComponent anchor;

    public MavenGeneralPanel() {
        this.$$$setupUI$$$();
        this.outputLevelComboModel = new DefaultComboBoxModel();
        this.checksumPolicyComboModel = new DefaultComboBoxModel();
        this.failPolicyComboModel = new DefaultComboBoxModel();
        this.pluginUpdatePolicyComboModel = new DefaultComboBoxModel();
        this.fillOutputLevelCombobox();
        this.fillChecksumPolicyCombobox();
        this.fillFailureBehaviorCombobox();
        this.fillPluginUpdatePolicyCombobox();
        this.setAnchor((JComponent)this.myMultiprojectBuildFailPolicyLabel);
    }

    private void fillOutputLevelCombobox() {
        ComboBoxUtil.setModel(this.outputLevelCombo, this.outputLevelComboModel, Arrays.asList(MavenExecutionOptions.LoggingLevel.values()), new Function<MavenExecutionOptions.LoggingLevel, Pair<String, ?>>(){

            public Pair<String, MavenExecutionOptions.LoggingLevel> fun(MavenExecutionOptions.LoggingLevel each) {
                return Pair.create((Object)each.getDisplayString(), (Object)((Object)each));
            }
        });
    }

    private void fillFailureBehaviorCombobox() {
        ComboBoxUtil.setModel(this.failPolicyCombo, this.failPolicyComboModel, Arrays.asList(MavenExecutionOptions.FailureMode.values()), new Function<MavenExecutionOptions.FailureMode, Pair<String, ?>>(){

            public Pair<String, MavenExecutionOptions.FailureMode> fun(MavenExecutionOptions.FailureMode each) {
                return Pair.create((Object)each.getDisplayString(), (Object)((Object)each));
            }
        });
    }

    private void fillChecksumPolicyCombobox() {
        ComboBoxUtil.setModel(this.checksumPolicyCombo, this.checksumPolicyComboModel, Arrays.asList(MavenExecutionOptions.ChecksumPolicy.values()), new Function<MavenExecutionOptions.ChecksumPolicy, Pair<String, ?>>(){

            public Pair<String, MavenExecutionOptions.ChecksumPolicy> fun(MavenExecutionOptions.ChecksumPolicy each) {
                return Pair.create((Object)each.getDisplayString(), (Object)((Object)each));
            }
        });
    }

    private void fillPluginUpdatePolicyCombobox() {
        ComboBoxUtil.setModel(this.pluginUpdatePolicyCombo, this.pluginUpdatePolicyComboModel, Arrays.asList(MavenExecutionOptions.PluginUpdatePolicy.values()), new Function<MavenExecutionOptions.PluginUpdatePolicy, Pair<String, ?>>(){

            public Pair<String, MavenExecutionOptions.PluginUpdatePolicy> fun(MavenExecutionOptions.PluginUpdatePolicy each) {
                return Pair.create((Object)each.getDisplayString(), (Object)((Object)each));
            }
        });
    }

    public JComponent createComponent() {
        this.mavenPathsForm.createComponent();
        return this.panel;
    }

    public void disposeUIResources() {
    }

    protected void setData(MavenGeneralSettings data) {
        data.beginUpdate();
        data.setWorkOffline(this.checkboxWorkOffline.isSelected());
        this.mavenPathsForm.setData(data);
        data.setPrintErrorStackTraces(this.checkboxProduceExceptionErrorMessages.isSelected());
        data.setUsePluginRegistry(this.checkboxUsePluginRegistry.isSelected());
        data.setNonRecursive(!this.checkboxRecursive.isSelected());
        data.setOutputLevel((MavenExecutionOptions.LoggingLevel)((Object)ComboBoxUtil.getSelectedValue(this.outputLevelComboModel)));
        data.setChecksumPolicy((MavenExecutionOptions.ChecksumPolicy)((Object)ComboBoxUtil.getSelectedValue(this.checksumPolicyComboModel)));
        data.setFailureBehavior((MavenExecutionOptions.FailureMode)((Object)ComboBoxUtil.getSelectedValue(this.failPolicyComboModel)));
        data.setPluginUpdatePolicy((MavenExecutionOptions.PluginUpdatePolicy)((Object)ComboBoxUtil.getSelectedValue(this.pluginUpdatePolicyComboModel)));
        data.setAlwaysUpdateSnapshots(this.alwaysUpdateSnapshotsCheckBox.isSelected());
        data.setThreads(this.threadsEditor.getText());
        data.endUpdate();
    }

    protected void getData(MavenGeneralSettings data) {
        this.checkboxWorkOffline.setSelected(data.isWorkOffline());
        this.mavenPathsForm.getData(data);
        this.checkboxProduceExceptionErrorMessages.setSelected(data.isPrintErrorStackTraces());
        this.checkboxUsePluginRegistry.setSelected(data.isUsePluginRegistry());
        this.checkboxRecursive.setSelected(!data.isNonRecursive());
        this.alwaysUpdateSnapshotsCheckBox.setSelected(data.isAlwaysUpdateSnapshots());
        this.threadsEditor.setText(StringUtil.notNullize((String)data.getThreads()));
        ComboBoxUtil.select(this.outputLevelComboModel, (Object)data.getOutputLevel());
        ComboBoxUtil.select(this.checksumPolicyComboModel, (Object)data.getChecksumPolicy());
        ComboBoxUtil.select(this.failPolicyComboModel, (Object)data.getFailureBehavior());
        ComboBoxUtil.select(this.pluginUpdatePolicyComboModel, (Object)data.getPluginUpdatePolicy());
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message("maven.tab.general", new Object[0]);
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myMultiprojectBuildFailPolicyLabel.setAnchor(anchor);
        this.mavenPathsForm.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        MavenEnvironmentForm mavenEnvironmentForm;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JBLabel jBLabel;
        JComboBox jComboBox3;
        JComboBox jComboBox4;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(12, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Output level:");
        jLabel.setDisplayedMnemonic('L');
        jLabel.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(66, 23), null));
        this.outputLevelCombo = jComboBox4 = new JComboBox();
        jPanel.add(jComboBox4, new GridConstraints(5, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Checksum policy:");
        jLabel2.setDisplayedMnemonic('C');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.checksumPolicyCombo = jComboBox3 = new JComboBox();
        jPanel.add(jComboBox3, new GridConstraints(6, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myMultiprojectBuildFailPolicyLabel = jBLabel = new JBLabel();
        jBLabel.setText("Multiproject build fail policy:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(19);
        jPanel.add((Component)jBLabel, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.failPolicyCombo = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(7, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Plugin update policy:");
        jLabel3.setDisplayedMnemonic('P');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.pluginUpdatePolicyCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(8, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.checkboxWorkOffline = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Work offline");
        jCheckBox5.setMnemonic('O');
        jCheckBox5.setDisplayedMnemonicIndex(5);
        jCheckBox5.setToolTipText("<html>Add option <b>--offline</b> to command line when run maven goals</html>");
        jCheckBox5.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.checkboxUsePluginRegistry = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Use plugin registry");
        jCheckBox4.setMnemonic('R');
        jCheckBox4.setDisplayedMnemonicIndex(11);
        jCheckBox4.setToolTipText("<html>Add option <b>--no-plugin-registry</b> if this option is not selected</html>");
        jCheckBox4.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.checkboxRecursive = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Execute goals recursively ");
        jCheckBox3.setMnemonic('G');
        jCheckBox3.setDisplayedMnemonicIndex(8);
        jCheckBox3.setToolTipText("<html>Add option <b>--non-recursive</b> if this option is not selected</html>");
        jCheckBox3.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, new Dimension(185, 22), null));
        this.checkboxProduceExceptionErrorMessages = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Print exception stack traces");
        jCheckBox2.setMnemonic('E');
        jCheckBox2.setDisplayedMnemonicIndex(6);
        jCheckBox2.setToolTipText("<html>Add option <b>--errors</b> to command line when run maven goals</html>");
        jCheckBox2.setAlignmentY(0.5f);
        jCheckBox2.setMargin(new Insets(2, 0, 2, 0));
        jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.mavenPathsForm = mavenEnvironmentForm = new MavenEnvironmentForm();
        JComponent jComponent = mavenEnvironmentForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(10, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(11, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setText("ignored by Maven 3+");
        jPanel.add((Component)jBLabel2, new GridConstraints(8, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.alwaysUpdateSnapshotsCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Always update snapshots");
        jCheckBox.setMnemonic('S');
        jCheckBox.setDisplayedMnemonicIndex(14);
        jCheckBox.setToolTipText("Forces a check for updated releases and snapshots on remote repositories");
        jCheckBox.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setHorizontalTextPosition(11);
        jBLabel3.setToolTipText("Thread count, for instance 2.0C where C is core multiplied (option -T)");
        jBLabel3.setHorizontalAlignment(10);
        jBLabel3.setText("<html>Threads <small><i>(-T option):<i></small></html>");
        jPanel.add((Component)jBLabel3, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.threadsEditor = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(9, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jComboBox4);
        jLabel2.setLabelFor(jComboBox3);
        jBLabel.setLabelFor(jComboBox2);
        jLabel3.setLabelFor(jComboBox);
        jBLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

