/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.AbstractLineChoppingStyledTextOutput;

public class LinePrefixingStyledTextOutput
extends AbstractLineChoppingStyledTextOutput {
    private final StyledTextOutput output;
    private final CharSequence prefix;
    private boolean prefixFirstLine;
    private boolean prefixed;

    public LinePrefixingStyledTextOutput(StyledTextOutput output, CharSequence prefix) {
        this(output, prefix, true);
    }

    public LinePrefixingStyledTextOutput(StyledTextOutput output, CharSequence prefix, boolean prefixFirstLine) {
        this.output = output;
        this.prefix = prefix;
        this.prefixFirstLine = prefixFirstLine;
    }

    protected void doLineText(CharSequence text) {
        if (!this.prefixed && this.prefixFirstLine) {
            this.output.text(this.prefix);
            this.prefixed = true;
        }
        this.output.text(text);
    }

    protected void doEndLine(CharSequence endOfLine) {
        this.output.text(endOfLine);
    }

    protected void doStartLine() {
        this.output.text(this.prefix);
    }

    protected void doStyleChange(StyledTextOutput.Style style) {
        this.output.style(style);
    }
}

