/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomAnt;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomFileReference;
import com.intellij.lang.ant.dom.AntDomIncludingDirective;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomReference;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntDomFileReferenceSet
extends FileReferenceSet {
    private final GenericAttributeValue myValue;

    public AntDomFileReferenceSet(GenericAttributeValue attribValue, boolean validateFileRefs) {
        this(attribValue, attribValue.getRawText(), 0, validateFileRefs);
    }

    public AntDomFileReferenceSet(GenericAttributeValue attribValue, String pathSubstring, int beginOffset, boolean validateFileRefs) {
        super(AntDomFileReferenceSet.cutTrailingSlash(FileUtil.toSystemIndependentName((String)pathSubstring)), (PsiElement)attribValue.getXmlAttributeValue(), ElementManipulators.getOffsetInElement((PsiElement)attribValue.getXmlAttributeValue()) + beginOffset, null, SystemInfo.isFileSystemCaseSensitive);
        this.myValue = attribValue;
        for (FileReference reference : this.getAllReferences()) {
            if (!(reference instanceof AntDomReference)) continue;
            ((AntDomReference)reference).setShouldBeSkippedByAnnotator(!validateFileRefs);
        }
    }

    public GenericAttributeValue getAttributeValue() {
        return this.myValue;
    }

    private static String cutTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected boolean isSoft() {
        return true;
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new AntDomFileReference(this, range, index, text);
    }

    @NotNull
    public XmlAttributeValue getElement() {
        XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)super.getElement();
        if (xmlAttributeValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomFileReferenceSet", "getElement"));
        }
        return xmlAttributeValue;
    }

    @Nullable
    public String getPathString() {
        return this.myValue.getStringValue();
    }

    public boolean isAbsolutePathReference() {
        if (super.isAbsolutePathReference()) {
            return true;
        }
        String path = this.getPathString();
        return path != null && FileUtil.isAbsolute((String)path);
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        AntDomProject containingProject;
        AntDomElement element = (AntDomElement)this.myValue.getParentOfType(AntDomElement.class, false);
        AntDomProject antDomProject = containingProject = element != null ? element.getAntProject() : null;
        if (containingProject != null) {
            String basedir;
            PsiFileSystemItem dirValue;
            if (this.isAbsolutePathReference()) {
                Collection collection = this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots());
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomFileReferenceSet", "computeDefaultContexts"));
                }
                return collection;
            }
            VirtualFile root = null;
            if (element instanceof AntDomAnt && (dirValue = (PsiFileSystemItem)((AntDomAnt)element).getAntFileDir().getValue()) instanceof PsiDirectory) {
                root = dirValue.getVirtualFile();
            }
            if (root == null && (basedir = element instanceof AntDomIncludingDirective ? containingProject.getContainingFileDir() : containingProject.getContextAntProject().getProjectBasedirPath()) != null) {
                root = LocalFileSystem.getInstance().findFileByPath(basedir);
            }
            if (root != null) {
                Collection collection = this.toFileSystemItems(new VirtualFile[]{root});
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomFileReferenceSet", "computeDefaultContexts"));
                }
                return collection;
            }
        }
        Collection collection = super.computeDefaultContexts();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomFileReferenceSet", "computeDefaultContexts"));
        }
        return collection;
    }
}

