/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaStaticClassScope;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b\u001a\f\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e\u00a8\u0006\u000f"}, d2={"copyValueParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "newValueParametersTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "oldValueParameters", "newOwner", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getImplClassNameForDeserialized", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedCallableMemberDescriptor;", "getParentJavaStaticClassScope", "Lorg/jetbrains/kotlin/load/java/lazy/descriptors/LazyJavaStaticClassScope;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "descriptor.loader.java"})
public final class UtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValueParameterDescriptor> copyValueParameters(@NotNull Collection<? extends KotlinType> newValueParametersTypes, @NotNull Collection<? extends ValueParameterDescriptor> oldValueParameters, @NotNull CallableDescriptor newOwner) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(newValueParametersTypes, (String)"newValueParametersTypes");
        Intrinsics.checkParameterIsNotNull(oldValueParameters, (String)"oldValueParameters");
        Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
        boolean bl = newValueParametersTypes.size() == oldValueParameters.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Different value parameters sizes: Enhanced = " + newValueParametersTypes.size() + ", Old = " + oldValueParameters.size();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Iterable $receiver$iv = CollectionsKt.zip((Iterable)newValueParametersTypes, (Iterable)oldValueParameters);
        Iterable $i$a$1$assert = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void newType;
            void oldParameter;
            void pair2;
            Pair pair3 = (Pair)item$iv$iv;
            void var15_14 = destination$iv$iv;
            Object var9_11 = pair2;
            KotlinType kotlinType = (KotlinType)var9_11.component1();
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)var9_11.component2();
            var9_11 = null;
            int n = oldParameter.getIndex();
            Annotations annotations2 = oldParameter.getAnnotations();
            Intrinsics.checkExpressionValueIsNotNull((Object)annotations2, (String)"oldParameter.annotations");
            Name name2 = oldParameter.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"oldParameter.name");
            boolean bl2 = oldParameter.declaresDefaultValue();
            boolean bl3 = oldParameter.isCrossinline();
            boolean bl4 = oldParameter.isNoinline();
            KotlinType kotlinType2 = oldParameter.getVarargElementType() != null ? DescriptorUtilsKt.getModule(newOwner).getBuiltIns().getArrayElementType((KotlinType)newType) : (KotlinType)null;
            SourceElement sourceElement = oldParameter.getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"oldParameter.source");
            ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(newOwner, (ValueParameterDescriptor)oldParameter, n, annotations2, name2, (KotlinType)newType, bl2, bl3, bl4, kotlinType2, sourceElement);
            var15_14.add(valueParameterDescriptorImpl);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final LazyJavaStaticClassScope getParentJavaStaticClassScope(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny($receiver);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor superClassDescriptor = classDescriptor;
        MemberScope staticScope = superClassDescriptor.getStaticScope();
        if (!(staticScope instanceof LazyJavaStaticClassScope)) {
            return UtilKt.getParentJavaStaticClassScope(superClassDescriptor);
        }
        return (LazyJavaStaticClassScope)staticScope;
    }

    @Nullable
    public static final Name getImplClassNameForDeserialized(@NotNull DeserializedCallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        SourceElement sourceElement = $receiver.getContainerSource();
        if (!(sourceElement instanceof JvmPackagePartSource)) {
            sourceElement = null;
        }
        JvmPackagePartSource jvmPackagePartSource = (JvmPackagePartSource)sourceElement;
        return jvmPackagePartSource != null ? jvmPackagePartSource.getSimpleName() : null;
    }
}

