/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.Navigation;
import com.android.resources.NavigationState;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.State;
import com.android.sdklib.repositoryv2.IdDisplay;
import com.android.sdklib.repositoryv2.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdDeviceData;
import com.android.tools.idea.avdmanager.AvdHardwareData;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceUiAction;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigureDeviceModel
extends WizardModel {
    private BindingsManager myBindings;
    private Device.Builder myBuilder;
    private final DeviceUiAction.DeviceProvider myProvider;
    private StringProperty myWizardPanelDescription;
    private AvdDeviceData myDeviceData;

    public StringProperty wizardPanelDescription() {
        return this.myWizardPanelDescription;
    }

    public AvdDeviceData getDeviceData() {
        return this.myDeviceData;
    }

    public ConfigureDeviceModel(@NotNull DeviceUiAction.DeviceProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/android/tools/idea/avdmanager/ConfigureDeviceModel", "<init>"));
        }
        this(provider, null, true);
    }

    public ConfigureDeviceModel(@NotNull DeviceUiAction.DeviceProvider provider, @Nullable Device device, boolean forcedCreation) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/android/tools/idea/avdmanager/ConfigureDeviceModel", "<init>"));
        }
        this.myBindings = new BindingsManager();
        this.myBuilder = new Device.Builder();
        this.myWizardPanelDescription = new StringValueProperty();
        this.myProvider = provider;
        this.myDeviceData = new AvdDeviceData(device, forcedCreation);
        Disposer.register((Disposable)this, (Disposable)this.myDeviceData);
        String description = device == null ? "Create a new hardware profile by selecting hardware features below." : device.getDisplayName() + " (Edited)";
        this.myWizardPanelDescription.set(description);
        this.initBootProperties(device);
    }

    private void initBootProperties(@Nullable Device device) {
        if (device != null) {
            for (Map.Entry entry : device.getBootProps().entrySet()) {
                this.myBuilder.addBootProp((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    @Override
    protected void handleFinished() {
        Device device = this.buildDevice();
        DeviceManagerConnection.getDefaultDeviceManagerConnection().createOrEditDevice(device);
        this.myProvider.refreshDevices();
        this.myProvider.setDevice(device);
    }

    @NotNull
    private Device buildDevice() {
        String deviceName = (String)this.myDeviceData.name().get();
        this.myBuilder.setName(deviceName);
        this.myBuilder.setId(deviceName);
        this.myBuilder.addSoftware(this.myDeviceData.software().getValue());
        this.myBuilder.setManufacturer((String)this.myDeviceData.manufacturer().get());
        IdDisplay tag = this.myDeviceData.deviceType().getValueOrNull();
        this.myBuilder.setTagId(SystemImage.DEFAULT_TAG.equals((Object)tag) || tag == null ? null : tag.getId());
        List<State> states = this.generateStates(new AvdHardwareData(this.myDeviceData).buildHardware());
        this.myBuilder.addAllState(states);
        Device device = this.myBuilder.build();
        if (device == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceModel", "buildDevice"));
        }
        return device;
    }

    @Nullable
    private static State createState(ScreenOrientation orientation, Hardware hardware, boolean hasHardwareKeyboard) {
        State state = null;
        String name = "";
        String description = "";
        if (orientation == ScreenOrientation.LANDSCAPE) {
            name = "Landscape";
            description = "The device in landscape orientation";
            state = new State();
        } else if (orientation == ScreenOrientation.PORTRAIT) {
            name = "Portrait";
            description = "The device in portrait orientation";
            state = new State();
        }
        if (state != null) {
            if (hasHardwareKeyboard) {
                name = name + " with keyboard";
                description = description + " with a keyboard open";
                state.setKeyState(KeyboardState.EXPOSED);
            } else if (hardware.getKeyboard() != null && hardware.getKeyboard().equals((Object)Keyboard.NOKEY)) {
                state.setKeyState(KeyboardState.SOFT);
            } else {
                state.setKeyState(KeyboardState.HIDDEN);
            }
            state.setName(name);
            state.setHardware(hardware);
            state.setOrientation(orientation);
            state.setDescription(description);
            state.setNavState(hardware.getNav().equals((Object)Navigation.NONAV) ? NavigationState.HIDDEN : NavigationState.EXPOSED);
        }
        return state;
    }

    private List<State> generateStates(Hardware hardware) {
        ArrayList states = Lists.newArrayListWithExpectedSize((int)4);
        if (((Boolean)this.myDeviceData.supportsPortrait().get()).booleanValue()) {
            states.add(ConfigureDeviceModel.createState(ScreenOrientation.PORTRAIT, hardware, false));
        }
        if (((Boolean)this.myDeviceData.supportsLandscape().get()).booleanValue()) {
            states.add(ConfigureDeviceModel.createState(ScreenOrientation.LANDSCAPE, hardware, false));
        }
        if (((Boolean)this.myDeviceData.hasHardwareKeyboard().get()).booleanValue()) {
            if (((Boolean)this.myDeviceData.supportsPortrait().get()).booleanValue()) {
                states.add(ConfigureDeviceModel.createState(ScreenOrientation.PORTRAIT, hardware, true));
            }
            if (((Boolean)this.myDeviceData.supportsLandscape().get()).booleanValue()) {
                states.add(ConfigureDeviceModel.createState(ScreenOrientation.LANDSCAPE, hardware, true));
            }
        }
        ((State)states.get(0)).setDefaultState(true);
        return states;
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
    }
}

