/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.actions;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.fd.InstantRunGradleUtils;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestartActivityAction
extends AnAction {
    public RestartActivityAction() {
        super("Restart Activity", null, AndroidIcons.RunIcons.Restart);
    }

    public void update(AnActionEvent e) {
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (module == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        if (!InstantRunSettings.isInstantRunEnabled()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        AndroidGradleModel model = InstantRunGradleUtils.getAppModel(module);
        if (model == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        Project project = module.getProject();
        boolean enabled = InstantRunSettings.isInstantRunEnabled() && InstantRunGradleUtils.getIrSupportStatus((AndroidGradleModel)model, null).success && !RestartActivityAction.getActiveSessions(project).isEmpty() && !RestartActivityAction.isDebuggerPaused(project);
        e.getPresentation().setEnabled(enabled);
    }

    private static List<ProcessHandler> getActiveSessions(@Nullable Project project) {
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList activeHandlers = Lists.newArrayList();
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            if (handler.isProcessTerminated() || handler.isProcessTerminating()) continue;
            activeHandlers.add(handler);
        }
        return activeHandlers;
    }

    private static boolean isDebuggerPaused(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        return session != null && !session.isStopped() && session.isPaused();
    }

    public void actionPerformed(AnActionEvent e) {
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (module == null) {
            return;
        }
        RestartActivityAction.restartActivity(module);
    }

    public static void restartActivity(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/actions/RestartActivityAction", "restartActivity"));
        }
        Project project = module.getProject();
        for (IDevice device : InstantRunManager.findDevices(project)) {
            if (!InstantRunManager.isAppInForeground(device, module)) continue;
            if (InstantRunSettings.isShowToastEnabled()) {
                InstantRunManager.showToast(device, module, "Activity Restarted");
            }
            InstantRunManager.restartActivity(device, module);
        }
    }
}

