/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties;

import com.google.common.collect.Queues;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import java.util.Queue;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class BatchInvoker {
    public static final Strategy APPLICATION_INVOKE_LATER_STRATEGY = new Strategy(){

        @Override
        public void invoke(@NotNull Runnable runnableBatch) {
            if (runnableBatch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnableBatch", "com/android/tools/idea/ui/properties/BatchInvoker$1", "invoke"));
            }
            ApplicationManager.getApplication().invokeLater(runnableBatch, ModalityState.any());
        }
    };
    public static final Strategy SWING_INVOKE_LATER_STRATEGY = new Strategy(){

        @Override
        public void invoke(@NotNull Runnable runnableBatch) {
            if (runnableBatch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnableBatch", "com/android/tools/idea/ui/properties/BatchInvoker$2", "invoke"));
            }
            SwingUtilities.invokeLater(runnableBatch);
        }
    };
    public static final Strategy INVOKE_IMMEDIATELY_STRATEGY = new Strategy(){

        @Override
        public void invoke(@NotNull Runnable runnableBatch) {
            if (runnableBatch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnableBatch", "com/android/tools/idea/ui/properties/BatchInvoker$3", "invoke"));
            }
            runnableBatch.run();
        }
    };
    private static final int MAX_CYCLE_COUNT = 10;
    private final Strategy myStrategy;
    private final Queue<Runnable> myRunnables;
    private final Queue<Runnable> myDeferredRunnables;
    private boolean myUpdateInProgress;

    public BatchInvoker() {
        this(ApplicationManager.getApplication() != null ? APPLICATION_INVOKE_LATER_STRATEGY : SWING_INVOKE_LATER_STRATEGY);
    }

    public BatchInvoker(@NotNull Strategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/android/tools/idea/ui/properties/BatchInvoker", "<init>"));
        }
        this.myRunnables = Queues.newArrayDeque();
        this.myDeferredRunnables = Queues.newArrayDeque();
        this.myStrategy = strategy;
    }

    public void enqueue(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/ui/properties/BatchInvoker", "enqueue"));
        }
        if (this.myUpdateInProgress) {
            if (!this.myDeferredRunnables.contains(runnable)) {
                this.myDeferredRunnables.add(runnable);
            }
            return;
        }
        boolean shouldInvoke = this.myRunnables.isEmpty();
        if (!this.myRunnables.contains(runnable)) {
            this.myRunnables.add(runnable);
        }
        if (shouldInvoke) {
            this.enqueueInvoke();
        }
    }

    private void enqueueInvoke() {
        this.myStrategy.invoke(new Runnable(){

            @Override
            public void run() {
                int cycleCount = 0;
                while (true) {
                    BatchInvoker.this.myUpdateInProgress = true;
                    for (Runnable runnable : BatchInvoker.this.myRunnables) {
                        runnable.run();
                    }
                    BatchInvoker.this.myRunnables.clear();
                    BatchInvoker.this.myUpdateInProgress = false;
                    if (BatchInvoker.this.myDeferredRunnables.isEmpty()) break;
                    if (++cycleCount > 10) {
                        BatchInvoker.this.myDeferredRunnables.clear();
                        throw new InfiniteCycleException();
                    }
                    BatchInvoker.this.myRunnables.addAll(BatchInvoker.this.myDeferredRunnables);
                    BatchInvoker.this.myDeferredRunnables.clear();
                }
            }
        });
    }

    public static final class InfiniteCycleException
    extends RuntimeException {
        public InfiniteCycleException() {
            super("Endless invocation cycle detected.");
        }
    }

    public static interface Strategy {
        public void invoke(@NotNull Runnable var1);
    }
}

