/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.ui.ApiComboBoxItem;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateResourceActionBase
extends AnAction {
    protected CreateResourceActionBase() {
    }

    protected CreateResourceActionBase(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @Nullable
    public static SourceProvider getSourceProvider(@Nullable JComboBox combo) {
        Object selectedItem;
        if (combo != null && combo.isVisible() && (selectedItem = combo.getSelectedItem()) instanceof ApiComboBoxItem) {
            return (SourceProvider)((ApiComboBoxItem)selectedItem).getData();
        }
        return null;
    }

    @Nullable
    public static PsiDirectory getResourceDirectory(@Nullable SourceProvider sourceProvider, @NotNull Module module, boolean create) {
        VirtualFile res;
        AndroidFacet facet;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/actions/CreateResourceActionBase", "getResourceDirectory"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (sourceProvider != null) {
            final PsiManager manager = PsiManager.getInstance((Project)module.getProject());
            for (final File file : sourceProvider.getResDirectories()) {
                PsiDirectory dir;
                if (create && !file.exists()) {
                    PsiDirectory dir2 = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

                        public PsiDirectory compute() {
                            return DirectoryUtil.mkdirs((PsiManager)manager, (String)FileUtil.toSystemIndependentName((String)file.getPath()));
                        }
                    });
                    if (dir2 == null) continue;
                    return dir2;
                }
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
                if (virtualFile == null || (dir = manager.findDirectory(virtualFile)) == null) continue;
                return dir;
            }
        }
        if ((facet = AndroidFacet.getInstance(module)) != null && (res = facet.getPrimaryResourceDir()) != null) {
            return PsiManager.getInstance((Project)module.getProject()).findDirectory(res);
        }
        return null;
    }

    public static void updateSourceSetCombo(@NotNull JComponent label, @NotNull JComboBox combo, @Nullable AndroidFacet facet, @Nullable PsiDirectory resDirectory) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/android/actions/CreateResourceActionBase", "updateSourceSetCombo"));
        }
        if (combo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "combo", "org/jetbrains/android/actions/CreateResourceActionBase", "updateSourceSetCombo"));
        }
        if (facet != null && facet.requiresAndroidModel() && facet.getAndroidModel() != null) {
            List<SourceProvider> providers = IdeaSourceProvider.getAllSourceProviders(facet);
            DefaultComboBoxModel<ApiComboBoxItem<SourceProvider>> model = new DefaultComboBoxModel<ApiComboBoxItem<SourceProvider>>();
            for (SourceProvider sourceProvider : providers) {
                model.addElement(new ApiComboBoxItem<SourceProvider>(sourceProvider, sourceProvider.getName(), 0, 0));
            }
            combo.setModel(model);
            label.setVisible(true);
            combo.setVisible(true);
        } else {
            label.setVisible(false);
            combo.setVisible(false);
        }
    }

    @NotNull
    protected abstract PsiElement[] invokeDialog(@NotNull Project var1, @NotNull DataContext var2);

    @NotNull
    protected abstract PsiElement[] create(String var1, PsiDirectory var2) throws Exception;

    protected abstract String getErrorTitle();

    protected abstract String getCommandName();

    protected abstract String getActionName(PsiDirectory var1, String var2);

    public final void actionPerformed(AnActionEvent e) {
        PsiElement[] createdElements;
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        for (PsiElement createdElement : createdElements = this.invokeDialog(project, dataContext)) {
            view.selectElement(createdElement);
        }
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        boolean enabled = this.isAvailable(dataContext);
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    public boolean isDumbAware() {
        return false;
    }

    protected boolean isAvailable(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        if (DumbService.getInstance((Project)project).isDumb() && !this.isDumbAware()) {
            return false;
        }
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        return view != null && view.getDirectories().length != 0;
    }

    @Nullable
    private static VirtualFile getResFolderParent(@NotNull LocalResourceManager manager, @NotNull VirtualFile file) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/actions/CreateResourceActionBase", "getResFolderParent"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/actions/CreateResourceActionBase", "getResFolderParent"));
        }
        for (VirtualFile current = file; current != null; current = current.getParent()) {
            if (!current.isDirectory() || !manager.isResourceDir(current)) continue;
            return current;
        }
        return null;
    }

    @Nullable
    public static PsiDirectory findResourceDirectory(@NotNull DataContext dataContext) {
        VirtualFile resFolder;
        LocalResourceManager manager;
        Module module;
        AbstractProjectViewPane pane;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "org/jetbrains/android/actions/CreateResourceActionBase", "findResourceDirectory"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && (pane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane()) instanceof AndroidProjectViewPane) {
            return null;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file != null && (module = (Module)LangDataKeys.MODULE.getData(dataContext)) != null && (manager = LocalResourceManager.getInstance(module)) != null && (resFolder = CreateResourceActionBase.getResFolderParent(manager, file)) != null) {
            return AndroidPsiUtils.getPsiDirectorySafely(module.getProject(), resFolder);
        }
        return null;
    }

    protected class MyInputValidator
    extends ElementCreator
    implements InputValidator {
        private final PsiDirectory myDirectory;
        private PsiElement[] myCreatedElements;

        public MyInputValidator(Project project, PsiDirectory directory) {
            super(project, CreateResourceActionBase.this.getErrorTitle());
            this.myCreatedElements = PsiElement.EMPTY_ARRAY;
            this.myDirectory = directory;
        }

        public PsiDirectory getDirectory() {
            return this.myDirectory;
        }

        public boolean checkInput(String inputString) {
            return true;
        }

        public PsiElement[] create(String newName) throws Exception {
            return CreateResourceActionBase.this.create(newName, this.myDirectory);
        }

        public String getActionName(String newName) {
            return CreateResourceActionBase.this.getActionName(this.myDirectory, newName);
        }

        public boolean canClose(String inputString) {
            this.myCreatedElements = this.tryCreate(inputString);
            return this.myCreatedElements.length > 0;
        }

        public final PsiElement[] getCreatedElements() {
            return this.myCreatedElements;
        }
    }
}

