/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.drag.source;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.DragSourceShadow;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItem;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.stage.Window;

public class LibraryDragSource
extends AbstractDragSource {
    private final LibraryItem libraryItem;
    private final FXOMDocument targetDocument;
    private FXOMObject libraryItemObject;
    private List<FXOMObject> draggedObjects;

    public LibraryDragSource(LibraryItem libraryItem, FXOMDocument targetDocument, Window ownerWindow) {
        super(ownerWindow);
        assert (libraryItem != null);
        assert (targetDocument != null);
        this.libraryItem = libraryItem;
        this.targetDocument = targetDocument;
    }

    public LibraryItem getLibraryItem() {
        return this.libraryItem;
    }

    public FXOMObject getLibraryItemObject() {
        if (this.libraryItemObject == null) {
            FXOMDocument itemDocument = this.libraryItem.instantiate();
            assert (itemDocument != null);
            assert (itemDocument.getFxomRoot() != null);
            this.libraryItemObject = itemDocument.getFxomRoot();
            this.libraryItemObject.moveToFxomDocument(this.targetDocument);
            assert (itemDocument.getFxomRoot() == null);
            if (this.libraryItemObject.getSceneGraphObject() instanceof Node) {
                Node sceneGraphNode = (Node)this.libraryItemObject.getSceneGraphObject();
                Group group = new Group();
                group.getChildren().add((Object)sceneGraphNode);
                Scene scene = new Scene((Parent)group);
                scene.getClass();
                group.applyCss();
                group.layout();
            }
        }
        return this.libraryItemObject;
    }

    @Override
    public boolean isAcceptable() {
        return true;
    }

    @Override
    public List<FXOMObject> getDraggedObjects() {
        if (this.draggedObjects == null) {
            this.draggedObjects = new ArrayList<FXOMObject>();
            this.draggedObjects.add(this.getLibraryItemObject());
        }
        return this.draggedObjects;
    }

    @Override
    public FXOMObject getHitObject() {
        return this.getDraggedObjects().get(0);
    }

    @Override
    public double getHitX() {
        double result;
        FXOMObject hitObject = this.getHitObject();
        if (hitObject == null) {
            result = Double.NaN;
        } else if (hitObject.isNode()) {
            Node hitNode = (Node)hitObject.getSceneGraphObject();
            Bounds b = hitNode.getLayoutBounds();
            result = (b.getMinX() + b.getMaxX()) / 2.0;
        } else {
            result = 0.0;
        }
        return result;
    }

    @Override
    public double getHitY() {
        double result;
        FXOMObject hitObject = this.getHitObject();
        if (hitObject == null) {
            result = Double.NaN;
        } else if (hitObject.isNode()) {
            Node hitNode = (Node)hitObject.getSceneGraphObject();
            Bounds b = hitNode.getLayoutBounds();
            result = (b.getMinY() + b.getMaxY()) / 2.0;
        } else {
            result = 0.0;
        }
        return result;
    }

    @Override
    public ClipboardContent makeClipboardContent() {
        ClipboardContent result = new ClipboardContent();
        result.putString(this.libraryItem.getFxmlText());
        return result;
    }

    @Override
    public Image makeDragView() {
        URL iconURL = this.libraryItem.getIconURL();
        if (iconURL == null) {
            iconURL = ImageUtils.getNodeIconURL("MissingIcon.png");
        }
        Image imageFromIcon = new Image(iconURL.toExternalForm());
        Label visualNode = new Label();
        visualNode.setGraphic((Node)new ImageView(imageFromIcon));
        visualNode.getStylesheets().add((Object)EditorController.getStylesheet().toString());
        visualNode.getStyleClass().add((Object)"drag-preview");
        return ImageUtils.getImageFromNode((Node)visualNode);
    }

    @Override
    public Node makeShadow() {
        Group result = new Group();
        result.getStylesheets().add((Object)EditorController.getStylesheet().toString());
        if (this.getLibraryItemObject().getSceneGraphObject() instanceof Node) {
            Node sceneGraphNode = (Node)this.getLibraryItemObject().getSceneGraphObject();
            DragSourceShadow shadowNode = new DragSourceShadow();
            shadowNode.setupForNode(sceneGraphNode);
            result.getChildren().add((Object)shadowNode);
        }
        Bounds b = result.getBoundsInParent();
        double centerX = (b.getMinX() + b.getMaxX()) / 2.0;
        double centerY = (b.getMinY() + b.getMaxY()) / 2.0;
        result.setTranslateX(-centerX);
        result.setTranslateY(-centerY);
        return result;
    }

    @Override
    public String makeDropJobDescription() {
        return I18N.getString("drop.job.insert.library.item", this.getLibraryItem().getName());
    }

    @Override
    public boolean isNodeOnly() {
        return this.getLibraryItemObject().isNode();
    }

    @Override
    public boolean isSingleImageViewOnly() {
        boolean result = this.getLibraryItemObject() instanceof FXOMInstance ? this.getLibraryItemObject().getSceneGraphObject() instanceof ImageView : false;
        return result;
    }

    @Override
    public boolean isSingleTooltipOnly() {
        boolean result = this.getLibraryItemObject() instanceof FXOMInstance ? this.getLibraryItemObject().getSceneGraphObject() instanceof Tooltip : false;
        return result;
    }

    @Override
    public boolean isSingleContextMenuOnly() {
        boolean result = this.getLibraryItemObject() instanceof FXOMInstance ? this.getLibraryItemObject().getSceneGraphObject() instanceof ContextMenu : false;
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": libraryItem=(" + this.libraryItem + ")";
    }
}

