/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.control.Accordion;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;

class TransientStateBackup {
    private final FXOMDocument fxomDocument;
    private final Map<FXOMObject, FXOMObject> tabPaneMap = new HashMap<FXOMObject, FXOMObject>();
    private final Map<FXOMObject, FXOMObject> accordionMap = new HashMap<FXOMObject, FXOMObject>();

    public TransientStateBackup(FXOMDocument fxomDocument) {
        assert (fxomDocument != null);
        this.fxomDocument = fxomDocument;
        ArrayList<FXOMObject> candidates = new ArrayList<FXOMObject>();
        if (this.fxomDocument.getFxomRoot() != null) {
            candidates.add(this.fxomDocument.getFxomRoot());
        }
        while (!candidates.isEmpty()) {
            FXOMObject titledPaneObject;
            Accordion accordion;
            TitledPane currentTitledPane;
            FXOMObject candidate = (FXOMObject)candidates.get(0);
            candidates.remove(0);
            Object sceneGraphObject = candidate.getSceneGraphObject();
            if (sceneGraphObject instanceof TabPane) {
                FXOMObject tabObject;
                TabPane tabPane = (TabPane)sceneGraphObject;
                Tab currentTab = (Tab)tabPane.getSelectionModel().getSelectedItem();
                if (currentTab != null && (tabObject = candidate.searchWithSceneGraphObject(currentTab)) != null) {
                    this.tabPaneMap.put(candidate, tabObject);
                }
            } else if (sceneGraphObject instanceof Accordion && (currentTitledPane = (accordion = (Accordion)sceneGraphObject).getExpandedPane()) != null && (titledPaneObject = candidate.searchWithSceneGraphObject(currentTitledPane)) != null) {
                this.accordionMap.put(candidate, titledPaneObject);
            }
            candidates.addAll(candidate.getChildObjects());
        }
    }

    public void restore() {
        ArrayList<FXOMObject> candidates = new ArrayList<FXOMObject>();
        if (this.fxomDocument.getFxomRoot() != null) {
            candidates.add(this.fxomDocument.getFxomRoot());
        }
        while (!candidates.isEmpty()) {
            FXOMObject candidate = (FXOMObject)candidates.get(0);
            candidates.remove(0);
            Object sceneGraphObject = candidate.getSceneGraphObject();
            if (sceneGraphObject instanceof TabPane) {
                TabPane tabPane = (TabPane)sceneGraphObject;
                FXOMObject tabObject = this.tabPaneMap.get(candidate);
                if (tabObject != null && tabObject.getParentObject() == candidate) {
                    assert (tabObject.getSceneGraphObject() instanceof Tab);
                    Tab tab = (Tab)tabObject.getSceneGraphObject();
                    assert (tabPane.getTabs().contains((Object)tab));
                    tabPane.getSelectionModel().select((Object)tab);
                }
            } else if (sceneGraphObject instanceof Accordion) {
                Accordion accordion = (Accordion)sceneGraphObject;
                FXOMObject titlePaneObject = this.accordionMap.get(candidate);
                if (titlePaneObject != null && titlePaneObject.getParentObject() == candidate) {
                    assert (titlePaneObject.getSceneGraphObject() instanceof TitledPane);
                    TitledPane titledPane = (TitledPane)titlePaneObject.getSceneGraphObject();
                    assert (accordion.getPanes().contains((Object)titledPane));
                    accordion.setExpandedPane(titledPane);
                }
            }
            candidates.addAll(candidate.getChildObjects());
        }
    }
}

