/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardGestureAction;
import com.intellij.openapi.actionSystem.KeyboardModifierGestureShortcut;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PressureShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.MacKeymapUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeymapUtil {
    @NonNls
    private static final String APPLE_LAF_AQUA_LOOK_AND_FEEL_CLASS_NAME = "apple.laf.AquaLookAndFeel";
    @NonNls
    private static final String GET_KEY_MODIFIERS_TEXT_METHOD = "getKeyModifiersText";
    @NonNls
    private static final String CANCEL_KEY_TEXT = "Cancel";
    @NonNls
    private static final String BREAK_KEY_TEXT = "Break";
    @NonNls
    private static final String SHIFT = "shift";
    @NonNls
    private static final String CONTROL = "control";
    @NonNls
    private static final String CTRL = "ctrl";
    @NonNls
    private static final String META = "meta";
    @NonNls
    private static final String ALT = "alt";
    @NonNls
    private static final String ALT_GRAPH = "altGraph";
    @NonNls
    private static final String DOUBLE_CLICK = "doubleClick";
    private static final Set<Integer> ourTooltipKeys = new HashSet<Integer>();
    private static final Set<Integer> ourOtherTooltipKeys = new HashSet<Integer>();
    private static RegistryValue ourTooltipKeysProperty;

    private KeymapUtil() {
    }

    public static String getShortcutText(@NotNull Shortcut shortcut) {
        if (shortcut == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcut", "com/intellij/openapi/keymap/KeymapUtil", "getShortcutText"));
        }
        String s = "";
        if (shortcut instanceof KeyboardShortcut) {
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
            String acceleratorText = KeymapUtil.getKeystrokeText(keyboardShortcut.getFirstKeyStroke());
            if (!acceleratorText.isEmpty()) {
                s = acceleratorText;
            }
            if (!(acceleratorText = KeymapUtil.getKeystrokeText(keyboardShortcut.getSecondKeyStroke())).isEmpty()) {
                s = s + ", " + acceleratorText;
            }
        } else if (shortcut instanceof MouseShortcut) {
            s = KeymapUtil.getMouseShortcutText((MouseShortcut)shortcut);
        } else if (shortcut instanceof KeyboardModifierGestureShortcut) {
            KeyboardModifierGestureShortcut gestureShortcut = (KeyboardModifierGestureShortcut)shortcut;
            s = gestureShortcut.getType() == KeyboardGestureAction.ModifierType.dblClick ? "Press, release and hold " : "Hold ";
            s = s + KeymapUtil.getKeystrokeText(gestureShortcut.getStroke());
        } else {
            throw new IllegalArgumentException("unknown shortcut class: " + shortcut.getClass().getCanonicalName());
        }
        return s;
    }

    public static Icon getShortcutIcon(Shortcut shortcut) {
        if (shortcut instanceof KeyboardShortcut) {
            return AllIcons.General.KeyboardShortcut;
        }
        if (shortcut instanceof MouseShortcut) {
            return AllIcons.General.MouseShortcut;
        }
        throw new IllegalArgumentException("unknown shortcut class: " + shortcut);
    }

    public static String getMouseShortcutText(@NotNull MouseShortcut shortcut) {
        if (shortcut == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcut", "com/intellij/openapi/keymap/KeymapUtil", "getMouseShortcutText"));
        }
        if (shortcut instanceof PressureShortcut) {
            return shortcut.toString();
        }
        return KeymapUtil.getMouseShortcutText(shortcut.getButton(), shortcut.getModifiers(), shortcut.getClickCount());
    }

    public static String getMouseShortcutText(int button, @JdkConstants.InputEventMask int modifiers, int clickCount) {
        String resource;
        if (button == 143) {
            resource = "mouse.wheel.rotate.up.shortcut.text";
        } else if (button == 142) {
            resource = "mouse.wheel.rotate.down.shortcut.text";
        } else if (clickCount < 2) {
            resource = "mouse.click.shortcut.text";
        } else if (clickCount < 3) {
            resource = "mouse.double.click.shortcut.text";
        } else {
            throw new IllegalStateException("unknown clickCount: " + clickCount);
        }
        return KeyMapBundle.message(resource, KeymapUtil.getModifiersText(KeymapUtil.mapNewModifiers(modifiers)), button);
    }

    @JdkConstants.InputEventMask
    private static int mapNewModifiers(@JdkConstants.InputEventMask int modifiers) {
        if ((modifiers & 0x40) != 0) {
            modifiers |= 1;
        }
        if ((modifiers & 0x200) != 0) {
            modifiers |= 8;
        }
        if ((modifiers & 0x2000) != 0) {
            modifiers |= 0x20;
        }
        if ((modifiers & 0x80) != 0) {
            modifiers |= 2;
        }
        if ((modifiers & 0x100) != 0) {
            modifiers |= 4;
        }
        return modifiers;
    }

    public static String getKeystrokeText(KeyStroke accelerator) {
        String keyText;
        if (accelerator == null) {
            return "";
        }
        if (SystemInfo.isMac) {
            return MacKeymapUtil.getKeyStrokeText(accelerator);
        }
        String acceleratorText = "";
        int modifiers = accelerator.getModifiers();
        if (modifiers > 0) {
            acceleratorText = KeymapUtil.getModifiersText(modifiers);
        }
        int code = accelerator.getKeyCode();
        String string = keyText = SystemInfo.isMac ? MacKeymapUtil.getKeyText(code) : KeyEvent.getKeyText(code);
        if (CANCEL_KEY_TEXT.equals(keyText)) {
            keyText = BREAK_KEY_TEXT;
        }
        acceleratorText = acceleratorText + keyText;
        return acceleratorText.trim();
    }

    private static String getModifiersText(@JdkConstants.InputEventMask int modifiers) {
        if (SystemInfo.isMac) {
            return MacKeymapUtil.getModifiersText(modifiers);
        }
        String keyModifiersText = KeyEvent.getKeyModifiersText(modifiers);
        if (keyModifiersText.isEmpty()) {
            return keyModifiersText;
        }
        return keyModifiersText + "+";
    }

    @NotNull
    public static String getFirstKeyboardShortcutText(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/keymap/KeymapUtil", "getFirstKeyboardShortcutText"));
        }
        Object[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionId);
        KeyboardShortcut shortcut = (KeyboardShortcut)ContainerUtil.findInstance((Object[])shortcuts, KeyboardShortcut.class);
        String string = shortcut == null ? "" : KeymapUtil.getShortcutText(shortcut);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/KeymapUtil", "getFirstKeyboardShortcutText"));
        }
        return string;
    }

    @NotNull
    public static String getFirstKeyboardShortcutText(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/keymap/KeymapUtil", "getFirstKeyboardShortcutText"));
        }
        Object[] shortcuts = action.getShortcutSet().getShortcuts();
        KeyboardShortcut shortcut = (KeyboardShortcut)ContainerUtil.findInstance((Object[])shortcuts, KeyboardShortcut.class);
        String string = shortcut == null ? "" : KeymapUtil.getShortcutText(shortcut);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/KeymapUtil", "getFirstKeyboardShortcutText"));
        }
        return string;
    }

    @NotNull
    public static String getPreferredShortcutText(@NotNull Shortcut[] shortcuts) {
        if (shortcuts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcuts", "com/intellij/openapi/keymap/KeymapUtil", "getPreferredShortcutText"));
        }
        KeyboardShortcut shortcut = (KeyboardShortcut)ContainerUtil.findInstance((Object[])shortcuts, KeyboardShortcut.class);
        String string = shortcut != null ? KeymapUtil.getShortcutText(shortcut) : (shortcuts.length > 0 ? KeymapUtil.getShortcutText(shortcuts[0]) : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/KeymapUtil", "getPreferredShortcutText"));
        }
        return string;
    }

    public static String getShortcutsText(Shortcut[] shortcuts) {
        if (shortcuts.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < shortcuts.length; ++i) {
            Shortcut shortcut = shortcuts[i];
            if (i > 0) {
                buffer.append(' ');
            }
            buffer.append(KeymapUtil.getShortcutText(shortcut));
        }
        return buffer.toString();
    }

    public static MouseShortcut parseMouseShortcut(String keystrokeString) throws InvalidDataException {
        if (Registry.is((String)"ide.mac.forceTouch") && keystrokeString.startsWith("Force touch")) {
            return new PressureShortcut(2.0);
        }
        int button = -1;
        int modifiers = 0;
        int clickCount = 1;
        StringTokenizer tokenizer = new StringTokenizer(keystrokeString);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (SHIFT.equals(token)) {
                modifiers |= 0x40;
                continue;
            }
            if (CONTROL.equals(token) || CTRL.equals(token)) {
                modifiers |= 0x80;
                continue;
            }
            if (META.equals(token)) {
                modifiers |= 0x100;
                continue;
            }
            if (ALT.equals(token)) {
                modifiers |= 0x200;
                continue;
            }
            if (ALT_GRAPH.equals(token)) {
                modifiers |= 0x2000;
                continue;
            }
            if (token.startsWith("button") && token.length() > 6) {
                try {
                    button = Integer.parseInt(token.substring(6));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new InvalidDataException("unparseable token: " + token);
                }
            }
            if (DOUBLE_CLICK.equals(token)) {
                clickCount = 2;
                continue;
            }
            throw new InvalidDataException("unknown token: " + token);
        }
        return new MouseShortcut(button, modifiers, clickCount);
    }

    public static String getKeyModifiersTextForMacOSLeopard(@JdkConstants.InputEventMask int modifiers) {
        StringBuilder buf = new StringBuilder();
        if ((modifiers & 4) != 0) {
            buf.append("\u2318");
        }
        if ((modifiers & 2) != 0) {
            buf.append(Toolkit.getProperty("AWT.control", "Ctrl"));
        }
        if ((modifiers & 8) != 0) {
            buf.append("\u009a5");
        }
        if ((modifiers & 1) != 0) {
            buf.append(Toolkit.getProperty("AWT.shift", "Shift"));
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
        }
        if ((modifiers & 0x10) != 0) {
            buf.append(Toolkit.getProperty("AWT.button1", "Button1"));
        }
        return buf.toString();
    }

    public static boolean isTooltipRequest(KeyEvent keyEvent) {
        if (ourTooltipKeysProperty == null) {
            ourTooltipKeysProperty = Registry.get((String)"ide.forcedShowTooltip");
            ourTooltipKeysProperty.addListener((RegistryValueListener)new RegistryValueListener.Adapter(){

                public void afterValueChanged(RegistryValue value) {
                    KeymapUtil.updateTooltipRequestKey(value);
                }
            }, Disposer.get((String)"ui"));
            KeymapUtil.updateTooltipRequestKey(ourTooltipKeysProperty);
        }
        if (keyEvent.getID() != 401) {
            return false;
        }
        for (Integer each : ourTooltipKeys) {
            if ((keyEvent.getModifiers() & each) != 0) continue;
            return false;
        }
        for (Integer each : ourOtherTooltipKeys) {
            if ((keyEvent.getModifiers() & each) <= 0) continue;
            return false;
        }
        int code = keyEvent.getKeyCode();
        return code == 157 || code == 17 || code == 16 || code == 18;
    }

    private static void updateTooltipRequestKey(RegistryValue value) {
        String text = value.asString();
        ourTooltipKeys.clear();
        ourOtherTooltipKeys.clear();
        KeymapUtil.processKey(text.contains(META), 4);
        KeymapUtil.processKey(text.contains(CONTROL) || text.contains(CTRL), 2);
        KeymapUtil.processKey(text.contains(SHIFT), 1);
        KeymapUtil.processKey(text.contains(ALT), 8);
    }

    private static void processKey(boolean condition, int value) {
        if (condition) {
            ourTooltipKeys.add(value);
        } else {
            ourOtherTooltipKeys.add(value);
        }
    }

    public static boolean isEmacsKeymap() {
        return KeymapUtil.isEmacsKeymap(KeymapManager.getInstance().getActiveKeymap());
    }

    public static boolean isEmacsKeymap(@Nullable Keymap keymap) {
        while (keymap != null) {
            if ("Emacs".equalsIgnoreCase(keymap.getName())) {
                return true;
            }
            keymap = keymap.getParent();
        }
        return false;
    }

    @Nullable
    public static KeyStroke getKeyStroke(@NotNull ShortcutSet shortcutSet) {
        if (shortcutSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcutSet", "com/intellij/openapi/keymap/KeymapUtil", "getKeyStroke"));
        }
        Shortcut[] shortcuts = shortcutSet.getShortcuts();
        if (shortcuts.length == 0 || !(shortcuts[0] instanceof KeyboardShortcut)) {
            return null;
        }
        KeyboardShortcut shortcut = (KeyboardShortcut)shortcuts[0];
        if (shortcut.getSecondKeyStroke() != null) {
            return null;
        }
        return shortcut.getFirstKeyStroke();
    }

    @NotNull
    public static String createTooltipText(@Nullable String name, @NotNull AnAction action) {
        String toolTipText;
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/keymap/KeymapUtil", "createTooltipText"));
        }
        String string = toolTipText = name == null ? "" : name;
        while (StringUtil.endsWithChar((CharSequence)toolTipText, (char)'.')) {
            toolTipText = toolTipText.substring(0, toolTipText.length() - 1);
        }
        String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText(action);
        if (!shortcutsText.isEmpty()) {
            toolTipText = toolTipText + " (" + shortcutsText + ")";
        }
        String string2 = toolTipText;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/KeymapUtil", "createTooltipText"));
        }
        return string2;
    }

    public static boolean matchActionMouseShortcutsModifiers(Keymap activeKeymap, @JdkConstants.InputEventMask int modifiers, String actionId) {
        MouseShortcut syntheticShortcut = new MouseShortcut(1, modifiers, 1);
        for (Shortcut shortcut : activeKeymap.getShortcuts(actionId)) {
            MouseShortcut mouseShortcut;
            if (!(shortcut instanceof MouseShortcut) || (mouseShortcut = (MouseShortcut)shortcut).getModifiers() != syntheticShortcut.getModifiers()) continue;
            return true;
        }
        return false;
    }

    public static boolean isMouseActionEvent(@NotNull MouseEvent e, @NotNull String actionId) {
        String[] actionIds;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/KeymapUtil", "isMouseActionEvent"));
        }
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/keymap/KeymapUtil", "isMouseActionEvent"));
        }
        KeymapManager keymapManager = KeymapManager.getInstance();
        if (keymapManager == null) {
            return false;
        }
        Keymap keymap = keymapManager.getActiveKeymap();
        if (keymap == null) {
            return false;
        }
        int button = MouseShortcut.getButton(e);
        int modifiers = e.getModifiersEx();
        if (button == 0 && e.getID() == 506) {
            if ((modifiers & 0x400) != 0) {
                button = 1;
            } else if ((modifiers & 0x800) != 0) {
                button = 2;
            }
        }
        if ((actionIds = keymap.getActionIds(new MouseShortcut(button, modifiers, 1))) == null) {
            return false;
        }
        for (String id : actionIds) {
            if (!actionId.equals(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean reassignAction(@NotNull JComponent component, @NotNull KeyStroke oldKeyStroke, @Nullable KeyStroke newKeyStroke, int condition) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/keymap/KeymapUtil", "reassignAction"));
        }
        if (oldKeyStroke == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldKeyStroke", "com/intellij/openapi/keymap/KeymapUtil", "reassignAction"));
        }
        ActionListener action = component.getActionForKeyStroke(oldKeyStroke);
        if (action == null) {
            return false;
        }
        if (newKeyStroke != null) {
            component.registerKeyboardAction(action, newKeyStroke, condition);
        }
        component.unregisterKeyboardAction(oldKeyStroke);
        return true;
    }
}

