/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CustomCodeStyleSettings
implements Cloneable {
    private final CodeStyleSettings myContainer;
    private final String myTagName;

    protected CustomCodeStyleSettings(@NonNls @NotNull String tagName, CodeStyleSettings container) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/psi/codeStyle/CustomCodeStyleSettings", "<init>"));
        }
        this.myTagName = tagName;
        this.myContainer = container;
    }

    public final CodeStyleSettings getContainer() {
        return this.myContainer;
    }

    @NonNls
    @NotNull
    public final String getTagName() {
        String string = this.myTagName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CustomCodeStyleSettings", "getTagName"));
        }
        return string;
    }

    @NotNull
    public List<String> getKnownTagNames() {
        List<String> list = Collections.singletonList(this.getTagName());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CustomCodeStyleSettings", "getKnownTagNames"));
        }
        return list;
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        Element child = parentElement.getChild(this.myTagName);
        if (child != null) {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)child);
            this.importLegacySettings();
        }
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        if (parentSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentSettings", "com/intellij/psi/codeStyle/CustomCodeStyleSettings", "writeExternal"));
        }
        Element childElement = new Element(this.myTagName);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)childElement, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter((Object)this, (Object)parentSettings));
        if (!childElement.getContent().isEmpty()) {
            parentElement.addContent(childElement);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void importLegacySettings() {
    }
}

