/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.context;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleFieldCache;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.context.VariableContext;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.validation.inspections.quickfix.XPathQuickFixFactory;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.associations.FileAssociationsManager;
import org.intellij.lang.xpath.xslt.context.XsltContextProvider;
import org.intellij.lang.xpath.xslt.context.XsltNamespaceContext;
import org.intellij.lang.xpath.xslt.context.XsltQuickFixFactory;
import org.intellij.lang.xpath.xslt.context.XsltVariableContext;
import org.intellij.lang.xpath.xslt.psi.XsltElement;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.intellij.lang.xpath.xslt.psi.XsltWithParam;
import org.intellij.lang.xpath.xslt.util.NSDeclTracker;
import org.intellij.lang.xpath.xslt.util.QNameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XsltContextProviderBase
extends ContextProvider {
    protected static final Set<String> IGNORED_URIS = new THashSet();
    private static final SimpleFieldCache<CachedValue<ElementNames>, XsltContextProviderBase> myNamesCache;
    private CachedValue<ElementNames> myNames;
    protected final SmartPsiElementPointer<XmlElement> myContextElement;
    protected final FileAssociationsManager myFileAssociationsManager;

    protected XsltContextProviderBase(XmlElement element) {
        Project project = element.getProject();
        this.myFileAssociationsManager = FileAssociationsManager.getInstance(project);
        this.myContextElement = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)element);
        this.attachTo(element);
    }

    @Override
    protected boolean isValid() {
        return super.isValid() && this.matchContextType();
    }

    private boolean matchContextType() {
        PsiFile file = this.myContextElement.getContainingFile();
        return file != null && XsltSupport.getXsltLanguageLevel(file).getXPathVersion() == this.getContextType().getVersion();
    }

    private static void fillFromSchema(PsiFile file, ElementNames names) {
        if (!(file instanceof XmlFile)) {
            return;
        }
        XmlFile f = (XmlFile)file;
        XmlDocument d = f.getDocument();
        if (d == null) {
            return;
        }
        XmlTag rootTag = d.getRootTag();
        if (rootTag == null) {
            return;
        }
        names.dependencies.add(new NSDeclTracker(rootTag));
        try {
            Map namespaceDeclarations = rootTag.getLocalNamespaceDeclarations();
            Set prefixes = namespaceDeclarations.keySet();
            XmlElementFactory ef = XmlElementFactory.getInstance((Project)file.getProject());
            int noSchemaNamespaces = 0;
            for (String prefix : prefixes) {
                String namespace;
                if (XsltContextProviderBase.isIgnoredNamespace(prefix, namespace = (String)namespaceDeclarations.get(prefix))) continue;
                XmlTag tag = ef.createTagFromText((CharSequence)("<dummy-tag xmlns='" + namespace + "' />"), (Language)XMLLanguage.INSTANCE);
                XmlDocument document = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlDocument.class);
                XmlNSDescriptor rootDescriptor = tag.getNSDescriptor(tag.getNamespace(), true);
                if (rootDescriptor == null || rootDescriptor instanceof XmlNSDescriptorImpl && ((XmlNSDescriptorImpl)rootDescriptor).getTag() == null || !rootDescriptor.getDeclaration().isPhysical()) {
                    QName any = QNameUtil.createAnyLocalName(namespace);
                    names.elementNames.add(any);
                    names.attributeNames.add(any);
                    ++noSchemaNamespaces;
                    continue;
                }
                names.dependencies.add(rootDescriptor.getDescriptorFile());
                THashSet history = new THashSet(150);
                XmlElementDescriptor[] e = rootDescriptor.getRootElementsDescriptors(document);
                try {
                    for (XmlElementDescriptor descriptor2 : e) {
                        XsltContextProviderBase.processElementDescriptors(descriptor2, tag, names, (Set<XmlElementDescriptor>)history, 0);
                    }
                }
                catch (StopProcessingException e1) {
                    Logger.getInstance(XsltContextProviderBase.class).error("Maximum recursion depth reached. Missing equals()/hashCode() implementation?", new String[]{StringUtil.join((Collection)history, descriptor -> descriptor.getClass().getName() + "[" + descriptor.getQualifiedName() + "]", (String)", ")});
                }
            }
            names.validateNames = names.elementNames.size() > noSchemaNamespaces;
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance((String)XsltContextProvider.class.getName()).error((Throwable)e);
        }
    }

    private static boolean isIgnoredNamespace(String prefix, String namespace) {
        return IGNORED_URIS.contains(namespace) || prefix.length() == 0 || "xmlns".equals(prefix);
    }

    private static void processElementDescriptors(XmlElementDescriptor descriptor, XmlTag tag, ElementNames names, Set<XmlElementDescriptor> history, int depth) throws StopProcessingException {
        XmlElementDescriptor[] descriptors;
        XmlAttributeDescriptor[] attributesDescriptors;
        if (!history.add(descriptor) || ++depth == 200) {
            if (depth == 200) {
                throw new StopProcessingException();
            }
            return;
        }
        String namespace = descriptor instanceof XmlElementDescriptorImpl ? ((XmlElementDescriptorImpl)descriptor).getNamespace() : tag.getNamespace();
        names.elementNames.add(new QName(namespace, descriptor.getName()));
        for (XmlAttributeDescriptor attributesDescriptor : attributesDescriptors = descriptor.getAttributesDescriptors(null)) {
            String localPart = attributesDescriptor.getName();
            if ("xmlns".equals(localPart)) continue;
            names.attributeNames.add(new QName(localPart));
        }
        for (XmlElementDescriptor elem : descriptors = descriptor.getElementsDescriptors(tag)) {
            XsltContextProviderBase.processElementDescriptors(elem, tag, names, history, depth);
        }
    }

    @Override
    public PsiFile[] getRelatedFiles(final XPathFile file) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getContextOfType((PsiElement)file, XmlAttribute.class, (boolean)false);
        assert (attribute != null);
        PsiFile psiFile = attribute.getContainingFile();
        assert (psiFile != null);
        final ArrayList files = new ArrayList();
        psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                PsiFile[] _files;
                for (PsiFile _file : _files = XsltSupport.getFiles(attribute)) {
                    if (_file == file) continue;
                    files.add(_file);
                }
            }
        });
        return PsiUtilCore.toPsiFileArray(files);
    }

    @Override
    @Nullable
    public XmlElement getContextElement() {
        return (XmlElement)this.myContextElement.getElement();
    }

    @Override
    @NotNull
    public XPathType getExpectedType(XPathExpression expr) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)expr, XmlTag.class, (boolean)true);
        if (tag != null && XsltSupport.isXsltTag(tag)) {
            XsltElement element = XsltElementFactory.getInstance().wrapElement(tag, XsltElement.class);
            if (element instanceof XsltVariable) {
                XPathType xPathType = ((XsltVariable)element).getType();
                if (xPathType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/context/XsltContextProviderBase", "getExpectedType"));
                }
                return xPathType;
            }
            XmlAttribute attr = (XmlAttribute)PsiTreeUtil.getContextOfType((PsiElement)expr, XmlAttribute.class, (boolean)true);
            if (attr != null) {
                if (element instanceof XsltWithParam) {
                    XmlAttributeValue valueElement;
                    XmlAttribute nameAttr = tag.getAttribute("name", null);
                    if (nameAttr != null && (valueElement = nameAttr.getValueElement()) != null) {
                        PsiReference[] references;
                        for (PsiReference reference : references = valueElement.getReferences()) {
                            PsiElement psiElement = reference.resolve();
                            if (!(psiElement instanceof XsltVariable)) continue;
                            XPathType xPathType = ((XsltVariable)psiElement).getType();
                            if (xPathType == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/context/XsltContextProviderBase", "getExpectedType"));
                            }
                            return xPathType;
                        }
                    }
                } else {
                    String name = attr.getName();
                    XPathType xPathType = this.getTypeForTag(tag, name);
                    if (xPathType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/context/XsltContextProviderBase", "getExpectedType"));
                    }
                    return xPathType;
                }
            }
        }
        XPathType xPathType = XPathType.UNKNOWN;
        if (xPathType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/context/XsltContextProviderBase", "getExpectedType"));
        }
        return xPathType;
    }

    protected XPathType getTypeForTag(XmlTag tag, String attribute) {
        String tagName = tag.getLocalName();
        if ("select".equals(attribute)) {
            if ("copy-of".equals(tagName) || "for-each".equals(tagName) || "apply-templates".equals(tagName)) {
                return XPathType.NODESET;
            }
            if ("value-of".equals(tagName) || "sort".equals(tagName)) {
                return XPathType.STRING;
            }
            return XPathType.ANY;
        }
        if ("test".equals(attribute)) {
            if ("if".equals(tagName) || "when".equals(tagName)) {
                return XPathType.BOOLEAN;
            }
        } else if ("number".equals(attribute) && "value".equals(tagName)) {
            return XPathType.NUMBER;
        }
        return XPathType.UNKNOWN;
    }

    @Override
    @NotNull
    public NamespaceContext getNamespaceContext() {
        XsltNamespaceContext xsltNamespaceContext = XsltNamespaceContext.NAMESPACE_CONTEXT;
        if (xsltNamespaceContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/context/XsltContextProviderBase", "getNamespaceContext"));
        }
        return xsltNamespaceContext;
    }

    @Override
    @NotNull
    public VariableContext getVariableContext() {
        XsltVariableContext xsltVariableContext = XsltVariableContext.INSTANCE;
        if (xsltVariableContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/context/XsltContextProviderBase", "getVariableContext"));
        }
        return xsltVariableContext;
    }

    @Override
    @Nullable
    public Set<QName> getAttributes(boolean forValidation) {
        ElementNames names = this.getNames(this.getFile());
        if (names != null) {
            return !forValidation || names.validateNames ? names.attributeNames : null;
        }
        return null;
    }

    @Override
    @Nullable
    public Set<QName> getElements(boolean forValidation) {
        ElementNames names = this.getNames(this.getFile());
        if (names != null) {
            return !forValidation || names.validateNames ? names.elementNames : null;
        }
        return null;
    }

    @Nullable
    private ElementNames getNames(@Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        return (ElementNames)((CachedValue)myNamesCache.get((Object)this)).getValue();
    }

    private CachedValue<ElementNames> createCachedValue(final PsiFile file) {
        return CachedValuesManager.getManager((Project)file.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<ElementNames>(){

            public CachedValueProvider.Result<ElementNames> compute() {
                final ElementNames names = new ElementNames();
                Object[] associations = XsltContextProviderBase.this.myFileAssociationsManager.getAssociationsFor(file, FileAssociationsManager.Holder.XML_FILES);
                if (associations.length == 0) {
                    XsltContextProviderBase.fillFromSchema(file, names);
                } else {
                    names.validateNames = true;
                    ContainerUtil.addAll((Collection)names.dependencies, (Object[])associations);
                }
                names.dependencies.add(XsltContextProviderBase.this.myFileAssociationsManager);
                for (Object file2 : associations) {
                    if (!(file2 instanceof XmlFile)) continue;
                    file2.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                        public void visitXmlTag(XmlTag tag) {
                            names.elementNames.add(QNameUtil.createQName(tag));
                            super.visitXmlTag(tag);
                        }

                        public void visitXmlAttribute(XmlAttribute attribute) {
                            if (!attribute.isNamespaceDeclaration()) {
                                names.attributeNames.add(QNameUtil.createQName(attribute));
                            }
                            super.visitXmlAttribute(attribute);
                        }
                    });
                }
                return new CachedValueProvider.Result((Object)names, ArrayUtil.toObjectArray((Collection)names.dependencies));
            }
        }, false);
    }

    @Nullable
    private PsiFile getFile() {
        XmlElement element = this.getContextElement();
        if (element == null) {
            return null;
        }
        return element.getContainingFile().getOriginalFile();
    }

    @Override
    @NotNull
    public XPathQuickFixFactory getQuickFixFactory() {
        XsltQuickFixFactory xsltQuickFixFactory = XsltQuickFixFactory.INSTANCE;
        if (xsltQuickFixFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/context/XsltContextProviderBase", "getQuickFixFactory"));
        }
        return xsltQuickFixFactory;
    }

    static {
        IGNORED_URIS.add("http://www.w3.org/1999/XSL/Transform");
        IGNORED_URIS.addAll(XmlUtil.ourSchemaUrisList);
        myNamesCache = new SimpleFieldCache<CachedValue<ElementNames>, XsltContextProviderBase>(){

            protected CachedValue<ElementNames> compute(XsltContextProviderBase xsltContextProvider) {
                return xsltContextProvider.createCachedValue(xsltContextProvider.getFile());
            }

            protected CachedValue<ElementNames> getValue(XsltContextProviderBase xsltContextProvider) {
                return xsltContextProvider.myNames;
            }

            protected void putValue(CachedValue<ElementNames> elementNamesCachedValue, XsltContextProviderBase xsltContextProvider) {
                xsltContextProvider.myNames = elementNamesCachedValue;
            }
        };
    }

    static class ElementNames {
        boolean validateNames;
        final Set<QName> elementNames = new HashSet<QName>();
        final Set<QName> attributeNames = new HashSet<QName>();
        final Set dependencies = new HashSet();

        ElementNames() {
        }
    }

    private static class StopProcessingException
    extends Exception {
        private StopProcessingException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

