/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.solver.ExecutionPath;
import android.databinding.tool.writer.KCode;
import java.util.ArrayList;
import java.util.List;

public class SymbolExpr
extends Expr {
    String mText;
    Class mType;

    SymbolExpr(String text, Class type) {
        super(new Expr[0]);
        this.mText = text;
        this.mType = type;
    }

    public String getText() {
        return this.mText;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        return modelAnalyzer.findClass(this.mType);
    }

    @Override
    protected String computeUniqueKey() {
        return this.mType.getSimpleName() + this.mText;
    }

    @Override
    public String getInvertibleError() {
        return "Symbol '" + this.mText + "' cannot be the target of a two-way binding expression";
    }

    @Override
    protected KCode generateCode(boolean expand) {
        return new KCode(this.getText());
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return new ArrayList<Dependency>();
    }

    @Override
    public boolean canBeEvaluatedToAVariable() {
        return !Void.TYPE.equals(this.mType);
    }

    @Override
    public List<ExecutionPath> toExecutionPath(List<ExecutionPath> paths) {
        if (Void.TYPE.equals(this.mType)) {
            return paths;
        }
        return super.toExecutionPath(paths);
    }
}

