/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.documentation.DockablePopupManager;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.codeInsight.documentation.DocumentationPreviewPanelProvider;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.BaseNavigateToSourceAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentationManager
extends DockablePopupManager<DocumentationComponent> {
    @NonNls
    public static final String JAVADOC_LOCATION_AND_SIZE = "javadoc.popup";
    public static final DataKey<String> SELECTED_QUICK_DOC_TEXT = DataKey.create((String)"QUICK_DOC.SELECTED_TEXT");
    private static final Logger LOG = Logger.getInstance((String)("#" + DocumentationManager.class.getName()));
    private static final String SHOW_DOCUMENTATION_IN_TOOL_WINDOW = "ShowDocumentationInToolWindow";
    private static final String DOCUMENTATION_AUTO_UPDATE_ENABLED = "DocumentationAutoUpdateEnabled";
    private static final long DOC_GENERATION_TIMEOUT_MILLISECONDS = 60000L;
    private static final long DOC_GENERATION_PAUSE_MILLISECONDS = 100L;
    private Editor myEditor;
    private final Alarm myUpdateDocAlarm;
    private WeakReference<JBPopup> myDocInfoHintRef;
    private Component myPreviouslyFocused;
    public static final Key<SmartPsiElementPointer> ORIGINAL_ELEMENT_KEY = Key.create((String)"Original element");
    private final ActionManager myActionManager;
    private final TargetElementUtil myTargetElementUtil;
    private boolean myCloseOnSneeze;
    private ActionCallback myLastAction;
    private DocumentationComponent myTestDocumentationComponent;
    private AnAction myRestorePopupAction;

    @Override
    protected String getToolwindowId() {
        return ToolWindowId.DOCUMENTATION;
    }

    @Override
    protected DocumentationComponent createComponent() {
        return new DocumentationComponent(this, this.createActions());
    }

    @Override
    protected String getRestorePopupDescription() {
        return "Restore popup view mode";
    }

    @Override
    protected String getAutoUpdateDescription() {
        return "Refresh documentation on selection change automatically";
    }

    @Override
    protected String getAutoUpdateTitle() {
        return "Auto-update from Source";
    }

    @Override
    @NotNull
    protected AnAction createRestorePopupAction() {
        AnAction anAction = this.myRestorePopupAction = super.createRestorePopupAction();
        if (anAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/DocumentationManager", "createRestorePopupAction"));
        }
        return anAction;
    }

    @Override
    protected void restorePopupBehavior() {
        if (this.myPreviouslyFocused != null) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.myPreviouslyFocused, true);
        }
        super.restorePopupBehavior();
        this.updateComponent();
    }

    @Override
    public void createToolWindow(PsiElement element, PsiElement originalElement) {
        super.createToolWindow(element, originalElement);
        if (this.myToolWindow != null) {
            this.myToolWindow.getComponent().putClientProperty("ChooseByNameBase.TemporarilyFocusableComponent", Boolean.TRUE);
            if (this.myRestorePopupAction != null) {
                ShortcutSet quickDocShortcut = ActionManager.getInstance().getAction("QuickJavaDoc").getShortcutSet();
                this.myRestorePopupAction.registerCustomShortcutSet(quickDocShortcut, this.myToolWindow.getComponent());
                this.myRestorePopupAction = null;
            }
        }
    }

    public boolean isCloseOnSneeze() {
        return this.myCloseOnSneeze;
    }

    public static DocumentationManager getInstance(Project project2) {
        return (DocumentationManager)ServiceManager.getService((Project)project2, DocumentationManager.class);
    }

    public DocumentationManager(Project project2, ActionManager manager, TargetElementUtil targetElementUtil) {
        super(project2);
        this.myActionManager = manager;
        AnActionListener actionListener = new AnActionListener(){

            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                JBPopup hint = DocumentationManager.this.getDocInfoHint();
                if (hint != null) {
                    if (action instanceof HintManagerImpl.ActionToIgnore) {
                        ((AbstractPopup)hint).focusPreferredComponent();
                        return;
                    }
                    if (action instanceof ScrollingUtil.ListScrollAction) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManager.getAction("EditorDown")) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManager.getAction("EditorUp")) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManager.getAction("EditorPageDown")) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManager.getAction("EditorPageUp")) {
                        return;
                    }
                    if (action == ActionManager.getInstance().getAction("EditorEscape")) {
                        return;
                    }
                    if ("JavadocInplaceSettings".equals(event.getPlace())) {
                        return;
                    }
                    if (action instanceof BaseNavigateToSourceAction) {
                        return;
                    }
                    DocumentationManager.this.closeDocHint();
                }
            }

            public void beforeEditorTyping(char c, DataContext dataContext) {
                JBPopup hint = DocumentationManager.this.getDocInfoHint();
                if (hint != null && LookupManager.getActiveLookup(DocumentationManager.this.myEditor) == null) {
                    hint.cancel();
                }
            }

            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            }
        };
        this.myActionManager.addAnActionListener(actionListener, (Disposable)project2);
        this.myUpdateDocAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
        this.myTargetElementUtil = targetElementUtil;
    }

    private void closeDocHint() {
        JBPopup hint = this.getDocInfoHint();
        if (hint == null) {
            return;
        }
        this.myCloseOnSneeze = false;
        hint.cancel();
        Component toFocus = this.myPreviouslyFocused;
        hint.cancel();
        if (toFocus != null) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(toFocus, true);
        }
    }

    public void setAllowContentUpdateFromContext(boolean allow) {
        if (this.hasActiveDockedDocWindow()) {
            this.restartAutoUpdate(allow);
        }
    }

    public void updateToolwindowContext() {
        if (this.hasActiveDockedDocWindow()) {
            this.updateComponent();
        }
    }

    public void showJavaDocInfoAtToolWindow(@NotNull PsiElement element, @NotNull PsiElement original) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "showJavaDocInfoAtToolWindow"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/codeInsight/documentation/DocumentationManager", "showJavaDocInfoAtToolWindow"));
        }
        Content content = this.recreateToolWindow(element, original);
        if (content == null) {
            return;
        }
        this.fetchDocInfo(this.getDefaultCollector(element, original), (DocumentationComponent)content.getComponent(), true);
    }

    public void showJavaDocInfo(@NotNull PsiElement element, PsiElement original) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "showJavaDocInfo"));
        }
        this.showJavaDocInfo(element, original, null);
    }

    public void showJavaDocInfo(@NotNull Editor editor, @NotNull PsiElement element, @NotNull PsiElement original, @Nullable Runnable closeCallback, boolean closeOnSneeze) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/documentation/DocumentationManager", "showJavaDocInfo"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "showJavaDocInfo"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/codeInsight/documentation/DocumentationManager", "showJavaDocInfo"));
        }
        this.myEditor = editor;
        this.myCloseOnSneeze = closeOnSneeze;
        this.showJavaDocInfo(element, original, closeCallback);
    }

    public void showJavaDocInfo(@NotNull PsiElement element, final PsiElement original, @Nullable Runnable closeCallback) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "showJavaDocInfo"));
        }
        if (!element.isValid()) {
            return;
        }
        PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(element.getProject()){

            public void updatePopup(Object lookupItemObject) {
                if (lookupItemObject instanceof PsiElement) {
                    DocumentationManager.this.doShowJavaDocInfo((PsiElement)lookupItemObject, false, this, original, null);
                }
            }
        };
        this.doShowJavaDocInfo(element, false, updateProcessor, original, closeCallback);
    }

    public void showJavaDocInfo(Editor editor, @Nullable PsiFile file2, boolean requestFocus) {
        this.showJavaDocInfo(editor, file2, requestFocus, null);
    }

    public void showJavaDocInfo(Editor editor, final @Nullable PsiFile file2, boolean requestFocus, final @Nullable Runnable closeCallback) {
        this.myEditor = editor;
        Project project2 = this.getProject((PsiElement)file2);
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        Object list = ParameterInfoController.findArgumentList(file2, editor.getCaretModel().getOffset(), -1);
        Object expressionList = null;
        if (list != null) {
            LookupEx lookup = LookupManager.getInstance(this.myProject).getActiveLookup();
            expressionList = lookup != null ? null : list;
        }
        final PsiElement originalElement = DocumentationManager.getContextElement(editor, file2);
        PsiElement element = this.assertSameProject(this.findTargetElement(editor, file2));
        if (element == null && expressionList != null) {
            element = expressionList;
        }
        if (element == null && file2 == null) {
            return;
        }
        if (element == null) {
            element = this.assertSameProject(originalElement);
            if (element == null) {
                return;
            }
            PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class);
            if (comment == null) {
                return;
            }
            PsiElement psiElement = element = comment instanceof PsiDocCommentBase ? ((PsiDocCommentBase)comment).getOwner() : comment.getParent();
            if (element == null) {
                return;
            }
        }
        PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(project2){

            public void updatePopup(Object lookupIteObject) {
                if (lookupIteObject == null) {
                    return;
                }
                if (lookupIteObject instanceof PsiElement) {
                    DocumentationManager.this.doShowJavaDocInfo((PsiElement)lookupIteObject, false, this, originalElement, closeCallback);
                    return;
                }
                DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)file2);
                PsiElement element = documentationProvider.getDocumentationElementForLookupItem(PsiManager.getInstance((Project)DocumentationManager.this.myProject), lookupIteObject, originalElement);
                if (element == null) {
                    return;
                }
                if (DocumentationManager.this.myEditor != null) {
                    PsiFile file22 = element.getContainingFile();
                    if (file22 != null) {
                        Editor editor = DocumentationManager.this.myEditor;
                        DocumentationManager.this.showJavaDocInfo(DocumentationManager.this.myEditor, file22, false);
                        DocumentationManager.this.myEditor = editor;
                    }
                } else {
                    DocumentationManager.this.doShowJavaDocInfo(element, false, this, originalElement, closeCallback);
                }
            }
        };
        this.doShowJavaDocInfo(element, requestFocus, updateProcessor, originalElement, closeCallback);
    }

    public PsiElement findTargetElement(Editor editor, PsiFile file2) {
        return this.findTargetElement(editor, file2, DocumentationManager.getContextElement(editor, file2));
    }

    private static PsiElement getContextElement(Editor editor, PsiFile file2) {
        return file2 != null ? file2.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    private void doShowJavaDocInfo(@NotNull PsiElement element, boolean requestFocus, PopupUpdateProcessor updateProcessor, PsiElement originalElement, @Nullable Runnable closeCallback) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "doShowJavaDocInfo"));
        }
        Project project2 = this.getProject(element);
        if (!project2.isOpen()) {
            return;
        }
        DocumentationManager.storeOriginalElement(project2, originalElement, element);
        this.myPreviouslyFocused = WindowManagerEx.getInstanceEx().getFocusedComponent(project2);
        JBPopup _oldHint = this.getDocInfoHint();
        if (PreviewManager.SERVICE.preview(this.myProject, DocumentationPreviewPanelProvider.ID, Couple.of((Object)element, (Object)originalElement), requestFocus) != null) {
            return;
        }
        if (this.myToolWindow == null && PropertiesComponent.getInstance().isTrueValue(SHOW_DOCUMENTATION_IN_TOOL_WINDOW)) {
            this.createToolWindow(element, originalElement);
        } else if (this.myToolWindow != null) {
            Content content = this.myToolWindow.getContentManager().getSelectedContent();
            if (content != null) {
                DocumentationComponent component = (DocumentationComponent)content.getComponent();
                boolean sameElement = element.getManager().areElementsEquivalent(component.getElement(), element);
                if (sameElement) {
                    boolean focus;
                    JComponent preferredFocusableComponent = content.getPreferredFocusableComponent();
                    boolean bl = focus = requestFocus || CommandProcessor.getInstance().getCurrentCommand() != null;
                    if (preferredFocusableComponent != null && focus) {
                        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)preferredFocusableComponent, true);
                    }
                }
                if (!sameElement || !component.isUpToDate()) {
                    content.setDisplayName(DocumentationManager.getTitle(element, true));
                    this.fetchDocInfo(this.getDefaultCollector(element, originalElement), component, true);
                }
            }
            if (!this.myToolWindow.isVisible()) {
                this.myToolWindow.show(null);
            }
        } else if (_oldHint != null && _oldHint.isVisible() && _oldHint instanceof AbstractPopup) {
            DocumentationComponent oldComponent = (DocumentationComponent)((AbstractPopup)_oldHint).getComponent();
            this.fetchDocInfo(this.getDefaultCollector(element, originalElement), oldComponent);
        } else {
            this.showInPopup(element, requestFocus, updateProcessor, originalElement, closeCallback);
        }
    }

    private void showInPopup(final @NotNull PsiElement element, boolean requestFocus, PopupUpdateProcessor updateProcessor, final PsiElement originalElement, @Nullable Runnable closeCallback) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "showInPopup"));
        }
        DocumentationComponent component = this.myTestDocumentationComponent == null ? new DocumentationComponent(this) : this.myTestDocumentationComponent;
        component.setNavigateCallback((Consumer<PsiElement>)((Consumer)psiElement -> {
            AbstractPopup jbPopup = (AbstractPopup)this.getDocInfoHint();
            if (jbPopup != null) {
                String title = DocumentationManager.getTitle(psiElement, false);
                jbPopup.setCaption(title);
                AccessibleContextUtil.setName((JComponent)component, (String)title);
            }
        }));
        Processor pinCallback = popup -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "lambda$showInPopup$1"));
            }
            this.createToolWindow(element, originalElement);
            this.myToolWindow.setAutoHide(false);
            popup.cancel();
            return false;
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocumentationManager.this.createToolWindow(element, originalElement);
                JBPopup hint = DocumentationManager.this.getDocInfoHint();
                if (hint != null && hint.isVisible()) {
                    hint.cancel();
                }
            }
        };
        List actions = ContainerUtil.newSmartList();
        AnAction quickDocAction = ActionManager.getInstance().getAction("QuickJavaDoc");
        for (Shortcut shortcut : quickDocAction.getShortcutSet().getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            actions.add(Pair.create((Object)actionListener, (Object)((KeyboardShortcut)shortcut).getFirstKeyStroke()));
        }
        boolean hasLookup = LookupManager.getActiveLookup(this.myEditor) != null;
        JBPopup hint = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, (JComponent)component).setProject(element.getProject()).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).setKeyboardActions(actions).setDimensionServiceKey(this.myProject, JAVADOC_LOCATION_AND_SIZE, false).setResizable(true).setMovable(true).setRequestFocus(requestFocus).setCancelOnClickOutside(!hasLookup).setTitle(DocumentationManager.getTitle(element, false)).setCouldPin(pinCallback).setModalContext(false).setCancelCallback(() -> {
            this.myCloseOnSneeze = false;
            if (closeCallback != null) {
                closeCallback.run();
            }
            if (this.fromQuickSearch()) {
                ((ChooseByNameBase.JPanelProvider)this.myPreviouslyFocused.getParent()).unregisterHint();
            }
            Disposer.dispose((Disposable)component);
            this.myEditor = null;
            this.myPreviouslyFocused = null;
            return Boolean.TRUE;
        }).setKeyEventHandler(e -> {
            if (this.myCloseOnSneeze) {
                this.closeDocHint();
            }
            if (AbstractPopup.isCloseRequest(e) && this.getDocInfoHint() != null) {
                this.closeDocHint();
                return true;
            }
            return false;
        }).createPopup();
        component.setHint(hint);
        if (this.myEditor == null) {
            LookupEx lookup = LookupManager.getInstance(this.myProject).getActiveLookup();
            this.myEditor = lookup != null ? lookup.getEditor() : null;
        }
        this.fetchDocInfo(this.getDefaultCollector(element, originalElement), component);
        this.myDocInfoHintRef = new WeakReference<JBPopup>(hint);
        if (this.fromQuickSearch() && this.myPreviouslyFocused != null) {
            ((ChooseByNameBase.JPanelProvider)this.myPreviouslyFocused.getParent()).registerHint(hint);
        }
    }

    static String getTitle(@NotNull PsiElement element, boolean _short) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "getTitle"));
        }
        String title = SymbolPresentationUtil.getSymbolPresentableText(element);
        return _short ? (title != null ? title : element.getText()) : CodeInsightBundle.message((String)"javadoc.info.title", (Object[])new Object[]{title != null ? title : element.getText()});
    }

    public static void storeOriginalElement(Project project2, PsiElement originalElement, PsiElement element) {
        if (element == null) {
            return;
        }
        try {
            element.putUserData(ORIGINAL_ELEMENT_KEY, (Object)SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer(originalElement));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Nullable
    public PsiElement findTargetElement(@NotNull Editor editor, @Nullable PsiFile file2, PsiElement contextElement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/documentation/DocumentationManager", "findTargetElement"));
        }
        return this.findTargetElement(editor, editor.getCaretModel().getOffset(), file2, contextElement);
    }

    @Nullable
    public PsiElement findTargetElement(Editor editor, int offset, @Nullable PsiFile file2, PsiElement contextElement) {
        try {
            return this.findTargetElementUnsafe(editor, offset, file2, contextElement);
        }
        catch (IndexNotReadyException inre) {
            LOG.warn("Index not ready");
            LOG.debug((Throwable)inre);
            return null;
        }
    }

    @Nullable
    private PsiElement findTargetElementUnsafe(Editor editor, int offset, @Nullable PsiFile file2, PsiElement contextElement) {
        PsiReference ref;
        PsiElement adjusted;
        DocumentationProvider documentationProvider;
        TargetElementUtil util = TargetElementUtil.getInstance();
        PsiElement element = this.assertSameProject(this.getElementFromLookup(editor, file2));
        if (element == null && file2 != null && (documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)file2)) instanceof DocumentationProviderEx) {
            element = this.assertSameProject(((DocumentationProviderEx)documentationProvider).getCustomDocumentationElement(editor, file2, contextElement));
        }
        if (element == null && ((element = this.assertSameProject(util.findTargetElement(editor, this.myTargetElementUtil.getAllAccepted(), offset))) != null || contextElement != null) && (adjusted = this.assertSameProject(util.adjustElement(editor, this.myTargetElementUtil.getAllAccepted(), element, contextElement))) != null) {
            element = adjusted;
        }
        if (element == null && (ref = TargetElementUtil.findReference(editor, offset)) != null) {
            element = this.assertSameProject(util.adjustReference(ref));
            if (ref instanceof PsiPolyVariantReference) {
                element = this.assertSameProject(ref.getElement());
            }
        }
        DocumentationManager.storeOriginalElement(this.myProject, contextElement, element);
        return element;
    }

    @Nullable
    public PsiElement getElementFromLookup(Editor editor, @Nullable PsiFile file2) {
        LookupElement item;
        LookupEx activeLookup = LookupManager.getInstance(this.myProject).getActiveLookup();
        if (activeLookup != null && (item = activeLookup.getCurrentItem()) != null) {
            PsiElement targetElement;
            int offset = editor.getCaretModel().getOffset();
            if (offset > 0 && offset == editor.getDocument().getTextLength()) {
                --offset;
            }
            PsiReference ref = TargetElementUtil.findReference(editor, offset);
            PsiElement contextElement = file2 == null ? null : file2.findElementAt(offset);
            PsiElement psiElement = targetElement = ref != null ? ref.getElement() : contextElement;
            if (targetElement != null) {
                PsiUtilCore.ensureValid((PsiElement)targetElement);
            }
            DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)file2);
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            return documentationProvider.getDocumentationElementForLookupItem(psiManager, item.getObject(), targetElement);
        }
        return null;
    }

    private boolean fromQuickSearch() {
        return this.myPreviouslyFocused != null && this.myPreviouslyFocused.getParent() instanceof ChooseByNameBase.JPanelProvider;
    }

    private DocumentationCollector getDefaultCollector(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "getDefaultCollector"));
        }
        return new DefaultDocumentationCollector(element, originalElement);
    }

    private DocumentationCollector getDefaultCollector(@NotNull PsiElement element, @Nullable PsiElement originalElement, String ref) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "getDefaultCollector"));
        }
        return new DefaultDocumentationCollector(element, originalElement, ref);
    }

    @Nullable
    public JBPopup getDocInfoHint() {
        if (this.myDocInfoHintRef == null) {
            return null;
        }
        JBPopup hint = (JBPopup)this.myDocInfoHintRef.get();
        if (hint == null || !hint.isVisible() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.myDocInfoHintRef = null;
            return null;
        }
        return hint;
    }

    public void fetchDocInfo(DocumentationCollector provider, DocumentationComponent component) {
        this.doFetchDocInfo(component, provider, true, false);
    }

    public void fetchDocInfo(DocumentationCollector provider, DocumentationComponent component, boolean clearHistory) {
        this.doFetchDocInfo(component, provider, true, clearHistory);
    }

    public void fetchDocInfo(PsiElement element, DocumentationComponent component) {
        this.doFetchDocInfo(component, this.getDefaultCollector(element, null), true, false);
    }

    private ActionCallback queueFetchDocInfo(DocumentationCollector provider, DocumentationComponent component, boolean clearHistory) {
        return this.doFetchDocInfo(component, provider, false, clearHistory);
    }

    public ActionCallback queueFetchDocInfo(PsiElement element, DocumentationComponent component) {
        return this.queueFetchDocInfo(this.getDefaultCollector(element, null), component, false);
    }

    private ActionCallback doFetchDocInfo(DocumentationComponent component, final DocumentationCollector provider, boolean cancelRequests, boolean clearHistory) {
        ActionCallback callback;
        this.myLastAction = callback = new ActionCallback();
        boolean wasEmpty = component.isEmpty();
        component.startWait();
        if (cancelRequests) {
            this.myUpdateDocAlarm.cancelAllRequests();
        }
        if (wasEmpty) {
            component.setText(CodeInsightBundle.message((String)"javadoc.fetching.progress", (Object[])new Object[0]), null, clearHistory);
            AbstractPopup jbPopup = (AbstractPopup)this.getDocInfoHint();
            if (jbPopup != null) {
                jbPopup.setDimensionServiceKey(null);
            }
        }
        this.myUpdateDocAlarm.addRequest(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            LOG.debug("Started fetching documentation...");
            Throwable[] ex = new Throwable[1];
            String text = null;
            try {
                text = provider.getDocumentation();
            }
            catch (Throwable e) {
                LOG.info(e);
                ex[0] = e;
            }
            if (ex[0] != null) {
                SwingUtilities.invokeLater(() -> {
                    String message = ex[0] instanceof IndexNotReadyException ? "Documentation is not available until indices are built." : CodeInsightBundle.message((String)"javadoc.external.fetch.error.message", (Object[])new Object[0]);
                    component.setText(message, null, true);
                    callback.setDone();
                });
                return;
            }
            LOG.debug("Documentation fetched successfully:\n", new Object[]{text});
            PsiElement element = (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiElement>(){

                @Nullable
                public PsiElement compute() {
                    return provider.getElement();
                }
            });
            if (element == null) {
                LOG.debug("Element for which documentation was requested is not available anymore");
                return;
            }
            String documentationText = text;
            PsiDocumentManager.getInstance((Project)this.myProject).performLaterWhenAllCommitted(() -> {
                if (!element.isValid()) {
                    LOG.debug("Element for which documentation was requested is not valid");
                    callback.setDone();
                    return;
                }
                if (documentationText == null) {
                    component.setText(CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0]), element, true, clearHistory);
                } else if (documentationText.isEmpty()) {
                    component.setText(component.getText(), element, true, clearHistory);
                } else {
                    component.setData(element, documentationText, clearHistory, provider.getEffectiveExternalUrl(), provider.getRef());
                }
                AbstractPopup jbPopup = (AbstractPopup)this.getDocInfoHint();
                if (jbPopup == null) {
                    callback.setDone();
                    return;
                }
                jbPopup.setDimensionServiceKey(JAVADOC_LOCATION_AND_SIZE);
                jbPopup.setCaption(DocumentationManager.getTitle(element, false));
                AccessibleContextUtil.setName((JComponent)component, (String)DocumentationManager.getTitle(element, false));
                callback.setDone();
            });
        }, 10);
        return callback;
    }

    @NotNull
    public static DocumentationProvider getProviderFromElement(PsiElement element) {
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement(element, null);
        if (documentationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/DocumentationManager", "getProviderFromElement"));
        }
        return documentationProvider;
    }

    @NotNull
    public static DocumentationProvider getProviderFromElement(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        if (element != null && !element.isValid()) {
            element = null;
        }
        if (originalElement != null && !originalElement.isValid()) {
            originalElement = null;
        }
        if (originalElement == null) {
            originalElement = DocumentationManager.getOriginalElement(element);
        }
        PsiFile containingFile = originalElement != null ? originalElement.getContainingFile() : (element != null ? element.getContainingFile() : null);
        LinkedHashSet<DocumentationProvider> result2 = new LinkedHashSet<DocumentationProvider>();
        Language containingFileLanguage = containingFile != null ? containingFile.getLanguage() : null;
        DocumentationProvider originalProvider = containingFile != null ? LanguageDocumentation.INSTANCE.forLanguage(containingFileLanguage) : null;
        Language elementLanguage = element != null ? element.getLanguage() : null;
        DocumentationProvider elementProvider = element == null || elementLanguage.is(containingFileLanguage) ? null : LanguageDocumentation.INSTANCE.forLanguage(elementLanguage);
        result2.add(elementProvider);
        result2.add(originalProvider);
        if (containingFile != null) {
            Language baseLanguage = containingFile.getViewProvider().getBaseLanguage();
            if (!baseLanguage.is(containingFileLanguage)) {
                result2.add(LanguageDocumentation.INSTANCE.forLanguage(baseLanguage));
            }
        } else if (element instanceof PsiDirectory) {
            HashSet<Language> langs = new HashSet<Language>();
            for (PsiFile file2 : ((PsiDirectory)element).getFiles()) {
                Language baseLanguage = file2.getViewProvider().getBaseLanguage();
                if (langs.contains(baseLanguage)) continue;
                langs.add(baseLanguage);
                result2.add(LanguageDocumentation.INSTANCE.forLanguage(baseLanguage));
            }
        }
        DocumentationProvider documentationProvider = CompositeDocumentationProvider.wrapProviders(result2);
        if (documentationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/DocumentationManager", "getProviderFromElement"));
        }
        return documentationProvider;
    }

    @Nullable
    public static PsiElement getOriginalElement(PsiElement element) {
        SmartPsiElementPointer originalElementPointer = element != null ? (SmartPsiElementPointer)element.getUserData(ORIGINAL_ELEMENT_KEY) : null;
        return originalElementPointer != null ? originalElementPointer.getElement() : null;
    }

    void navigateByLink(DocumentationComponent component, final String url) {
        component.setCursor(Cursor.getPredefinedCursor(3));
        final PsiElement psiElement = component.getElement();
        if (psiElement == null) {
            return;
        }
        PsiManager manager = PsiManager.getInstance((Project)this.getProject(psiElement));
        if (url.startsWith("open")) {
            PsiFile containingFile = psiElement.getContainingFile();
            OrderEntry libraryEntry = null;
            if (containingFile != null) {
                VirtualFile virtualFile = containingFile.getVirtualFile();
                libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)virtualFile, (Project)this.myProject);
            } else if (psiElement instanceof PsiDirectoryContainer) {
                PsiDirectory directory;
                VirtualFile virtualFile;
                PsiDirectory[] directories;
                PsiDirectory[] psiDirectoryArray = directories = ((PsiDirectoryContainer)psiElement).getDirectories();
                int n = psiDirectoryArray.length;
                for (int i = 0; i < n && (libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)(virtualFile = (directory = psiDirectoryArray[i]).getVirtualFile()), (Project)this.myProject)) == null; ++i) {
                }
            }
            if (libraryEntry != null) {
                ProjectSettingsService.getInstance(this.myProject).openLibraryOrSdkSettings(libraryEntry);
            }
        } else if (url.startsWith("psi_element://")) {
            Object object;
            DocumentationProvider provider;
            PsiElement targetElement;
            String refText = url.substring("psi_element://".length());
            int separatorPos = refText.lastIndexOf("###");
            String ref = null;
            if (separatorPos >= 0) {
                ref = refText.substring(separatorPos + "###".length());
                refText = refText.substring(0, separatorPos);
            }
            if ((targetElement = (provider = DocumentationManager.getProviderFromElement(psiElement)).getDocumentationElementForLink(manager, refText, psiElement)) == null) {
                Object documentationProvider;
                object = (DocumentationProvider[])Extensions.getExtensions((ExtensionPointName)DocumentationProvider.EP_NAME);
                int directory = ((DocumentationProvider[])object).length;
                for (int virtualFile = 0; virtualFile < directory && (targetElement = (documentationProvider = object[virtualFile]).getDocumentationElementForLink(manager, refText, psiElement)) == null; ++virtualFile) {
                }
            }
            if (targetElement == null) {
                Language language;
                DocumentationProvider documentationProvider;
                object = Language.getRegisteredLanguages().iterator();
                while (object.hasNext() && ((documentationProvider = LanguageDocumentation.INSTANCE.forLanguage(language = (Language)object.next())) == null || (targetElement = documentationProvider.getDocumentationElementForLink(manager, refText, psiElement)) == null)) {
                }
            }
            if (targetElement != null) {
                this.fetchDocInfo(this.getDefaultCollector(targetElement, null, ref), component);
            }
        } else {
            DocumentationProvider provider = DocumentationManager.getProviderFromElement(psiElement);
            boolean processed2 = false;
            if (provider instanceof CompositeDocumentationProvider) {
                for (DocumentationProvider p : ((CompositeDocumentationProvider)provider).getAllProviders()) {
                    if (!(p instanceof ExternalDocumentationHandler)) continue;
                    final ExternalDocumentationHandler externalHandler = (ExternalDocumentationHandler)p;
                    if (externalHandler.canFetchDocumentationLink(url)) {
                        this.fetchDocInfo(new DocumentationCollector(){

                            @Override
                            public String getDocumentation() throws Exception {
                                return externalHandler.fetchExternalDocumentation(url, psiElement);
                            }

                            @Override
                            public PsiElement getElement() {
                                return psiElement;
                            }

                            @Override
                            @Nullable
                            public String getEffectiveExternalUrl() {
                                return url;
                            }

                            @Override
                            @Nullable
                            public String getRef() {
                                return null;
                            }
                        }, component);
                        processed2 = true;
                        continue;
                    }
                    if (!externalHandler.handleExternalLink(manager, url, psiElement)) continue;
                    processed2 = true;
                    break;
                }
            }
            if (!processed2) {
                this.fetchDocInfo(new DocumentationCollector(){

                    @Override
                    public String getDocumentation() throws Exception {
                        if (BrowserUtil.isAbsoluteURL((String)url)) {
                            BrowserUtil.browse((String)url);
                            return "";
                        }
                        return CodeInsightBundle.message((String)"javadoc.error.resolving.url", (Object[])new Object[]{url});
                    }

                    @Override
                    public PsiElement getElement() {
                        return psiElement;
                    }

                    @Override
                    @Nullable
                    public String getEffectiveExternalUrl() {
                        return url;
                    }

                    @Override
                    @Nullable
                    public String getRef() {
                        return null;
                    }
                }, component);
            }
        }
        component.setCursor(Cursor.getPredefinedCursor(0));
    }

    void showHint(JBPopup hint) {
        Component focusOwner = IdeFocusManager.getInstance((Project)this.myProject).getFocusOwner();
        DataContext dataContext = DataManager.getInstance().getDataContext(focusOwner);
        PopupPositionManager.positionPopupInBestPosition(hint, this.myEditor, dataContext);
    }

    public void requestFocus() {
        if (this.fromQuickSearch()) {
            this.myPreviouslyFocused.getParent().requestFocus();
        }
    }

    public Project getProject(@Nullable PsiElement element) {
        this.assertSameProject(element);
        return this.myProject;
    }

    private PsiElement assertSameProject(@Nullable PsiElement element) {
        if (element != null && element.isValid() && this.myProject != element.getProject()) {
            throw new AssertionError((Object)(this.myProject + "!=" + element.getProject() + "; element=" + element));
        }
        return element;
    }

    public static void createHyperlink(StringBuilder buffer, String refText, String label, boolean plainLink) {
        DocumentationManagerUtil.createHyperlink((StringBuilder)buffer, (String)refText, (String)label, (boolean)plainLink);
    }

    @Override
    public String getShowInToolWindowProperty() {
        return SHOW_DOCUMENTATION_IN_TOOL_WINDOW;
    }

    @Override
    public String getAutoUpdateEnabledProperty() {
        return DOCUMENTATION_AUTO_UPDATE_ENABLED;
    }

    @Override
    protected void doUpdateComponent(PsiElement element, PsiElement originalElement, DocumentationComponent component) {
        this.fetchDocInfo(this.getDefaultCollector(element, originalElement), component);
    }

    @Override
    protected void doUpdateComponent(Editor editor, PsiFile psiFile) {
        this.showJavaDocInfo(editor, psiFile, false, null);
    }

    @Override
    protected void doUpdateComponent(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "doUpdateComponent"));
        }
        this.showJavaDocInfo(element, element, null);
    }

    @Override
    protected String getTitle(PsiElement element) {
        return DocumentationManager.getTitle(element, true);
    }

    @Nullable
    public Image getElementImage(@NotNull PsiElement element, @NotNull String imageSpec) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/DocumentationManager", "getElementImage"));
        }
        if (imageSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageSpec", "com/intellij/codeInsight/documentation/DocumentationManager", "getElementImage"));
        }
        DocumentationProvider provider = DocumentationManager.getProviderFromElement(element);
        if (provider instanceof CompositeDocumentationProvider) {
            for (DocumentationProvider p : ((CompositeDocumentationProvider)provider).getAllProviders()) {
                Image image;
                if (!(p instanceof DocumentationProviderEx) || (image = ((DocumentationProviderEx)p).getLocalImageForElement(element, imageSpec)) == null) continue;
                return image;
            }
        }
        return null;
    }

    Editor getEditor() {
        return this.myEditor;
    }

    public ActionCallback getLastAction() {
        return this.myLastAction;
    }

    public void setDocumentationComponent(DocumentationComponent documentationComponent) {
        this.myTestDocumentationComponent = documentationComponent;
    }

    private class DefaultDocumentationCollector
    implements DocumentationCollector {
        private final PsiElement myElement;
        private final PsiElement myOriginalElement;
        private final String myRef;
        private String myEffectiveUrl;

        private DefaultDocumentationCollector(PsiElement element, PsiElement originalElement) {
            this(element, originalElement, (String)null);
        }

        private DefaultDocumentationCollector(PsiElement element, PsiElement originalElement, String ref) {
            this.myElement = element;
            this.myOriginalElement = originalElement;
            this.myRef = ref;
        }

        @Override
        @Nullable
        public String getDocumentation() throws Exception {
            final DocumentationProvider provider = (DocumentationProvider)ApplicationManager.getApplication().runReadAction((Computable)new Computable<DocumentationProvider>(){

                public DocumentationProvider compute() {
                    return DocumentationManager.getProviderFromElement(DefaultDocumentationCollector.this.myElement, DefaultDocumentationCollector.this.myOriginalElement);
                }
            });
            LOG.debug("Using provider ", new Object[]{provider});
            if (provider instanceof ExternalDocumentationProvider) {
                List urls = (List)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<List<String>>(){

                    public List<String> compute() {
                        PsiElement originalElement;
                        SmartPsiElementPointer originalElementPtr = (SmartPsiElementPointer)DefaultDocumentationCollector.this.myElement.getUserData(ORIGINAL_ELEMENT_KEY);
                        PsiElement psiElement = originalElement = originalElementPtr != null ? originalElementPtr.getElement() : null;
                        if (((ExternalDocumentationProvider)provider).hasDocumentationFor(DefaultDocumentationCollector.this.myElement, originalElement)) {
                            return provider.getUrlFor(DefaultDocumentationCollector.this.myElement, originalElement);
                        }
                        return null;
                    }
                });
                LOG.debug("External documentation URLs: ", new Object[]{urls});
                if (urls != null) {
                    for (String url : urls) {
                        String doc = ((ExternalDocumentationProvider)provider).fetchExternalDocumentation(DocumentationManager.this.myProject, this.myElement, Collections.singletonList(url));
                        if (doc == null) continue;
                        LOG.debug("Fetched documentation from ", new Object[]{url});
                        this.myEffectiveUrl = url;
                        return doc;
                    }
                }
            }
            Ref result2 = new Ref();
            QuickDocUtil.runInReadActionWithWriteActionPriorityWithRetries(() -> {
                SmartPsiElementPointer originalElement = (SmartPsiElementPointer)this.myElement.getUserData(ORIGINAL_ELEMENT_KEY);
                String doc = provider.generateDoc(this.myElement, originalElement != null ? originalElement.getElement() : null);
                result2.set((Object)doc);
            }, 60000L, 100L, null);
            return (String)result2.get();
        }

        @Override
        @Nullable
        public PsiElement getElement() {
            return this.myElement.isValid() ? this.myElement : null;
        }

        @Override
        @Nullable
        public String getEffectiveExternalUrl() {
            return this.myEffectiveUrl;
        }

        @Override
        @Nullable
        public String getRef() {
            return this.myRef;
        }
    }

    private static interface DocumentationCollector {
        @Nullable
        public String getDocumentation() throws Exception;

        @Nullable
        public PsiElement getElement();

        @Nullable
        public String getEffectiveExternalUrl();

        @Nullable
        public String getRef();
    }
}

