/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MoverWrapper {
    private static final Logger LOGGER = Logger.getInstance(MoverWrapper.class);
    protected final boolean myIsDown;
    private final StatementUpDownMover myMover;
    private final StatementUpDownMover.MoveInfo myInfo;

    protected MoverWrapper(@NotNull StatementUpDownMover mover, @NotNull StatementUpDownMover.MoveInfo info, boolean isDown) {
        if (mover == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mover", "com/intellij/codeInsight/editorActions/moveUpDown/MoverWrapper", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/editorActions/moveUpDown/MoverWrapper", "<init>"));
        }
        this.myMover = mover;
        this.myIsDown = isDown;
        this.myInfo = info;
    }

    public StatementUpDownMover.MoveInfo getInfo() {
        return this.myInfo;
    }

    public final void move(Editor editor, PsiFile file2) {
        TextRange range2;
        TextRange range;
        assert (this.myInfo.toMove2 != null);
        this.myMover.beforeMove(editor, this.myInfo, this.myIsDown);
        Document document2 = editor.getDocument();
        int start = StatementUpDownMover.getLineStartSafeOffset((Document)document2, (int)this.myInfo.toMove.startLine);
        int end = StatementUpDownMover.getLineStartSafeOffset((Document)document2, (int)this.myInfo.toMove.endLine);
        String textToInsert = document2.getCharsSequence().subSequence(start, end).toString();
        if (!StringUtil.endsWithChar((CharSequence)textToInsert, (char)'\n')) {
            textToInsert = textToInsert + '\n';
        }
        int start2 = document2.getLineStartOffset(this.myInfo.toMove2.startLine);
        int end2 = StatementUpDownMover.getLineStartSafeOffset((Document)document2, (int)this.myInfo.toMove2.endLine);
        String textToInsert2 = document2.getCharsSequence().subSequence(start2, end2).toString();
        if (!StringUtil.endsWithChar((CharSequence)textToInsert2, (char)'\n')) {
            textToInsert2 = textToInsert2 + '\n';
        }
        if ((range = new TextRange(start, end)).intersectsStrict(range2 = new TextRange(start2, end2)) && !range.equals((Object)range2)) {
            LOGGER.error("Wrong move ranges: " + start + ":" + end + "(" + textToInsert + "), " + start2 + ":" + end2 + "(" + textToInsert2 + "), mover: " + this.myMover);
            return;
        }
        this.myInfo.range1 = document2.createRangeMarker(start, end);
        this.myInfo.range2 = document2.createRangeMarker(start2, end2);
        if (this.myInfo.range1.getStartOffset() < this.myInfo.range2.getStartOffset()) {
            this.myInfo.range1.setGreedyToLeft(true);
            this.myInfo.range1.setGreedyToRight(false);
            this.myInfo.range2.setGreedyToLeft(true);
            this.myInfo.range2.setGreedyToRight(true);
        } else {
            this.myInfo.range1.setGreedyToLeft(true);
            this.myInfo.range1.setGreedyToRight(true);
            this.myInfo.range2.setGreedyToLeft(true);
            this.myInfo.range2.setGreedyToRight(false);
        }
        CaretModel caretModel = editor.getCaretModel();
        int caretRelativePos = caretModel.getOffset() - start;
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        boolean hasSelection = selectionModel.hasSelection();
        caretModel.moveToOffset(0);
        FoldRegion topRegion = MoverWrapper.findTopLevelRegionInRange(editor, this.myInfo.range1);
        FoldRegion bottomRegion = MoverWrapper.findTopLevelRegionInRange(editor, this.myInfo.range2);
        document2.insertString(this.myInfo.range1.getStartOffset(), (CharSequence)textToInsert2);
        document2.deleteString(this.myInfo.range1.getStartOffset() + textToInsert2.length(), this.myInfo.range1.getEndOffset());
        document2.insertString(this.myInfo.range2.getStartOffset(), (CharSequence)textToInsert);
        int s = this.myInfo.range2.getStartOffset() + textToInsert.length();
        int e = this.myInfo.range2.getEndOffset();
        if (e > s) {
            document2.deleteString(s, e);
        }
        Project project2 = file2.getProject();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        if (topRegion != null && bottomRegion != null) {
            CodeFoldingManager.getInstance(project2).updateFoldRegions(editor);
            editor.getFoldingModel().runBatchFoldingOperation(() -> {
                FoldRegion newBottomRegion;
                FoldRegion newTopRegion = MoverWrapper.findTopLevelRegionInRange(editor, this.myInfo.range1);
                if (newTopRegion != null) {
                    newTopRegion.setExpanded(bottomRegion.isExpanded());
                }
                if ((newBottomRegion = MoverWrapper.findTopLevelRegionInRange(editor, this.myInfo.range2)) != null) {
                    newBottomRegion.setExpanded(topRegion.isExpanded());
                }
            });
        }
        if (hasSelection) {
            MoverWrapper.restoreSelection(editor, selectionStart, selectionEnd, start, this.myInfo.range2.getStartOffset());
        }
        caretModel.moveToOffset(this.myInfo.range2.getStartOffset() + caretRelativePos);
        this.myMover.afterMove(editor, file2, this.myInfo, this.myIsDown);
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        if (this.myInfo.indentTarget) {
            MoverWrapper.indentLinesIn(editor, file2, document2, project2, this.myInfo.range2);
        }
        if (this.myInfo.indentSource) {
            MoverWrapper.indentLinesIn(editor, file2, document2, project2, this.myInfo.range1);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    private static FoldRegion findTopLevelRegionInRange(Editor editor, RangeMarker range) {
        FoldRegion result2 = null;
        for (FoldRegion foldRegion : editor.getFoldingModel().getAllFoldRegions()) {
            if (!foldRegion.isValid() || !MoverWrapper.contains(range, foldRegion) || MoverWrapper.contains(result2, foldRegion)) continue;
            result2 = foldRegion;
        }
        return result2;
    }

    private static boolean contains(@NotNull RangeMarker rangeMarker, @NotNull FoldRegion foldRegion) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/codeInsight/editorActions/moveUpDown/MoverWrapper", "contains"));
        }
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegion", "com/intellij/codeInsight/editorActions/moveUpDown/MoverWrapper", "contains"));
        }
        return rangeMarker.getStartOffset() <= foldRegion.getStartOffset() && rangeMarker.getEndOffset() >= foldRegion.getEndOffset();
    }

    private static boolean contains(@Nullable FoldRegion region1, @NotNull FoldRegion region2) {
        if (region2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region2", "com/intellij/codeInsight/editorActions/moveUpDown/MoverWrapper", "contains"));
        }
        if (region1 == null) {
            return false;
        }
        return region1.getStartOffset() <= region2.getStartOffset() && region1.getEndOffset() >= region2.getEndOffset();
    }

    private static void indentLinesIn(Editor editor, PsiFile file2, Document document2, Project project2, RangeMarker range) {
        int line1;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        int line2 = editor.offsetToLogicalPosition((int)range.getEndOffset()).line;
        for (line1 = editor.offsetToLogicalPosition((int)range.getStartOffset()).line; !MoverWrapper.lineContainsNonSpaces(document2, line1) && line1 < line2; ++line1) {
        }
        while (!MoverWrapper.lineContainsNonSpaces(document2, line2) && line1 < line2) {
            --line2;
        }
        FileViewProvider provider = file2.getViewProvider();
        PsiFile rootToAdjustIndentIn = provider.getPsi(provider.getBaseLanguage());
        codeStyleManager.adjustLineIndent(rootToAdjustIndentIn, new TextRange(document2.getLineStartOffset(line1), document2.getLineStartOffset(line2)));
    }

    private static boolean lineContainsNonSpaces(Document document2, int line) {
        if (line >= document2.getLineCount()) {
            return false;
        }
        int lineStartOffset = document2.getLineStartOffset(line);
        int lineEndOffset = document2.getLineEndOffset(line);
        String text = document2.getCharsSequence().subSequence(lineStartOffset, lineEndOffset).toString();
        return text.trim().length() != 0;
    }

    private static void restoreSelection(Editor editor, int selectionStart, int selectionEnd, int moveOffset, int insOffset) {
        int selectionRelativeOffset = selectionStart - moveOffset;
        int newSelectionStart = insOffset + selectionRelativeOffset;
        int newSelectionEnd = newSelectionStart + selectionEnd - selectionStart;
        EditorUtil.setSelectionExpandingFoldedRegionsIfNeeded(editor, newSelectionStart, newSelectionEnd);
    }
}

