/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelfManagingCommenterUtil {
    @Nullable
    public static TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document2, @NotNull String prefix, @NotNull String suffix) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/generation/SelfManagingCommenterUtil", "getBlockCommentRange"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/codeInsight/generation/SelfManagingCommenterUtil", "getBlockCommentRange"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/codeInsight/generation/SelfManagingCommenterUtil", "getBlockCommentRange"));
        }
        CharSequence sequence = document2.getCharsSequence();
        selectionStart = CharArrayUtil.shiftForward((CharSequence)sequence, (int)selectionStart, (String)" \t\n");
        if ((selectionEnd = CharArrayUtil.shiftBackward((CharSequence)sequence, (int)(selectionEnd - 1), (String)" \t\n") + 1) < selectionStart) {
            selectionEnd = selectionStart;
        }
        if (CharArrayUtil.regionMatches((CharSequence)sequence, (int)(selectionEnd - suffix.length()), (CharSequence)suffix) && CharArrayUtil.regionMatches((CharSequence)sequence, (int)selectionStart, (CharSequence)prefix)) {
            return new TextRange(selectionStart, selectionEnd);
        }
        return null;
    }

    @NotNull
    public static TextRange insertBlockComment(int startOffset, int endOffset, @NotNull Document document2, @NotNull String prefix, @NotNull String suffix) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/generation/SelfManagingCommenterUtil", "insertBlockComment"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/codeInsight/generation/SelfManagingCommenterUtil", "insertBlockComment"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/codeInsight/generation/SelfManagingCommenterUtil", "insertBlockComment"));
        }
        document2.insertString(startOffset, (CharSequence)prefix);
        document2.insertString(endOffset + prefix.length(), (CharSequence)suffix);
        TextRange textRange = new TextRange(startOffset, endOffset + prefix.length() + suffix.length());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/SelfManagingCommenterUtil", "insertBlockComment"));
        }
        return textRange;
    }

    public static void uncommentBlockComment(int startOffset, int endOffset, @NotNull Document document2, @NotNull String prefix, @NotNull String suffix) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/generation/SelfManagingCommenterUtil", "uncommentBlockComment"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/codeInsight/generation/SelfManagingCommenterUtil", "uncommentBlockComment"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/codeInsight/generation/SelfManagingCommenterUtil", "uncommentBlockComment"));
        }
        document2.deleteString(endOffset - suffix.length(), endOffset);
        document2.deleteString(startOffset, startOffset + prefix.length());
    }
}

