/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.RefElementAndDescriptorAware;
import com.intellij.openapi.project.Project;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

public abstract class CachedInspectionTreeNode
extends InspectionTreeNode
implements RefElementAndDescriptorAware {
    private volatile String myPresentableName;
    private volatile Boolean myValid;

    protected CachedInspectionTreeNode(Object userObject) {
        super(userObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isValid() {
        Boolean valid = this.myValid;
        if (valid != null) {
            return valid;
        }
        CachedInspectionTreeNode cachedInspectionTreeNode = this;
        synchronized (cachedInspectionTreeNode) {
            valid = this.myValid;
            if (valid == null) {
                this.myValid = valid = Boolean.valueOf(this.calculateIsValid());
            }
            return valid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String toString() {
        String name = this.myPresentableName;
        if (name != null) {
            return name;
        }
        CachedInspectionTreeNode cachedInspectionTreeNode = this;
        synchronized (cachedInspectionTreeNode) {
            name = this.myPresentableName;
            if (name == null) {
                this.myPresentableName = name = this.calculatePresentableName();
            }
            return name;
        }
    }

    protected void init(Project project2) {
        this.myPresentableName = this.calculatePresentableName();
        this.myValid = this.calculateIsValid();
    }

    protected abstract String calculatePresentableName();

    protected abstract boolean calculateIsValid();

    protected void dropCache(Project project2) {
        this.myValid = this.calculateIsValid();
        this.myPresentableName = this.calculatePresentableName();
        for (int i = 0; i < this.getChildCount(); ++i) {
            TreeNode child = this.getChildAt(i);
            if (!(child instanceof CachedInspectionTreeNode)) continue;
            ((CachedInspectionTreeNode)child).dropCache(project2);
        }
    }

    @Override
    @Nullable
    public String getCustomizedTailText() {
        return this.isValid() ? null : "No longer valid";
    }
}

