/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.actions.InspectionViewActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class KeyAwareInspectionViewAction
extends InspectionViewActionBase {
    private static final Logger LOG = Logger.getInstance(KeyAwareInspectionViewAction.class);

    public KeyAwareInspectionViewAction(String name) {
        super(name);
    }

    @Override
    protected boolean isEnabled(@NotNull InspectionResultsView view, AnActionEvent e) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction", "isEnabled"));
        }
        InspectionToolWrapper wrapper = view.getTree().getSelectedToolWrapper(true);
        return wrapper != null && HighlightDisplayKey.find((String)wrapper.getShortName()) != null;
    }

    public void actionPerformed(AnActionEvent e) {
        InspectionResultsView view = KeyAwareInspectionViewAction.getView(e);
        HighlightDisplayKey key2 = HighlightDisplayKey.find((String)view.getTree().getSelectedToolWrapper(true).getShortName());
        this.actionPerformed(view, key2);
    }

    protected abstract void actionPerformed(@NotNull InspectionResultsView var1, @NotNull HighlightDisplayKey var2);

    public static class RunInspectionOn
    extends KeyAwareInspectionViewAction {
        public RunInspectionOn() {
            super(InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0]));
        }

        @Override
        protected boolean isEnabled(@NotNull InspectionResultsView view, AnActionEvent e) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$RunInspectionOn", "isEnabled"));
            }
            return super.isEnabled(view, e) && RunInspectionOn.getPsiElement(view) != null;
        }

        @Override
        protected void actionPerformed(@NotNull InspectionResultsView view, @NotNull HighlightDisplayKey key2) {
            AnalysisScope scope;
            PsiFile context;
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$RunInspectionOn", "actionPerformed"));
            }
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$RunInspectionOn", "actionPerformed"));
            }
            THashSet files = new THashSet();
            for (RefEntity entity : view.getTree().getSelectedElements()) {
                if (!(entity instanceof RefElement) || !entity.isValid()) continue;
                PsiElement element = ((RefElement)entity).getElement();
                PsiFile file2 = element.getContainingFile();
                files.add(file2);
            }
            boolean useModule = true;
            Module module2 = null;
            for (PsiFile file3 : files) {
                Module currentFileModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)file3);
                if (currentFileModule != null) {
                    if (module2 == null) {
                        module2 = currentFileModule;
                        continue;
                    }
                    if (currentFileModule == module2) continue;
                    useModule = false;
                    break;
                }
                useModule = false;
                break;
            }
            switch (files.size()) {
                case 0: {
                    context = null;
                    scope = view.getScope();
                    break;
                }
                case 1: {
                    PsiFile theFile = (PsiFile)ContainerUtil.getFirstItem((Collection)files);
                    LOG.assertTrue(theFile != null);
                    context = theFile;
                    scope = new AnalysisScope(theFile);
                    break;
                }
                default: {
                    context = null;
                    scope = new AnalysisScope(view.getProject(), (Collection)files.stream().map(PsiFile::getVirtualFile).collect(Collectors.toList()));
                }
            }
            RunInspectionIntention.selectScopeAndRunInspection(key2.toString(), scope, (Module)(useModule ? module2 : null), (PsiElement)context, view.getProject());
        }

        @Nullable
        private static PsiElement getPsiElement(InspectionResultsView view) {
            RefEntity[] selectedElements = view.getTree().getSelectedElements();
            PsiElement psiElement = selectedElements.length > 0 && selectedElements[0] instanceof RefElement ? ((RefElement)selectedElements[0]).getElement() : null;
            return psiElement;
        }
    }

    public static class DisableInspection
    extends KeyAwareInspectionViewAction {
        public DisableInspection() {
            super(DisableInspectionToolAction.NAME);
        }

        @Override
        protected boolean isEnabled(@NotNull InspectionResultsView view, AnActionEvent e) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$DisableInspection", "isEnabled"));
            }
            boolean enabled = super.isEnabled(view, e);
            if (!enabled) {
                return false;
            }
            HighlightDisplayKey key2 = HighlightDisplayKey.find((String)view.getTree().getSelectedToolWrapper(true).getShortName());
            InspectionProfile profile = (InspectionProfile)InspectionProjectProfileManager.getInstance(view.getProject()).getProjectProfileImpl();
            return profile.isToolEnabled(key2);
        }

        @Override
        protected void actionPerformed(@NotNull InspectionResultsView view, @NotNull HighlightDisplayKey key2) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$DisableInspection", "actionPerformed"));
            }
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ui/actions/KeyAwareInspectionViewAction$DisableInspection", "actionPerformed"));
            }
            try {
                if (view.isSingleInspectionRun()) {
                    ModifiableModel model = view.getCurrentProfile().getModifiableModel();
                    model.disableTool(key2.toString(), view.getProject());
                    model.commit();
                    view.updateCurrentProfile();
                } else {
                    RefEntity[] selectedElements = view.getTree().getSelectedElements();
                    HashSet<PsiElement> files = new HashSet<PsiElement>();
                    Project project2 = view.getProject();
                    InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(project2);
                    for (RefEntity selectedElement : selectedElements) {
                        if (!(selectedElement instanceof RefElement)) continue;
                        PsiElement element = ((RefElement)selectedElement).getElement();
                        files.add(element);
                    }
                    ModifiableModel model = ((InspectionProfileImpl)profileManager.getProjectProfileImpl()).getModifiableModel();
                    for (PsiElement element : files) {
                        model.disableTool(key2.toString(), element);
                    }
                    model.commit();
                    DaemonCodeAnalyzer.getInstance((Project)project2).restart();
                }
            }
            catch (IOException e1) {
                Messages.showErrorDialog((Project)view.getProject(), (String)e1.getMessage(), (String)CommonBundle.getErrorTitle());
            }
        }
    }
}

